program TestGorgParser;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

uses
  GorgParser, KMeans, DataUtils,SysUtils,ReportUtils,Math;

var
  alarms: TGorgAlarmArray;
  features: TDoubleMatrix;
  model: TKMeans;
  i,j, cluster: Integer;
begin
  alarms := ParseGorgFile(GetEnvironmentVariable('HOME') + '/.gorg64/gorg.txt');
  features := PrepareFeatures(alarms);

writeln('Features before normalization:');
for i := 0 to High(features) do
begin
  for j := 0 to High(features[i]) do
    write(features[i][j]:10:4);
  writeln;
end;

  NormalizeData(features);
  TrainKMeans(model, features, 3);

  for i := 0 to High(alarms) do
  begin
    cluster := PredictKMeans(model, features[i]);
    WriteLn(Format('Alarm %d: %02d:%02d "%s" -> Cluster %d', 
      [i, alarms[i].hour, alarms[i].minute, alarms[i].message, cluster]));
  end;

// В TestGorgParser.pas после кластеризации:
SaveClustersToCSV('alarms_report.csv', alarms, model);
PrintClusterStats(model);

// Вывод в консоль:
WriteLn('Результаты сохранены в alarms_report.csv');
WriteLn('Статистика кластеров:');
for i := 0 to High(model.centroids) do
begin
  WriteLn(Format('Cluster %d: %s', [i, AnalyzeCluster(model.centroids[i])]));
  WriteLn('Примеры:');
  for j := 0 to Min(High(alarms), 3) do
    if PredictKMeans(model, PrepareFeatures([alarms[j]])[0]) = i then
      WriteLn('  ', alarms[j].hour, ':', alarms[j].minute, ' ', alarms[j].message);
end;

end.