program TestKMeans;{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

uses
  SysUtils, KMeans, DataUtils;

var
  x: TDoubleMatrix;
  model: TKMeans;
  i, j: Integer;
  point: TDoubleArray;
  cluster: Integer;
begin
  try
    // Создание тестовых данных
    SetLength(x, 6, 2);
    x[0] := [1.0, 2.0];
    x[1] := [1.5, 2.5];
    x[2] := [3.0, 4.0];
    x[3] := [5.0, 6.0];
    x[4] := [5.5, 6.5];
    x[5] := [7.0, 8.0];

    // Обучение модели
    TrainKMeans(model, x, 2);

    // Вывод центроидов
    WriteLn('Центроиды:');
    for i := 0 to High(model.centroids) do
    begin
      Write('Центроид ', i, ': ');
      for j := 0 to High(model.centroids[i]) do
        Write(model.centroids[i][j]:0:2, ' ');
      WriteLn;
    end;

    // Вывод меток кластеров
    WriteLn('Метки кластеров:');
    for i := 0 to High(model.labels) do
      WriteLn('Точка ', i, ' -> Кластер ', model.labels[i]);

    // Предсказание для новой точки
    point := [2.0, 3.0];
    cluster := PredictKMeans(model, point);
    WriteLn('Точка [2.0, 3.0] назначена кластеру ', cluster);
  except
    on E: Exception do
      WriteLn('Ошибка: ', E.Message);
  end;
end.