procedure TestRAMLoad;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

var
  content: TFileContent;
begin
  WriteLn('Testing RAM loading...');
  
  // Пробуем загрузить небольшой файл в RAM
  content := TUniversalFileReader.QuickRead('small_file.txt', True);
  WriteLn('IsInRAM: ', content.InRAM);
  
  // Пробуем загрузить большой файл (должен остаться в mmap)
  content := TUniversalFileReader.QuickRead('large_video.mp4', True);
  WriteLn('IsInRAM: ', content.InRAM);
end;