unit TextAnalyzer;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}

interface

uses
  SysUtils, Classes, Lemmatizer, NLPUtils;

type
  TTextAnalyzer = class
  private
    FLemmatizer: TLemmatizer;
  public
    constructor Create(const DictPath: string);
    destructor Destroy; override;
    function AnalyzeText(const Text: string): TStringArray;
  end;

implementation

constructor TTextAnalyzer.Create(const DictPath: string);
begin
  FLemmatizer := TLemmatizer.Create(DictPath);
end;

destructor TTextAnalyzer.Destroy;
begin
  FLemmatizer.Free;
  inherited;
end;

function TTextAnalyzer.AnalyzeText(const Text: string): TStringArray;
var
  Tokens: TStringArray;
  Lemmas: TStringArray;
  i: Integer;
begin
  Tokens := Tokenize(Text); // Используем функцию из NLPUtils
  SetLength(Lemmas, Length(Tokens));
  
  for i := 0 to High(Tokens) do
    Lemmas[i] := FLemmatizer.Lemmatize(Tokens[i]);
    
  Result := Lemmas;
end;

end.