{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}

program DecisionTreeTest;

uses
  SysUtils, DecisionTree,DataTypes;

var
  tree: TDecisionTree;
  x: TDoubleMatrix;
  y: TDoubleArray;
  testSample: TDoubleArray;
  prediction: Double;
begin
  // Данные для обучения
  SetLength(x, 4, 2);
  x[0][0] := 1.0; x[0][1] := 2.0;
  x[1][0] := 1.5; x[1][1] := 2.5;
  x[2][0] := 3.0; x[2][1] := 3.0;
  x[3][0] := 3.5; x[3][1] := 3.5;
  
  SetLength(y, 4);
  y[0] := 0;
  y[1] := 0;
  y[2] := 1;
  y[3] := 1;

  // Обучение дерева решений
  TrainDecisionTree(tree, x, y, 3, 1);
  
  // Тестовое предсказание
  SetLength(testSample, 2);
  testSample[0] := 2.0;
  testSample[1] := 2.0;
  
  prediction := PredictDecisionTree(tree, testSample);
  WriteLn('Prediction: ', prediction:0:2);

  // Очистка памяти
  FreeDecisionTree(tree);
end.
