unit LinearAlgebra;
{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}
interface

uses sysutils;

type
  TDoubleArray = array of Double;
  TDoubleMatrix = array of TDoubleArray;

function DotProduct(const a, b: TDoubleArray): Double;
function MatrixMultiply(const a, b: TDoubleMatrix): TDoubleMatrix;
function L2Regularization(const weights: TDoubleArray; lambda: Double): Double;

implementation

function L2Regularization(const weights: TDoubleArray; lambda: Double): Double;
var
  i: Integer;
begin
  Result := 0;
  for i := 0 to High(weights) do
    Result := Result + weights[i] * weights[i];
  Result := lambda * Result;
end;

function DotProduct(const a, b: TDoubleArray): Double;
var
  i: Integer;
begin
  if Length(a) <> Length(b) then
    raise Exception.Create('Arrays must have compatible lengths for dot product');

  Result := 0;
  for i := 0 to High(a) do
    Result := Result + a[i] * b[i];
end;

function MatrixMultiply(const a, b: TDoubleMatrix): TDoubleMatrix;
var
  i, j, k: Integer;
begin
  SetLength(Result, Length(a), Length(b[0])); // Инициализация Result
  for i := 0 to High(a) do
    for j := 0 to High(b[0]) do
    begin
      Result[i][j] := 0; // Явная инициализация каждого элемента
      for k := 0 to High(b) do
        Result[i][j] := Result[i][j] + a[i][k] * b[k][j];
    end;
end;

begin
writeln('GPT version of LA');
end.