program NeuralNetworkTest;

{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}

uses
  SysUtils, NeuralNetwork, DataUtils;

var
  network: TNeuralNetwork;
  input, output: TDoubleArray;
  layerSizes: array of Integer;

procedure PrintNetworkState(const network: TNeuralNetwork);
var
  i, j, k: Integer;
begin
  WriteLn('--- Network State ---');
  for i := 0 to High(network.layers) do
  begin
    WriteLn('Layer ', i);
    WriteLn('Weights:');
    for j := 0 to High(network.layers[i].weights) do
    begin
      for k := 0 to High(network.layers[i].weights[j]) do
        Write(network.layers[i].weights[j][k]:8:4, ' ');
      WriteLn;
    end;
    WriteLn('Biases:');
    for j := 0 to High(network.layers[i].biases) do
      Write(network.layers[i].biases[j]:8:4, ' ');
    WriteLn;
  end;
end;

procedure PrintLayerActivations(const network: TNeuralNetwork);
var
  i, j: Integer;
begin
  WriteLn('--- Layer Activations ---');
  for i := 0 to High(network.layers) do
  begin
    WriteLn('Layer ', i, ' activations:');
    for j := 0 to High(network.layers[i].output) do
      Write(network.layers[i].output[j]:8:4, ' ');
    WriteLn;
  end;
end;

begin
  Randomize;
  
  // Определяем архитектуру сети: 2 входных нейрона, 2 скрытых, 1 выходной
  SetLength(layerSizes, 3);
  layerSizes[0] := 2;
  layerSizes[1] := 2;
  layerSizes[2] := 1;
  
  // Инициализация сети
  InitializeNetwork(network, layerSizes, 0.01);

PrintNetworkState(network);
  
  // Тестовые входные данные
  SetLength(input, 2);
  input[0] := 0.5;
  input[1] := -0.3;
  
  // Прямое распространение
  ForwardPropagation(network, input);
PrintLayerActivations(network);
  
  // Получаем предсказание
  output := PredictNetwork(network, input);
  
  // Вывод результата
  WriteLn('Prediction: ', output[0]:0:4);
  
  // Освобождение памяти
  FreeNetwork(network);
end.