program TestLinearAlgebra;

{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}

uses
  LinearAlgebra, SysUtils;

var
  a, b: TDoubleArray;
  mat1, mat2, matRes: TDoubleMatrix;
  dotProd, reg: Double;
  i, j: Integer;
begin
  // Тест DotProduct
  SetLength(a, 3);
  SetLength(b, 3);
  a[0] := 1.0; a[1] := 2.0; a[2] := 3.0;
  b[0] := 4.0; b[1] := 5.0; b[2] := 6.0;

  dotProd := DotProduct(a, b);
  WriteLn('DotProduct: ', dotProd:0:2);  // Ожидается 1*4 + 2*5 + 3*6 = 32

  // Тест L2Regularization
  reg := L2Regularization(a, 0.5);
  WriteLn('L2 Regularization: ', reg:0:2);  // Ожидается 0.5 * (1^2 + 2^2 + 3^2) = 0.5 * 14 = 7.0

  // Тест MatrixMultiply
  SetLength(mat1, 2, 3);
  SetLength(mat2, 3, 2);

  // Матрица 2x3
  mat1[0][0] := 1; mat1[0][1] := 2; mat1[0][2] := 3;
  mat1[1][0] := 4; mat1[1][1] := 5; mat1[1][2] := 6;

  // Матрица 3x2
  mat2[0][0] := 7; mat2[0][1] := 8;
  mat2[1][0] := 9; mat2[1][1] := 10;
  mat2[2][0] := 11; mat2[2][1] := 12;

  matRes := MatrixMultiply(mat1, mat2);

  WriteLn('MatrixMultiply Result:');
  for i := 0 to High(matRes) do
  begin
    for j := 0 to High(matRes[i]) do
      Write(matRes[i][j]:6:1, ' ');
    WriteLn;
  end;
  // Ожидается матрица 2x2: 
  // [  58  64 ]
  // [ 139 154 ]
end.