{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}

program TestRandomForest;

uses
  SysUtils, RandomForest, DecisionTree, DataUtils;

procedure TestTrainAndPredict;
var
  forest: TRandomForest;
  x: TDoubleMatrix;
  y: TDoubleArray;
  testSample: TDoubleArray;
  prediction: Double;
begin
  // Создаём обучающие данные
  SetLength(x, 5, 2);
  x[0] := [1.0, 2.0];
  x[1] := [1.5, 1.8];
  x[2] := [5.0, 8.0];
  x[3] := [8.0, 8.0];
  x[4] := [1.0, 0.6];

  SetLength(y, 5);
  y[0] := 0;
  y[1] := 0;
  y[2] := 1;
  y[3] := 1;
  y[4] := 0;

  // Обучаем лес
  TrainRandomForest(forest, x, y, 10, 5, 2);

  // Проверяем предсказание
  SetLength(testSample, 2);
  testSample := [3.0, 3.0];
  prediction := PredictRandomForest(forest, testSample);

  WriteLn('Prediction for [3.0, 3.0]: ', prediction:0:4);

  // Освобождаем память
  FreeRandomForest(forest);
end;

begin
  Randomize;
  TestTrainAndPredict;
end.