program TestSVM;

{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}

uses
  SVM, SysUtils, LinearAlgebra;

var
  model: TSVM;
  x: TDoubleMatrix;
  y: TDoubleArray;
  testSample: TDoubleArray;
  prediction: Double;
begin
  // Данные для обучения (линейно разделимые)
  SetLength(x, 4, 2);
  x[0][0] := 1; x[0][1] := 2;
  x[1][0] := 2; x[1][1] := 3;
  x[2][0] := 3; x[2][1] := 3;
  x[3][0] := 5; x[3][1] := 5;

  SetLength(y, 4);
  y[0] := -1;
  y[1] := -1;
  y[2] := 1;
  y[3] := 1;

  // Обучение модели
  TrainSVM(model, x, y, 0.1, 100, 0.01);

  // Тестовое предсказание
  SetLength(testSample, 2);
  testSample[0] := 4;
  testSample[1] := 4;

  prediction := PredictSVM(model, testSample);

  // Вывод результата
  WriteLn('Предсказание для (4,4): ', prediction:0:1);
end.