import pygame
import numpy as np

# Инициализация Pygame
pygame.init()

# Параметры лабиринта
WIDTH, HEIGHT = 500, 500
ROWS, COLS = 5, 5  # Размеры лабиринта
CELL_SIZE = WIDTH // COLS

# Создание окна
screen = pygame.display.set_mode((WIDTH, HEIGHT))
pygame.display.set_caption("AI Labyrinth Game")

# Генерация случайного лабиринта
while True:
    maze = np.random.choice([0, 1], size=(ROWS, COLS), p=[0.7, 0.3])
    player_pos = [0, 0]
    exit_pos = [ROWS - 1, COLS - 1]  # Выход из лабиринта
    maze[exit_pos[0], exit_pos[1]] = 0  # Гарантируем, что выход проходимый
    if maze[player_pos[0], player_pos[1]] == 0:  # Проверяем, что стартовая позиция тоже проходима
        break

def draw_maze(screen):
    screen.fill((0, 0, 0))  # Заливка фона черным
    for row in range(ROWS):
        for col in range(COLS):
            if [row, col] == exit_pos:
                color = (0, 255, 0)  # Зеленый цвет для выхода
            else:
                color = (255, 255, 255) if maze[row, col] == 0 else (0, 0, 255)
            pygame.draw.rect(screen, color, (col * CELL_SIZE, row * CELL_SIZE, CELL_SIZE, CELL_SIZE))
            pygame.draw.rect(screen, (0, 0, 0), (col * CELL_SIZE, row * CELL_SIZE, CELL_SIZE, CELL_SIZE), 1)
    
    # Отрисовка игрока
    pygame.draw.rect(screen, (255, 0, 0), (player_pos[1] * CELL_SIZE, player_pos[0] * CELL_SIZE, CELL_SIZE, CELL_SIZE))

def move_player(dx, dy):
    global player_pos
    new_x, new_y = player_pos[0] + dx, player_pos[1] + dy
    if 0 <= new_x < ROWS and 0 <= new_y < COLS and maze[new_x, new_y] == 0:
        player_pos = [new_x, new_y]

def check_win():
    return player_pos == exit_pos

def main():
    running = True
    while running:
        for event in pygame.event.get():
            if event.type == pygame.QUIT:
                running = False
            elif event.type == pygame.KEYDOWN:
                if event.key in (pygame.K_w, pygame.K_UP):
                    move_player(-1, 0)
                elif event.key in (pygame.K_s, pygame.K_DOWN):
                    move_player(1, 0)
                elif event.key in (pygame.K_a, pygame.K_LEFT):
                    move_player(0, -1)
                elif event.key in (pygame.K_d, pygame.K_RIGHT):
                    move_player(0, 1)
        
        draw_maze(screen)
        pygame.display.flip()

        if check_win():
            print("Поздравляем! Вы нашли выход из лабиринта!")
            pygame.time.delay(2000)
            running = False
    
    pygame.quit()

if __name__ == "__main__":
    main()
