unit LinearAlgebra;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}
interface

uses sysutils;

type
  TDoubleArray = array of Double;
  TDoubleMatrix = array of TDoubleArray;

function DotProduct(const a, b: TDoubleArray): Double;
function MatrixMultiply(const a, b: TDoubleMatrix): TDoubleMatrix;
function L2Regularization(const weights: TDoubleArray; lambda: Double): Double;

implementation

function L2Regularization(const weights: TDoubleArray; lambda: Double): Double;
var
  i: Integer;
begin
  Result := 0;
  for i := 0 to High(weights) do
    Result := Result + weights[i] * weights[i];
  Result := lambda * Result;
end;

function DotProduct(const a, b: TDoubleArray): Double;
var
  i: Integer;
begin
  if Length(a) <> Length(b) + 1 then
    raise Exception.Create('Arrays must have compatible lengths for dot product');

  Result := 0;
  for i := 0 to High(b) do
    Result := Result + a[i + 1] * b[i]; // Пропускаем a[0] (bias)
end;

function MatrixMultiply(const a, b: TDoubleMatrix): TDoubleMatrix;
var
  i, j, k: Integer;
begin
  SetLength(Result, Length(a), Length(b[0])); // Инициализация Result
  for i := 0 to High(a) do
    for j := 0 to High(b[0]) do
    begin
      Result[i][j] := 0; // Явная инициализация каждого элемента
      for k := 0 to High(b) do
        Result[i][j] := Result[i][j] + a[i][k] * b[k][j];
    end;
end;

end.