unit LinearAlgebra;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}//{$RANGECHECKS ON}

interface

uses SysUtils;

type
  TDoubleArray = array of Double;

function RandomVector(Dimensions: Integer): TDoubleArray; register;
function DotProduct(const a, b: TDoubleArray): Double; register;
function NormalizeVector(const Vec: TDoubleArray): TDoubleArray; register;

implementation

function RandomVector(Dimensions: Integer): TDoubleArray;
var
  i: Integer;
begin
  SetLength(Result, Dimensions);
  for i := 0 to High(Result) do
    Result[i] := Random * 0.0001; // Меньшие значения ускоряют нормализацию
end;

function DotProduct(const a, b: TDoubleArray): Double;
var
  i: Integer;
  pa, pb: PDouble;
begin
  if Length(a) <> Length(b) then
    raise Exception.Create('Arrays must have equal lengths for dot product');

  Result := 0;
  pa := @a[0];
  pb := @b[0];
  for i := 0 to High(a) do
  begin
    Result := Result + pa^ * pb^;
    Inc(pa);
    Inc(pb);
  end;
end;

function NormalizeVector(const Vec: TDoubleArray): TDoubleArray;
var
  Norm: Double;
  i: Integer;
begin
  Norm := Sqrt(DotProduct(Vec, Vec));
  SetLength(Result, Length(Vec));
  
  if Norm > 0 then
    for i := 0 to High(Vec) do
      Result[i] := Vec[i] / Norm
  else
    Result := Vec; // Возвращаем исходный вектор если норма = 0
end;

end.