unit FileSystem;
{$MODE OBJFPC}{$H+}

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

interface

uses
  SysUtils, BaseUnix;

procedure InitMusicEnvironment;
function GetMusicDir: String;

implementation

const
  MUSIC_DIR = '.musician';
  SUB_DIRS: array[0..4] of String = (
    'models', 'library/user', 'library/system', 'cache', 'compositions'
  );

function GetMusicDir: String;
begin
  Result := GetUserDir + MUSIC_DIR;
end;

procedure InitMusicEnvironment;
var
  Dir: String;
  SubDir: String;
begin
  Dir := GetMusicDir;
  if not DirectoryExists(Dir) then
  begin
    WriteLn('Creating music directory: ', Dir);
    if not CreateDir(Dir) then
      raise Exception.Create('Failed to create directory: ' + Dir);
    
    for SubDir in SUB_DIRS do
    begin
      if not CreateDir(Dir + '/' + SubDir) then
        WriteLn('Warning: failed to create subdirectory: ', SubDir);
    end;
  end;
end;

end.