unit MusicTrainer;
{$MODE OBJFPC}{$H+}

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

interface

uses
  NeuralNetwork, MusicUtils;

procedure TrainMusicAnalyzerModel;

implementation

procedure TrainMusicAnalyzerModel;
var
  NN: TNeuralNetwork;
  TrainingData: TDoubleMatrix;
  TargetData: TDoubleArray;
  i: Integer;
begin
  // 1. Инициализация нейросети
  NN.Initialize([128, 64, 32, 5], 0.01);  // 128 входов, 5 выходов

  // 2. Загрузка обучающих данных
  LoadDataset('~/.musician/models/training_data.csv', TrainingData, TargetData);

  // 3. Обучение
  for i := 1 to 1000 do  // 1000 эпох
  begin
    NN.Train(TrainingData, TargetData, 1);
    if i mod 100 = 0 then
      WriteLn('Epoch ', i, ' Error: ', NN.GetLastError);
  end;

  // 4. Сохранение модели
  NN.Save('~/.musician/models/music_analyzer.nn');
end;

end.