unit aifourier2;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}
{$OPTIMIZATION LEVEL3}
{$OPTIMIZATION PEEPHOLE}
{$OPTIMIZATION REGVAR}
{$OPTIMIZATION LOOPUNROLL}
{$OPTIMIZATION CSE}
{$OPTIMIZATION DFA}
{$RANGECHECKS OFF}
{$OVERFLOWCHECKS OFF}
{$STACKFRAMES OFF}
{$INLINE ON}

interface

type
  TDoubleArray = array of Double;

procedure fft(NumSamples: Integer;
              var RealIn, ImagIn: TDoubleArray;
              var RealOut, ImagOut: TDoubleArray);

implementation

// Рекурсивная процедура FFT
procedure InternalFFT(var RealData, ImagData: TDoubleArray; N: Integer); inline;
var
  i, k: Integer;
  Angle, CosAngle, SinAngle: Double;
  EvenReal, EvenImag, OddReal, OddImag: TDoubleArray;
Nshr1,Ishl1:DWord;
begin
  if N <= 1 then Exit;

Nshr1 := N shr 1;
  
  SetLength(EvenReal, Nshr1);
  SetLength(EvenImag, Nshr1);
  SetLength(OddReal, Nshr1);
  SetLength(OddImag, Nshr1);
  
  // Разделение на четные и нечетные
  for i := 0 to (Nshr1) - 1 do
  begin
    Ishl1 := I shl 1;
    EvenReal[i] := RealData[Ishl1];
    EvenImag[i] := ImagData[Ishl1];
    OddReal[i] := RealData[Ishl1 + 1];
    OddImag[i] := ImagData[Ishl1 + 1];
  end;
  
  // Рекурсивные вызовы
  InternalFFT(EvenReal, EvenImag, Nshr1);
  InternalFFT(OddReal, OddImag, Nshr1);
  
  // Комбинирование результатов
  for k := 0 to (Nshr1) - 1 do
  begin
    Angle := -2 * Pi * k / N;
    CosAngle := Cos(Angle);
    SinAngle := Sin(Angle);
    
    RealData[k] := EvenReal[k] + CosAngle * OddReal[k] - SinAngle * OddImag[k];
    ImagData[k] := EvenImag[k] + CosAngle * OddImag[k] + SinAngle * OddReal[k];
    RealData[k + Nshr1] := EvenReal[k] - (CosAngle * OddReal[k] - SinAngle * OddImag[k]);
    ImagData[k + Nshr1] := EvenImag[k] - (CosAngle * OddImag[k] + SinAngle * OddReal[k]);
  end;
end;

function IsPowerOfTwo(x: Integer): Boolean; inline;
begin
  Exit((x > 0) and ((x and (x - 1)) = 0));
end;

procedure fft(NumSamples: Integer;
              var RealIn, ImagIn: TDoubleArray;
              var RealOut, ImagOut: TDoubleArray);
begin
  if (NumSamples <= 0) or (Length(RealIn) < NumSamples) or 
     (Length(ImagIn) < NumSamples) then
    Exit;
  
  // Проверка степени двойки
  if not IsPowerOfTwo(NumSamples) then
    Exit;
  
  // Копирование входных данных
  SetLength(RealOut, NumSamples);
  SetLength(ImagOut, NumSamples);
  Move(RealIn[0], RealOut[0], NumSamples * SizeOf(Double));
  Move(ImagIn[0], ImagOut[0], NumSamples * SizeOf(Double));
  
  // Вызов рекурсивной процедуры
  InternalFFT(RealOut, ImagOut, NumSamples);
end;

end.