# neural_train.py
import tensorflow as tf
from sklearn.preprocessing import LabelEncoder

# 1. Загрузка данных
X = load_speaker_files('~/music_dataset/*.speaker')
y = load_labels('~/music_dataset/labels.csv')

# 2. Создание модели
model = tf.keras.Sequential([
    tf.keras.layers.Dense(128, activation='relu'),
    tf.keras.layers.Dense(64, activation='relu'),
    tf.keras.layers.Dense(5)  # tempo_norm, key, major/minor, mood, complexity
])

# 3. Обучение
model.compile(optimizer='adam', loss='mse')
model.fit(X, y, epochs=10)

# 4. Экспорт весов
model.save_weights('music_analyzer_weights.h5')