# neural_train_light.py
import numpy as np
from sklearn.neural_network import MLPRegressor
import joblib

# 1. Генерация тестовых данных
X = np.random.rand(100, 128)  # 100 примеров, 128 признаков
y = np.random.rand(100, 5)    # 5 целевых параметров

# 2. Создание и обучение модели
model = MLPRegressor(hidden_layer_sizes=(64, 32), max_iter=1000)
model.fit(X, y)

# 3. Сохранение модели
joblib.dump(model, 'music_analyzer_sklearn.joblib')
print("Model saved!")