unit MathPlugin;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


{$MODE OBJFPC}{$H+}

interface

uses
  PluginInterface, SysUtils;

type
  TMathPlugin = class(TInterfacedObject, IPlugin)
  public
    function CanHandle(const Input: string): Boolean;
    function HandleInput(const Input: string): string;
    function GetName: string;
  end;

implementation

function TMathPlugin.CanHandle(const Input: string): Boolean;
begin
  Result := (Pos('+', Input) > 0) or 
            (Pos('-', Input) > 0) or
            (Pos('*', Input) > 0) or
            (Pos('/', Input) > 0);
end;

function TMathPlugin.HandleInput(const Input: string): string;
begin
  // Упрощенная реализация
  if Input = '2+2' then
    Result := '2+2=4 (из MathPlugin)'
  else
    Result := 'Не могу решить пример';
end;

function TMathPlugin.GetName: string;
begin
  Result := 'MathPlugin';
end;

end.