unit NLPUtils;
{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


interface

uses
  SysUtils, StrUtils, types, DataUtils, Math;

type
  TDoubleArray = array of Double;
  TStringArray = array of String;

function TextToFeatures(const Text: String): TDoubleArray;
function Tokenize(const Text: String): TStringArray;
function ContainsAny(const Text: String; const Words: array of String): Boolean;

implementation

function Tokenize(const Text: String): TStringArray;
begin
  Result := Text.Split([' ', ',', '.', '!', '?'], TStringSplitOptions.ExcludeEmpty);
end;

function ContainsAny(const Text: String; const Words: array of String): Boolean;
var
  Word: String;
begin
  Result := False;
  for Word in Words do
    if Pos(Word, Text) > 0 then
      Exit(True);
end;

function TextToFeatures(const Text: String): TDoubleArray;
var
  Tokens: TStringArray;
  i: Integer;
  LowerText: String;
begin
  LowerText := LowerCase(Text);
  SetLength(Result, 20); // Увеличили количество признаков
  FillChar(Result[0], Length(Result)*SizeOf(Double), 0);
  
  // Бинарные признаки наличия ключевых слов
  if ContainsAny(LowerText, ['кто', 'кого', 'кому']) then Result[0] := 1;
  if ContainsAny(LowerText, ['что', 'чего', 'чему']) then Result[1] := 1;
  if ContainsAny(LowerText, ['сколько', 'когда', 'во сколько']) then Result[2] := 1;
  if ContainsAny(LowerText, ['время', 'час', 'часы']) then Result[3] := 1;
  if ContainsAny(LowerText, ['помощь', 'помоги', 'помощник']) then Result[4] := 1;
  if ContainsAny(LowerText, ['имя', 'зовут', 'называешься']) then Result[5] := 1;
  if ContainsAny(LowerText, ['умеешь', 'можешь', 'способен']) then Result[6] := 1;
  if ContainsAny(LowerText, ['как', 'каким образом']) then Result[7] := 1;
  if ContainsAny(LowerText, ['почему', 'отчего']) then Result[8] := 1;
  if ContainsAny(LowerText, ['привет', 'здравствуй', 'добрый день']) then Result[9] := 1;
  if ContainsAny(LowerText, ['пока', 'до свидания', 'прощай']) then Result[10] := 1;
  if ContainsAny(LowerText, ['дела', 'настроение', 'жизнь']) then Result[11] := 1;
  if ContainsAny(LowerText, ['создан', 'сделал', 'разработал']) then Result[12] := 1;
  if ContainsAny(LowerText, ['работаешь', 'функционируешь']) then Result[13] := 1;
  if ContainsAny(LowerText, ['знаешь', 'известно', 'информация']) then Result[14] := 1;
  
  // Количественные признаки
  Tokens := Tokenize(LowerText);
  Result[15] := Min(1.0, Length(Tokens)/10.0); // Относительная длина вопроса
  Result[16] := IfThen(Pos('?', Text) > 0, 1.0, 0.0); // Вопрос ли это
  Result[17] := IfThen(ContainsAny(LowerText, ['ты', 'тебя', 'твой']), 1.0, 0.0);
  Result[18] := IfThen(ContainsAny(LowerText, ['я', 'мне', 'мой']), 1.0, 0.0);
  Result[19] := IfThen(Length(Tokens) > 0, Pos(Tokens[0], 'кто что сколько когда почему как')/10.0, 0.0);
end;

end.