unit NetworkViz;
{$MODE OBJFPC}{$H+}

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


interface

uses
  Classes, SysUtils, Graphics, GraphType, IntfGraphics, LCLType, LCLIntf,
  NeuralNetwork, LSTM;

procedure DrawNetworkStructure(const filename: string; const network: TNeuralNetwork);
procedure DrawLSTMCell(const filename: string; const cell: TLSTMCell);

implementation

procedure DrawNetworkStructure(const filename: string; const network: TNeuralNetwork);
var
  bmp: TBitmap;
  i, j, k, x, y: Integer;
  layerWidth, neuronSize: Integer;
begin
  bmp := TBitmap.Create;
  try
    bmp.Width := 800;
    bmp.Height := 600;
    bmp.Canvas.Brush.Color := clWhite;
    bmp.Canvas.FillRect(0, 0, bmp.Width, bmp.Height);
    
    // Настройки отрисовки
    neuronSize := 20;
    layerWidth := 150;
    
    // Отрисовка слоёв
    for i := 0 to High(network.layers) do
    begin
      x := 100 + i * layerWidth;
      
      // Отрисовка нейронов
      for j := 0 to High(network.layers[i].weights) do
      begin
        y := 100 + j * 30;
        bmp.Canvas.Ellipse(x, y, x + neuronSize, y + neuronSize);
        
        // Отрисовка связей
        if i > 0 then
        begin
          for k := 0 to High(network.layers[i-1].weights) do
          begin
            bmp.Canvas.MoveTo(x - layerWidth + neuronSize, 100 + k * 30 + neuronSize div 2);
            bmp.Canvas.LineTo(x, y + neuronSize div 2);
          end;
        end
      end;
      
      // Подписи слоёв
      bmp.Canvas.TextOut(x, 70, Format('Layer %d', [i+1]));
    end;
    
    bmp.SaveToFile(filename);
  finally
    bmp.Free;
  end;
end;

procedure DrawLSTMCell(const filename: string; const cell: TLSTMCell);
var
  bmp: TBitmap;
begin
  bmp := TBitmap.Create;
  try
    bmp.Width := 400;
    bmp.Height := 300;
    // ... реализация отрисовки LSTM ячейки ...
    bmp.SaveToFile(filename);
  finally
    bmp.Free;
  end;
end;

end.