unit NeuralCore;
{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


interface

uses
  SysUtils, Math;

type
  TDoubleArray = array of Double;
  TDoubleMatrix = array of TDoubleArray;

  TLayer = record
    Weights: TDoubleMatrix;
    Biases: TDoubleArray;
    Output: TDoubleArray;
  end;

  TNeuralNetwork = record
    Layers: array of TLayer;
    LearningRate: Double;
    Lambda: Double; // L2-регуляризация
  end;

// Инициализация сети
procedure InitNetwork(var Network: TNeuralNetwork; const LayerSizes: array of Integer;
  LearningRate: Double; Lambda: Double = 0.0);

// Базовые операции
procedure ForwardPropagation(var Network: TNeuralNetwork; const Input: TDoubleArray);
procedure BackwardPropagation(var Network: TNeuralNetwork; const Input: TDoubleArray; 
  Target: Double);
procedure TrainNetwork(var Network: TNeuralNetwork; const X: TDoubleMatrix;
  const Y: TDoubleArray; Epochs: Integer; Experience: Integer = 0);

// Вспомогательные функции
function SafeSigmoid(X: Double): Double;
function SafeExp(X: Double): Double;
function ClipMatrix(const M: TDoubleMatrix; MinVal, MaxVal: Double): TDoubleMatrix;
function ClipVector(const V: TDoubleArray; MinVal, MaxVal: Double): TDoubleArray;
function RandomArray(Size: Integer; MinVal, MaxVal: Double): TDoubleArray;

implementation

const
  MAX_WEIGHT = 5.0;
  MIN_WEIGHT = -5.0;

function SafeExp(X: Double): Double;
begin
  if X > 50 then Exit(Exp(50));
  if X < -50 then Exit(Exp(-50));
  Result := Exp(X);
end;

function SafeSigmoid(X: Double): Double;
begin
  if X > 30 then Exit(1.0);
  if X < -30 then Exit(0.0);
  Result := 1.0 / (1.0 + SafeExp(-X));
end;

// ... (реализация остальных функций из предыдущих улучшений)

end.