unit PluginManagerUnit;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


{$MODE OBJFPC}{$H+}

interface

uses
  PluginInterface, Classes, SysUtils;

type
  // Добавляем объявление типа для массива плагинов
  TPluginArray = array of IPlugin;

  TPluginManager = class
  private
    FPlugins: TInterfaceList;
  public
    constructor Create;
    destructor Destroy; override;
    
    procedure RegisterPlugin(Plugin: IPlugin);
    function HandleInput(const Input: string): string;
    function FindPlugin(const PluginName: string): IPlugin;
    function GetPlugins: TPluginArray;  // Возвращаем объявленный тип
  end;

implementation

constructor TPluginManager.Create;
begin
  FPlugins := TInterfaceList.Create;
end;

destructor TPluginManager.Destroy;
begin
  FPlugins.Free;
  inherited;
end;

procedure TPluginManager.RegisterPlugin(Plugin: IPlugin);
begin
  if Assigned(Plugin) then
    FPlugins.Add(Plugin);
end;

function TPluginManager.HandleInput(const Input: string): string;
var
  i: Integer;
  Plugin: IPlugin;
begin
  Result := '';
  for i := 0 to FPlugins.Count - 1 do
  begin
    Plugin := IPlugin(FPlugins[i]);
    try
      if Plugin.CanHandle(Input) then
      begin
        Result := Plugin.HandleInput(Input);
        if Result <> '' then
          Break;
      end;
    except
      on E: Exception do
        WriteLn('[Ошибка в плагине ', Plugin.GetName, ']: ', E.Message);
    end;
  end;
end;

function TPluginManager.FindPlugin(const PluginName: string): IPlugin;
var
  i: Integer;
begin
  Result := nil;
  for i := 0 to FPlugins.Count - 1 do
  begin
    if SameText(IPlugin(FPlugins[i]).GetName, PluginName) then
    begin
      Result := IPlugin(FPlugins[i]);
      Break;
    end;
  end;
end;

function TPluginManager.GetPlugins: TPluginArray;
var
  i: Integer;
begin
  SetLength(Result, FPlugins.Count);
  for i := 0 to FPlugins.Count - 1 do
    Result[i] := IPlugin(FPlugins[i]);
end;

end.