// Добавить модуль профилирования
unit Profiler;
interface

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


var
  ProfileEnabled: Boolean = False;

procedure StartTimer(const Name: string);
procedure StopTimer(const Name: string);
procedure PrintProfileResults;

implementation

var
  Timers: TStringList;
  StartTimes: array of TDateTime;

procedure StartTimer(const Name: string);
var
  idx: Integer;
begin
  if not ProfileEnabled then Exit;
  
  idx := Timers.IndexOf(Name);
  if idx < 0 then
  begin
    idx := Timers.Add(Name);
    SetLength(StartTimes, Timers.Count);
  end;
  
  StartTimes[idx] := Now;
end;

procedure StopTimer(const Name: string);
var
  idx: Integer;
  elapsed: Int64;
begin
  if not ProfileEnabled then Exit;
  
  idx := Timers.IndexOf(Name);
  if idx >= 0 then
  begin
    elapsed := MilliSecondsBetween(Now, StartTimes[idx]);
    WriteLn(Name, ': ', elapsed, ' ms');
  end;
end;