unit SoundPlugin;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


{$MODE OBJFPC}{$H+}

interface

uses
  PluginInterface, SysUtils, Classes;

type
  TSoundPlugin = class(TInterfacedObject, IPlugin)
  private
    FEnabled: Boolean;
    FInitialized: Boolean;
  public
    constructor Create;
    function CanHandle(const Input: string): Boolean;
    function HandleInput(const Input: string): string;
    function GetName: string;
    procedure SetEnabled(Value: Boolean);
    procedure CheckInitialized;
  end;

implementation

constructor TSoundPlugin.Create;
begin
  FEnabled := True;
  FInitialized := True; // Успешно инициализирован
end;

procedure TSoundPlugin.CheckInitialized;
begin
  if not FInitialized then
    raise Exception.Create('Sound plugin not initialized');
end;

function TSoundPlugin.CanHandle(const Input: string): Boolean;
begin
  Result := False;
  try
    Result := (LowerCase(Trim(Input)) = 'звук вкл') or 
              (LowerCase(Trim(Input)) = 'звук выкл');
  except
    on E: Exception do
      WriteLn('[SoundPlugin] Error in CanHandle: ', E.Message);
  end;
end;

function TSoundPlugin.HandleInput(const Input: string): string;
var
  LowerInput: string;
begin
  CheckInitialized;
  Result := '';
  LowerInput := LowerCase(Trim(Input));

  if LowerInput = 'звук вкл' then
  begin
    FEnabled := True;
    Result := 'Звуковое сопровождение включено';
  end
  else if (LowerInput = 'звук выкл') or (LowerInput = 'звук выключить') then
  begin
    FEnabled := False;
    Result := 'Звуковое сопровождение отключено';
  end;
end;

function TSoundPlugin.GetName: string;
begin
  Result := 'Sound Effects Plugin v2.0';
end;

procedure TSoundPlugin.SetEnabled(Value: Boolean);
begin
  CheckInitialized;
  FEnabled := Value;
end;

end.