program TestMind;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}
uses
  MindCore, SysUtils, StrUtils, Math;

var
  AI: TMindEngine;
  i: Integer;
  TestCases: array of String = (
{
  '2+2',
  '3*4',
  '(1+2)*3',
  '10/2',
  '2^3',
  'sqrt(9)',
  'sin(0)',
}
    'Привет',
    'Кто ты',
    'Сколько времени',
    'Как тебя зовут',
    'Что ты умеешь',
    'Кто тебя создал',
    'Почему небо голубое',
    'Как погода',
    'Что нового',
    'Расскажи о себе',
    'Сколько будет 2+2',
    'Что такое паскаль',
    'Сколько будет (3+5)*2',
    'Сколько будет 10/(2+3)',
    'Вычисли (4+6)*(3-1)',
    'Посчитай 2*(3+4)',
  'Сколько будет sin(30)',
  'Вычисли sqrt(16)',
  'Посчитай 2^3',
  '2^3',
  '2 в степени 3',
  'корень из 16',
  'sqrt(25)',
  'sin(45)'
{
  '2+2',
  '3*4',
  '(1+2)*3',
  '10/2',
  '2^3',
  '2 в степени 3',
  'sqrt(9)',
  'корень из 16',
  'sin(0)',
  'сколько будет 2+2',
  'сколько будет (3+5)*2',
  'вычисли sqrt(16)',
  'посчитай sin(30)'
}
{
  '2+2',
  '3*4',
  '(1+2)*3',
  '10/2',
  '2^3',
  '2 в степени 3',
  'sqrt(9)',
  'корень из 16',
  'sin(30)',
  'cos(45)',
  'сколько будет 2+2',
  'сколько будет (3+5)*2',
  'вычисли sqrt(16)',
  'посчитай 2^8'
}
  );
  
function IsMathQuestion(const Question: string): Boolean;
begin
  Result := ContainsText(Question, 'сколько будет') or 
            ContainsText(Question, 'вычисли') or 
            ContainsText(Question, 'посчитай');
end;

begin
  SetTextCodePage(Output, 65001);
  Randomize;
  AI := TMindEngine.Create;
  try
    WriteLn('=== Тестирование ===');
    for i := 0 to High(TestCases) do
    begin
      WriteLn('Вопрос: ', TestCases[i]);
      if IsMathQuestion(TestCases[i]) then
        WriteLn('Ответ: ', AI.ProcessMathExpression(TestCases[i]).ToString)
      else
        WriteLn('Ответ: ', AI.ProcessInput(TestCases[i]).ToString);
      WriteLn;
    end;
    
    WriteLn('=== Обучение ===');
    AI.Learn('сколько будет 2+2', 'Два плюс два равно четыре');
    WriteLn('Обучили: "сколько будет 2+2"');
    WriteLn('Проверка: ', AI.ProcessInput('сколько будет 2+2').ToString);
  finally
    AI.Free;
  end;
end.