program widgetstest;

{
    XWidget.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.
                              
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}
uses
  SysUtils, x, XLib, widgetsunit;

type
  TMyApp = class
  public
    procedure HandleButtonClick(Sender: TObject);
  end;

var
  WindowManager: TWindowManager;
  MainWindow: TWindowWidget;
  Button: TButton;
  Label1: TLabel;
  EventLoop: TEventLoop;
  MyApp: TMyApp;

procedure TMyApp.HandleButtonClick(Sender: TObject);
begin
  WriteLn('Button clicked!');
end;

begin
  // Инициализация X11 и создание окна
  WindowManager := TWindowManager.Create;
  try
    WindowManager.SetupWindow;

    // Создание главного окна
    MainWindow := TWindowWidget.Create;

    // Создание кнопки
    Button := TButton.Create('Click Me', 50, 50, 100, 30);
    MyApp := TMyApp.Create;
    Button.OnClick := @MyApp.HandleButtonClick;
    MainWindow.AddWidget(Button);

    // Создание текстового элемента
    Label1 := TLabel.Create('Hello, World!', 50, 100);
    MainWindow.AddWidget(Label1);

    // Основной цикл обработки событий
    EventLoop := TEventLoop.Create(WindowManager.Display, MainWindow, WindowManager.Gc, WindowManager.Window);
    try
      EventLoop.Run;
    finally
      EventLoop.Free;
    end;

    // Очистка
    MyApp.Free;
    MainWindow.Free;
  finally
    WindowManager.Free;
  end;
end.