unit buttonunit;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}

interface

uses
  SysUtils, xcbunit, widgetsunit;

type
  // Определяем процедурный тип для обработчика события
  TButtonClickEvent = procedure(Sender: TObject) of object;

  TButton = class(TWidget)
  private
    FText: string;
    FX, FY: Integer;
    FWidth, FHeight: Integer;
    FOnClick: TButtonClickEvent; // Используем процедурный тип
  public
    constructor Create(const AText: string; AX, AY, AWidth, AHeight: Integer);
    procedure Draw(AConnection: Pxcb_connection_t; AWindow: xcb_window_t; AGc: xcb_gcontext_t); override;
    procedure HandleEvent(Event: Pxcb_generic_event_t); override;
    property OnClick: TButtonClickEvent read FOnClick write FOnClick; // Используем процедурный тип
  end;

implementation

constructor TButton.Create(const AText: string; AX, AY, AWidth, AHeight: Integer);
begin
  inherited Create;
  FText := AText;
  FX := AX;
  FY := AY;
  FWidth := AWidth;
  FHeight := AHeight;
end;

procedure TButton.Draw(AConnection: Pxcb_connection_t; AWindow: xcb_window_t; AGc: xcb_gcontext_t);
var
  Rect: xcb_rectangle_t;
begin
  if not Visible then Exit;

  // Отрисовка фона кнопки
  Rect.x := FX;
  Rect.y := FY;
  Rect.width := FWidth;
  Rect.height := FHeight;
  xcb_poly_fill_rectangle(AConnection, AWindow, AGc, 1, @Rect);

  // Отрисовка текста на кнопке
  xcb_poly_text_8(AConnection, AWindow, AGc, FX + 10, FY + 20, Length(FText), PChar(FText));
end;

procedure TButton.HandleEvent(Event: Pxcb_generic_event_t);
var
  ButtonPress: Pxcb_button_press_event_t;
begin
  if Event^.response_type = XCB_BUTTON_PRESS then
  begin
    ButtonPress := Pxcb_button_press_event_t(Event);
    if (ButtonPress^.event_x >= FX) and (ButtonPress^.event_x <= FX + FWidth) and
       (ButtonPress^.event_y >= FY) and (ButtonPress^.event_y <= FY + FHeight) then
    begin
      if Assigned(FOnClick) then
        FOnClick(Self);
    end;
  end;
end;

end.