program minimalbg;

{
    Minimal BG.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}
uses
  SysUtils, Unix,BaseUnix;

type
  TBackgroundManager = class
  private
    FColor: string; // Цвет фона
  public
    constructor Create;
    procedure SetBackground;
    procedure Daemonize;
  end;

constructor TBackgroundManager.Create;
begin
  FColor := 'red'; // Устанавливаем цвет фона (красный)
end;

procedure TBackgroundManager.SetBackground;
begin
  // Устанавливаем цвет фона с помощью xsetroot
  FpSystem('xsetroot -solid ' + FColor);
end;

procedure TBackgroundManager.Daemonize;
var
  PID: TPID;
begin
  // Шаг 1: Создаём новый процесс
  PID := FpFork;
  if PID < 0 then
  begin
    WriteLn('Error: Unable to fork');
    Halt(1);
  end;
  if PID > 0 then
    Halt(0); // Завершаем родительский процесс

  // Шаг 2: Создаём новый сеанс
  if FpSetsid < 0 then
  begin
    WriteLn('Error: Unable to create new session');
    Halt(1);
  end;

  // Шаг 3: Закрываем стандартные файловые дескрипторы
  FpClose(StdInputHandle);
  FpClose(StdOutputHandle);
  FpClose(StdErrorHandle);

  // Шаг 4: Перенаправляем вывод в /dev/null
  AssignFile(Output, '/dev/null');
  Rewrite(Output);
  AssignFile(ErrOutput, '/dev/null');
  Rewrite(ErrOutput);
end;

var
  BackgroundManager: TBackgroundManager;

begin
  BackgroundManager := TBackgroundManager.Create;
  try
    // Демонизируем программу
    BackgroundManager.Daemonize;

    // Устанавливаем цвет фона
    BackgroundManager.SetBackground;

    // Основной цикл программы (просто ждём)
    while True do
    begin
      FpSleep(60); // Спим 60 секунд, чтобы программа не завершалась
    end;
  finally
    BackgroundManager.Free;
  end;
end.