program sliders_test;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}

uses
  SysUtils, xcbunit, xcb_sliders;

begin
  c := xcb_connect(nil, nil);
  if xcb_connection_has_error(c) <> 0 then
  begin
    WriteLn('Error: Unable to connect to X server');
    Halt(1);
  end;

  screen := xcb_setup_roots_iterator(xcb_get_setup(c)).data;

  create_window;

WriteLn(1);
  alloc_button(create_button(DRAGGABLE, 'xy', 50, 50, @x_y));
WriteLn(2);
  alloc_button(create_button(DRAGGABLE_X, 'x', 200, 50, @x));
WriteLn(3);
  alloc_button(create_button(DRAGGABLE_Y, 'y', 50, 100, @y));
WriteLn(4);
  xcb_flush(c);
WriteLn(5);
  event_loop;
WriteLn(6);
  WriteLn('bye!');
end.