#include <stdio.h>

#include <locale.h>
#include <langinfo.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>

int main(int argc, char **argv) {
	const char *locale = setlocale(LC_ALL, "");
	if (locale == NULL) {
		fprintf(stderr, "Locale unavailable.\n");
	}

	char *localeCharset = nl_langinfo(CODESET);
	printf("locale: %s\n", locale);
	printf("run-time charset: %s\n", localeCharset);

	XtSetLanguageProc(NULL, (XtLanguageProc) NULL, (XtPointer) NULL);

	Display* dpy = XOpenDisplay(NULL);

	char ** missingCharsets;
	int missingCharsetCount = 0;
	char * defaultString;
    char *fontList = "-misc-fixed-medium-r-*-*-14-*-*-*-*-*-*-*";
    if (argv[1] && argv[1][0]) {
        fontList = argv[1];
    }
	XFontSet fontSet = XCreateFontSet(dpy,
            fontList,
			&missingCharsets,
			&missingCharsetCount,
			&defaultString);

	printf("X11 locale: %s\n", XLocaleOfFontSet(fontSet));
	printf("XFontSet: %s\n", XBaseFontNameListOfFontSet(fontSet));

	if (missingCharsetCount > 0) {
		printf("Charsets missing from XFontSet:\n");
		for (int i = 0; i < missingCharsetCount; i++) {
			char * missingCharset = *(missingCharsets + i);
			printf("\t%s\n", missingCharset);
		}
		XFreeStringList(missingCharsets);
	}

	printf("XFontStruct entries in XFontSet:\n");

	XFontStruct** fonts;
	char ** fontNames;
	int count = XFontsOfFontSet(fontSet, &fonts, &fontNames);
	for (int i = 0; i < count; i++) {
		XFontStruct * const font = *(fonts + i);
		char * const fallbackFontName = *(fontNames + i);


		unsigned long fontNameAtom;
		if (!XGetFontProperty(font, XA_FONT, &fontNameAtom)) {
			printf("\tXGetFontProperty(XA_FONT) failed\n");
			printf("\t%s\n", fallbackFontName);
		} else {
			char * const fontName = XGetAtomName(dpy, (Atom) fontNameAtom);
			printf("\t%s\n", fontName);
			XFree(fontName);
		}
	}

	XCloseDisplay(dpy);

	return 0;
}