program test;

{$mode delphi}

uses 
  SysUtils,
  Classes;

type
  TObjectDescendant = class(TObject);

  TTestType = record
  public
    Member: longint;

    class operator Implicit(const Value: TObject): TTestType;
    class operator Implicit(const Value: Pointer): TTestType;
  end;

class operator TTestType.Implicit(const Value: TObject): TTestType;
begin
  Result.Member := 1;
end;

class operator TTestType.Implicit(const Value: Pointer): TTestType;
begin
  Result.Member := 2;
  raise Exception.Create('Descending class implicit operators should match the parent operator and not default to Pointer');
end;

procedure reproduce;
var
  localType: TTestType;
  obj: TObject;
  objDesc: TObjectDescendant;
begin
  obj := TObject.Create;
  objDesc := TObjectDescendant.Create;
  try
    localType := obj; // This is ok
    if localType.Member <> 1 then ;
    localType := objDesc; // This will raise an exception
    if localType.Member <> 2 then ;
  finally
    FreeAndNil(obj);
    FreeAndNil(objDesc);
  end;
end;

begin
  reproduce;
end.
