program test4;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}
uses
  SysUtils, xcbunit, xcbwin;

var
  Win: TXcbwin; // Объявляем переменную типа TXcbwin

begin
  Win := TXcbwin.Create(True); // Создаём объект с включённым verbose mode
  try
    // Открываем окно размером 400x300
    Win.Open(400, 300);

    // Рисуем пять квадратов разного цвета
    WriteLn('Drawing red square...');
    Win.SetColorRGB(255, 0, 0); // Красный
    Win.DrawFilledRectangle(50, 50, 100, 100);

    WriteLn('Drawing green square...');
    Win.SetColorRGB(0, 255, 0); // Зелёный
    Win.DrawFilledRectangle(150, 50, 100, 100);

    WriteLn('Drawing blue square...');
    Win.SetColorRGB(0, 0, 255); // Синий
    Win.DrawFilledRectangle(250, 50, 100, 100);

    WriteLn('Drawing yellow square...');
    Win.SetColorRGB(255, 255, 0); // Жёлтый
    Win.DrawFilledRectangle(50, 150, 100, 100);

    WriteLn('Drawing magenta square...');
    Win.SetColorRGB(255, 0, 255); // Пурпурный
    Win.DrawFilledRectangle(150, 150, 100, 100);

    // Принудительно обновляем окно
    WriteLn('Flushing the window...');
    Win.Flush;

    // Ожидаем нажатия клавиши
    WriteLn('Waiting for key press...');
    Win.Wait;

    // Добавляем небольшую задержку перед закрытием окна
    Sleep(1000);
  finally
    // Закрываем окно и освобождаем память
    WriteLn('Closing the window...');
    Win.CloseWindow;
    Win.Free;
  end;
end.