program testblackandwhite;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}

uses
  SysUtils, xcbunit, ctypes;

var
  Connection: Pxcb_connection_t;
  Screen: Pxcb_screen_t;
  Win: xcb_window_t;
  Gc: xcb_gcontext_t;
  Font: xcb_font_t;
  Values: array[0..1] of cuint32;
  Mask: cuint32;
  Event: Pxcb_generic_event_t;
  Cookie: xcb_void_cookie_t;
  Rect: xcb_rectangle_t;

begin
  // Подключение к X-серверу
  WriteLn('Connecting to X server...');
  Connection := xcb_connect(nil, nil);
  if xcb_connection_has_error(Connection) <> 0 then
  begin
    WriteLn('Error: Unable to connect to X server');
    Halt(1);
  end;
  WriteLn('Connected to X server');

  // Получение экрана
  WriteLn('Getting screen...');
  Screen := xcb_setup_roots_iterator(xcb_get_setup(Connection)).data;
  if Screen = nil then
  begin
    WriteLn('Error: Unable to get screen');
    Halt(1);
  end;
  WriteLn('Screen obtained');

  // Создание окна
  WriteLn('Creating window...');
  Win := xcb_generate_id(Connection);

  // Установка event_mask и цвета фона
  Values[0] := Screen^.white_pixel; // Цвет фона (белый)
  Values[1] := XCB_EVENT_MASK_EXPOSURE or XCB_EVENT_MASK_KEY_PRESS; // Маска событий

  xcb_create_window(
    Connection,
    XCB_COPY_FROM_PARENT,
    Win,
    Screen^.root,
    100, 100,
    800, 600,  // Увеличиваем размер окна
    1,
    XCB_WINDOW_CLASS_INPUT_OUTPUT,
    Screen^.root_visual,
    XCB_CW_BACK_PIXEL or XCB_CW_EVENT_MASK,
    @Values[0]
  );
  WriteLn('Window created');

  // Отображение окна
  WriteLn('Mapping window...');
  xcb_map_window(Connection, Win);
  xcb_flush(Connection);
  WriteLn('Window mapped');

  // Создание графического контекста
  WriteLn('Creating graphics context...');
  Gc := xcb_generate_id(Connection);

  // Установка цветов
  Values[0] := Screen^.black_pixel; // Цвет переднего плана (чёрный)
  Values[1] := Screen^.white_pixel; // Цвет фона (белый)

  WriteLn('Foreground color (black): ', Values[0]);
  WriteLn('Background color (white): ', Values[1]);

  // Создание графического контекста
  Mask := XCB_GC_FOREGROUND or XCB_GC_BACKGROUND or XCB_GC_FONT;
  WriteLn('Creating GC with foreground=', Values[0], ' and background=', Values[1]);
  xcb_create_gc(Connection, Gc, Win, Mask, @Values[0]);
  if Gc = 0 then
  begin
    WriteLn('Error: Unable to create graphics context');
    Halt(1);
  end;
  WriteLn('Graphics context created');

  // Загрузка шрифта
  WriteLn('Loading font...');
  Font := xcb_generate_id(Connection);
  Cookie := xcb_open_font(Connection, Font, Length('9x15'), '9x15');

  // Проверка успешности загрузки шрифта
  if xcb_request_check(Connection, Cookie) <> nil then
  begin
    WriteLn('Error: Unable to load font "9x15"');
    Halt(1);
  end
  else
  begin
    WriteLn('Font "9x15" loaded successfully');
  end;

  // Установка шрифта в графический контекст
  WriteLn('Setting font in graphics context...');
  xcb_change_gc(Connection, Gc, XCB_GC_FONT, @Font);

  // Проверка успешности изменения графического контекста
  if xcb_request_check(Connection, Cookie) <> nil then
  begin
    WriteLn('Error: Unable to set font in graphics context');
    Halt(1);
  end
  else
  begin
    WriteLn('Font set in graphics context successfully');
  end;

  // Основной цикл обработки событий
  WriteLn('Entering event loop...');
  while True do
  begin
    Event := xcb_wait_for_event(Connection);
    if Event = nil then Break;

    case Event^.response_type and $7F of
      XCB_EXPOSE:
      begin
        WriteLn('Expose event received, drawing letter "A"');

        // Вывод буквы "A" в разные координаты
        xcb_poly_text_8(Connection, Win, Gc, 10, 20, 1, 'A');  // Верхний левый угол
        xcb_poly_text_8(Connection, Win, Gc, 50, 50, 1, 'A');  // Центр окна
        xcb_poly_text_8(Connection, Win, Gc, 200, 100, 1, 'A'); // Правая часть окна

        // Отрисовка прямоугольника в центре окна
        Rect.x := 350;  // Центр по X (800 / 2 - 50)
        Rect.y := 250;  // Центр по Y (600 / 2 - 50)
        Rect.width := 100;
        Rect.height := 100;

        // Рисуем прямоугольник
        xcb_poly_fill_rectangle(Connection, Win, Gc, 1, @Rect);
        WriteLn('Rectangle drawn at (350, 250)');

        // Принудительное обновление экрана
        xcb_flush(Connection);
        WriteLn('Text and rectangle drawn');
      end;
      XCB_KEY_PRESS:
      begin
        WriteLn('Key press detected, exiting');
        Break;
      end;
    end;

    // Освобождаем память для события
//    FreeMem(Event);
  end;

  // Очистка
  WriteLn('Cleaning up...');
  xcb_close_font(Connection, Font);
  xcb_free_gc(Connection, Gc);
  xcb_disconnect(Connection);
  WriteLn('Cleanup complete');
end.