program testcolor;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}
// Yellow window, color on
uses
  SysUtils, xcbunit, ctypes;

var
  Connection: Pxcb_connection_t;
  Screen: Pxcb_screen_t;
  Win, BackPixmap: xcb_drawable_t;
  Gc: xcb_gcontext_t;
  Event: Pxcb_generic_event_t;
  Values: array[0..2] of cuint32;
  Mask: cuint32;
  Rectangles: array[0..4] of xcb_rectangle_t;
  Colors: array[0..4] of cuint32;

procedure DrawRectangles;
var
  I: Integer;
  Cookie: xcb_void_cookie_t;
  ClearRect: xcb_rectangle_t;
begin
  WriteLn('Drawing rectangles...');

  // Очищаем весь BackPixmap белым цветом
  ClearRect.x := 0;
  ClearRect.y := 0;
  ClearRect.width := 400;
  ClearRect.height := 300;
  Values[0] := Screen^.white_pixel; // Используем белый цвет для очистки
  Mask := XCB_GC_FOREGROUND; // Используем маску для переднего плана
  Cookie := xcb_change_gc(Connection, Gc, Mask, @Values[0]);
  if xcb_request_check(Connection, Cookie) <> nil then
    WriteLn('Error: Failed to change GC foreground');

  xcb_poly_fill_rectangle(Connection, BackPixmap, Gc, 1, @ClearRect);

  // Рисуем прямоугольники
  for I := 0 to High(Rectangles) do
  begin
    WriteLn('   F = ', I);
    Values[0] := Colors[I];
    WriteLn('Changing GC foreground to: ', IntToHex(Colors[I], 8));
    Mask := XCB_GC_FOREGROUND; // Используем маску для переднего плана
    Cookie := xcb_change_gc(Connection, Gc, Mask, @Values[0]);
    if xcb_request_check(Connection, Cookie) <> nil then
      WriteLn('Error: Failed to change GC foreground');

    // Заливаем прямоугольник цветом
    WriteLn('Filling rectangle ', I, ' at (', Rectangles[I].x, ', ', Rectangles[I].y, ') with size ', Rectangles[I].width, 'x', Rectangles[I].height);
    xcb_poly_fill_rectangle(Connection, BackPixmap, Gc, 1, @Rectangles[I]);
  end;

  // Копируем содержимое пиксмапа в окно
  xcb_copy_area(Connection, BackPixmap, Win, Gc, 0, 0, 0, 0, 400, 300);
  xcb_flush(Connection);
end;

begin
  Connection := xcb_connect(nil, nil);
  if xcb_connection_has_error(Connection) <> 0 then
  begin
    WriteLn('Error: Unable to connect to X server');
    Halt(1);
  end;

  Screen := xcb_setup_roots_iterator(xcb_get_setup(Connection)).data;
  if Screen = nil then
  begin
    WriteLn('Error: Unable to get screen');
    Halt(1);
  end;

  WriteLn('Screen root visual: ', IntToHex(Screen^.root_visual, 4));

  // Создаём пиксмап для off-screen буфера
  BackPixmap := xcb_generate_id(Connection);
  xcb_create_pixmap(Connection, Screen^.root_depth, BackPixmap, Screen^.root, 400, 300);

  // Создаём окно с белым фоном
  Win := xcb_generate_id(Connection);
  Values[0] := Screen^.white_pixel; // Устанавливаем белый фон
  Mask := XCB_CW_BACK_PIXEL or XCB_CW_EVENT_MASK;
  Values[1] := XCB_EVENT_MASK_EXPOSURE or XCB_EVENT_MASK_BUTTON_PRESS;
  xcb_create_window(Connection, XCB_COPY_FROM_PARENT, Win, Screen^.root, 100, 100, 400, 300, 1, XCB_WINDOW_CLASS_INPUT_OUTPUT, Screen^.root_visual, Mask, @Values[0]);

  xcb_map_window(Connection, Win);
  xcb_flush(Connection);
  WriteLn('Window created and mapped');
  Sleep(1000);

  Gc := xcb_generate_id(Connection);
  Mask := XCB_GC_FOREGROUND or XCB_GC_BACKGROUND or XCB_GC_GRAPHICS_EXPOSURES;
Values[0] := Screen^.black_pixel;
  Values[1] := Screen^.white_pixel;
  Values[2] := 0;
  xcb_create_gc(Connection, Gc, Win, Mask, @Values[0]);
  WriteLn('Graphics context created: ', Gc);

  // Определяем цвета прямоугольников
  Colors[0] := Screen^.black_pixel; // Чёрный
  Colors[1] := Screen^.white_pixel; // Белый
  Colors[2] := $00FF0000; // Красный
  Colors[3] := $0000FF00; // Зелёный
  Colors[4] := $000000FF; // Синий

  WriteLn('Allocated colors: R=', IntToHex(Colors[2], 8), ', G=', IntToHex(Colors[3], 8), ', B=', IntToHex(Colors[4], 8));

  // Определяем прямоугольники
  Rectangles[0].x := 50;  Rectangles[0].y := 50;  Rectangles[0].width := 50; Rectangles[0].height := 50;
  Rectangles[1].x := 150; Rectangles[1].y := 50;  Rectangles[1].width := 50; Rectangles[1].height := 50;
  Rectangles[2].x := 250; Rectangles[2].y := 50;  Rectangles[2].width := 50; Rectangles[2].height := 50;
  Rectangles[3].x := 50;  Rectangles[3].y := 150; Rectangles[3].width := 50; Rectangles[3].height := 50;
  Rectangles[4].x := 150; Rectangles[4].y := 150; Rectangles[4].width := 50; Rectangles[4].height := 50;

  // Рисуем прямоугольники
  DrawRectangles;

  while True do
  begin
    Event := xcb_wait_for_event(Connection);
    if Event = nil then
    begin
      WriteLn('Error: Unable to get event');
      Break;
    end;

    case Event^.response_type and not $80 of
      XCB_EXPOSE:
      begin
        WriteLn('Expose event received, redrawing rectangles...');
        DrawRectangles; // Перерисовываем прямоугольники
      end;
      XCB_BUTTON_PRESS:
        Break;
    end;
  end;

  xcb_free_gc(Connection, Gc);
  xcb_disconnect(Connection);
end.