program testcolor2;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}

uses
  SysUtils, xcbunit, ctypes;

var
  Connection: Pxcb_connection_t;
  Screen: Pxcb_screen_t;
  Win: xcb_window_t;
  Gc: xcb_gcontext_t;
  Event: Pxcb_generic_event_t;
  Values: array[0..1] of cuint32;
  Mask: cuint32;
  Rectangles: array[0..4] of xcb_rectangle_t;
  Colors: array[0..4] of cuint32;
  Visual: Pxcb_visualtype_t;
  red_mask, green_mask, blue_mask: cuint32;

function GetTrueColorPixel(R, G, B: cuint16): cuint32;
begin
  // Используем маски для корректного преобразования RGB в пиксельный формат X11
  Result := ((R shr 8) * (red_mask div $FF)) and red_mask or
            ((G shr 8) * (green_mask div $FF)) and green_mask or
            ((B shr 8) * (blue_mask div $FF)) and blue_mask;
end;

procedure DrawRectangles;
var
  I: Integer;
begin
  WriteLn('Drawing rectangles...');
  for I := 0 to High(Rectangles) do
  begin
    Values[0] := Colors[I];
    WriteLn('Changing GC foreground to: ', IntToHex(Colors[I], 8));
    xcb_change_gc(Connection, Gc, XCB_GC_FOREGROUND, @Values[0]);
    xcb_poly_fill_rectangle(Connection, Win, Gc, 1, @Rectangles[I]);
  end;
  xcb_flush(Connection);
end;

begin
  Connection := xcb_connect(nil, nil);
  if xcb_connection_has_error(Connection) <> 0 then
  begin
    WriteLn('Error: Unable to connect to X server');
    Halt(1);
  end;

  Screen := xcb_setup_roots_iterator(xcb_get_setup(Connection)).data;
  if Screen = nil then
  begin
    WriteLn('Error: Unable to get screen');
    Halt(1);
  end;

  WriteLn('Screen root visual: ', IntToHex(Screen^.root_visual, 4));

  // Получаем информацию о TrueColor visual
  Visual := nil;
  var iter := xcb_depth_visuals_iterator(xcb_screen_allowed_depths_iterator(Screen));
  while iter.rem <> 0 do
  begin
    if (iter.data._class = XCB_VISUAL_CLASS_TRUE_COLOR) then
    begin
      Visual := iter.data;
      Break;
    end;
    xcb_visualtype_next(@iter);
  end;

  if Visual = nil then
  begin
    WriteLn('Error: No TrueColor visual found');
    Halt(1);
  end;

  // Извлекаем маски цветов
  red_mask := Visual^.red_mask;
  green_mask := Visual^.green_mask;
  blue_mask := Visual^.blue_mask;
  WriteLn('Color masks: R=', IntToHex(red_mask, 8), ', G=', IntToHex(green_mask, 8), ', B=', IntToHex(blue_mask, 8));

  Wi
