program testfigures;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}

uses
  SysUtils, xcbunit,ctypes;

var
  Connection: Pxcb_connection_t;
  Screen: Pxcb_screen_t;
  Win: xcb_window_t;
  Gc: xcb_gcontext_t;
  Event: Pxcb_generic_event_t;

  // Geometric objects
  Points: array[0..3] of xcb_point_t = (
    (x: 10; y: 10),
    (x: 10; y: 20),
    (x: 20; y: 10),
    (x: 20; y: 20)
  );

  Polyline: array[0..3] of xcb_point_t = (
    (x: 50; y: 10),
    (x: 5;  y: 20),
    (x: 25; y: -20),
    (x: 10; y: 10)
  );

  Segments: array[0..1] of xcb_segment_t = (
    (x1: 100; y1: 10; x2: 140; y2: 30),
    (x1: 110; y1: 25; x2: 130; y2: 60)
  );

  Rectangles: array[0..1] of xcb_rectangle_t = (
    (x: 10; y: 50; width: 40; height: 20),
    (x: 80; y: 50; width: 10; height: 40)
  );

  Arcs: array[0..1] of xcb_arc_t = (
    (x: 10; y: 100; width: 60; height: 40; angle1: 0; angle2: 90 shl 6),
    (x: 90; y: 100; width: 55; height: 40; angle1: 0; angle2: 270 shl 6)
  );

  // Переменные для создания графического контекста
  Mask: cuint32;
  Values: array[0..1] of cuint32;

begin
  // Open the connection to the X server
  Connection := xcb_connect(nil, nil);
  if xcb_connection_has_error(Connection) <> 0 then
  begin
    WriteLn('Error: Unable to connect to X server');
    Halt(1);
  end;

  // Get the first screen
  Screen := xcb_setup_roots_iterator(xcb_get_setup(Connection)).data;
  if Screen = nil then
  begin
    WriteLn('Error: Unable to get screen');
    Halt(1);
  end;

  // Create black (foreground) graphic context
  Win := Screen^.root;
  Gc := xcb_generate_id(Connection);
  Mask := XCB_GC_FOREGROUND or XCB_GC_GRAPHICS_EXPOSURES;
  Values[0] := Screen^.black_pixel; // Цвет переднего плана (чёрный)
  Values[1] := 0;                  // Отключение GraphicsExpose событий
  xcb_create_gc(Connection, Gc, Win, Mask, @Values[0]);

  // Create a window
  Win := xcb_generate_id(Connection);
  Mask := XCB_CW_BACK_PIXEL or XCB_CW_EVENT_MASK;
  Values[0] := Screen^.white_pixel; // Цвет фона (белый)
  Values[1] := XCB_EVENT_MASK_EXPOSURE; // Маска событий
  xcb_create_window(Connection, XCB_COPY_FROM_PARENT, Win, Screen^.root,
                    0, 0, 150, 150, 10, XCB_WINDOW_CLASS_INPUT_OUTPUT,
                    Screen^.root_visual, Mask, @Values[0]);

  // Map the window on the screen and flush
  xcb_map_window(Connection, Win);
  xcb_flush(Connection);

  // Draw primitives
  while True do
  begin
    Event := xcb_wait_for_event(Connection);
    if Event = nil then
    begin
      WriteLn('Error: Unable to get event');
      Break;
    end;

    case Event^.response_type and not $80 of
      XCB_EXPOSE:
        begin
          // Draw the points
          xcb_poly_point(Connection, XCB_COORD_MODE_ORIGIN, Win, Gc, 4, @Points[0]);
          // Draw the polygonal line
          xcb_poly_line(Connection, XCB_COORD_MODE_PREVIOUS, Win, Gc, 4, @Polyline[0]);
          // Draw the segments
          xcb_poly_segment(Connection, Win, Gc, 2, @Segments[0]);
          // Draw the rectangles
          xcb_poly_rectangle(Connection, Win, Gc, 2, @Rectangles[0]);
          // Draw the arcs
          xcb_poly_arc(Connection, Win, Gc, 2, @Arcs[0]);
          // Flush the request
          xcb_flush(Connection);
        end;
      else
        // Unknown event type, ignore it
        WriteLn('Unknown event type: ', Event^.response_type and not $80);
    end;

    // Free the event
//    FreeMem(Event);
  end;

  // Cleanup
  xcb_disconnect(Connection);
end.