#include <xcb/xcb.h>
#include <stdio.h>
#include <stdlib.h>

//    XCB Bindings.
//    For GNU/Linux.
//    Version: 1.
//    Written on FreePascal (https://freepascal.org/).
//    Copyright (C) 2025-2026  Artyomov Alexander
//    http://self-made-free.ru/
//    Used https://chat.deepseek.com/, https://chatgpt.com/
//    aralni@mail.ru

//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Affero General Public License as
//    published by the Free Software Foundation, either version 3 of the
//    License, or (at your option) any later version.

//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Affero General Public License for more details.

//    You should have received a copy of the GNU Affero General Public License
//    along with this program.  If not, see <https://www.gnu.org/licenses/>.

int main() {
    // Подключение к X-серверу
    xcb_connection_t *connection = xcb_connect(NULL, NULL);
    if (xcb_connection_has_error(connection)) {
        printf("Error: Unable to connect to X server\n");
        return 1;
    }

    // Получение экрана
    const xcb_setup_t *setup = xcb_get_setup(connection);
    xcb_screen_iterator_t screen_iter = xcb_setup_roots_iterator(setup);
    xcb_screen_t *screen = screen_iter.data;
    if (screen == NULL) {
        printf("Error: Unable to get screen\n");
        xcb_disconnect(connection);
        return 1;
    }

    // Создание окна
    xcb_window_t win = xcb_generate_id(connection);
    uint32_t values[1];
    values[0] = screen->white_pixel;
    uint32_t mask = XCB_CW_BACK_PIXEL | XCB_CW_EVENT_MASK;
    xcb_create_window(connection, XCB_COPY_FROM_PARENT, win, screen->root,
                      100, 100, 400, 300, 1, XCB_WINDOW_CLASS_INPUT_OUTPUT,
                      screen->root_visual, mask, values);

    // Отображение окна
    xcb_map_window(connection, win);
    xcb_flush(connection);

    // Создание графического контекста
    xcb_gcontext_t gc = xcb_generate_id(connection);
    uint32_t gc_values[2];
    gc_values[0] = screen->black_pixel; // Цвет переднего плана (чёрный)
    gc_values[1] = screen->white_pixel; // Цвет фона (белый)
    mask = XCB_GC_FOREGROUND | XCB_GC_BACKGROUND | XCB_GC_GRAPHICS_EXPOSURES;
    xcb_create_gc(connection, gc, win, mask, gc_values);

    // Создание цветовой карты
    xcb_colormap_t colormap = xcb_generate_id(connection);
    xcb_create_colormap(connection, XCB_COLORMAP_ALLOC_NONE, colormap, win, screen->root_visual);
    printf("Colormap created: %u\n", colormap);

    // Проверка, что цветовая карта создана
    printf("Screen root visual: %u\n", screen->root_visual);

    // Выделение цветов
    xcb_alloc_color_reply_t *color_reply;
    uint32_t colors[5];

    // Чёрный цвет (R=0, G=0, B=0)
    color_reply = xcb_alloc_color_reply(connection, xcb_alloc_color(connection, colormap, 0, 0, 0), NULL);
    if (color_reply) {
        colors[0] = color_reply->pixel;
        printf("Black color allocated: Pixel=%u\n", colors[0]);
        free(color_reply);
    } else {
        printf("Failed to allocate black color\n");
        colors[0] = screen->black_pixel;
    }

    // Белый цвет (R=65535, G=65535, B=65535)
    color_reply = xcb_alloc_color_reply(connection, xcb_alloc_color(connection, colormap, 65535, 65535, 65535), NULL);
    if (color_reply) {
        colors[1] = color_reply->pixel;
        printf("White color allocated: Pixel=%u\n", colors[1]);
        free(color_reply);
    } else {
        printf("Failed to allocate white color\n");
        colors[1] = screen->white_pixel;
    }

    // Красный цвет (R=65535, G=0, B=0)
    color_reply = xcb_alloc_color_reply(connection, xcb_alloc_color(connection, colormap, 65535, 0, 0), NULL);
    if (color_reply) {
        colors[2] = color_reply->pixel;
        printf("Red color allocated: Pixel=%u\n", colors[2]);
        free(color_reply);
    } else {
        printf("Failed to allocate red color\n");
        colors[2] = screen->black_pixel;
    }

    // Зелёный цвет (R=0, G=65535, B=0)
    color_reply = xcb_alloc_color_reply(connection, xcb_alloc_color(connection, colormap, 0, 65535, 0), NULL);
    if (color_reply) {
        colors[3] = color_reply->pixel;
        printf("Green color allocated: Pixel=%u\n", colors[3]);
        free(color_reply);
    } else {
        printf("Failed to allocate green color\n");
        colors[3] = screen->black_pixel;
    }

    // Синий цвет (R=0, G=0, B=65535)
    color_reply = xcb_alloc_color_reply(connection, xcb_alloc_color(connection, colormap, 0, 0, 65535), NULL);
    if (color_reply) {
        colors[4] = color_reply->pixel;
        printf("Blue color allocated: Pixel=%u\n", colors[4]);
        free(color_reply);
    } else {
        printf("Failed to allocate blue color\n");
        colors[4] = screen->black_pixel;
    }

    // Ожидание событий (для демонстрации)
    printf("Waiting for events...\n");
    xcb_generic_event_t *event;
    while ((event = xcb_wait_for_event(connection))) {
        printf("Received event: %u\n", event->response_type & ~0x80);
        free(event);
    }

    // Очистка
    xcb_free_gc(connection, gc);
    xcb_disconnect(connection);

    return 0;
}