#include <xcb/xcb.h>
#include <stdio.h>
#include <stdlib.h>

int main() {
    // Подключение к X-серверу
    xcb_connection_t *connection = xcb_connect(NULL, NULL);
    if (xcb_connection_has_error(connection)) {
        fprintf(stderr, "Error: Unable to connect to X server\n");
        return 1;
    }

    // Получение экрана
    const xcb_setup_t *setup = xcb_get_setup(connection);
    xcb_screen_t *screen = xcb_setup_roots_iterator(setup).data;

    // Создание окна
    xcb_window_t window = xcb_generate_id(connection);
    xcb_create_window(connection, XCB_COPY_FROM_PARENT, window, screen->root,
                      0, 0, 400, 300, 1, XCB_WINDOW_CLASS_INPUT_OUTPUT,
                      screen->root_visual, 0, NULL);

    // Отображение окна
    xcb_map_window(connection, window);
    xcb_flush(connection);

    // Основной цикл обработки событий
    xcb_generic_event_t *event;
    while ((event = xcb_wait_for_event(connection))) {
        switch (event->response_type & ~0x80) {
            case XCB_EXPOSE:
                printf("Expose event received\n");
                break;
            case XCB_BUTTON_PRESS:
                printf("Button press event received\n");
                break;
            default:
                printf("Unknown event received\n");
                break;
        }
        free(event);
    }

    // Закрытие соединения
    xcb_disconnect(connection);
    return 0;
}