unit xcb;

{$mode fpc}{$PACKRECORDS C}{$MACRO ON}{$CALLING CDECL}

interface

uses
  ctypes,
  xcb_extra; // Подключение модуля xcb_extra

(**
 * @defgroup XCB_Core_API XCB Core API
 * @brief Core API of the XCB library.
 *
 * @{
 *)

function XCB_TYPE_PAD(const T, I : clong) : clong;

(* xcb_out.c *)

function xcb_flush(c : Pxcb_connection_t) : cint;
  external libXCB;

function xcb_get_maximum_request_length(c : Pxcb_connection_t) : cuint32;
  external libXCB;

procedure xcb_prefetch_maximum_request_length(c : Pxcb_connection_t);
  external libXCB;

(* xcb_in.c *)

function xcb_wait_for_event(c : Pxcb_connection_t) : Pxcb_generic_event_t;
  external libXCB;

function xcb_poll_for_event(c : Pxcb_connection_t) : Pxcb_generic_event_t;
  external libXCB;

function xcb_request_check(c : Pxcb_connection_t; cookie : Pxcb_void_cookie_t) : Pxcb_generic_error_t;
  external libXCB;

(* xcb_ext.c *)

function xcb_get_extension_data(c : Pxcb_connection_t; ext : Pxcb_extension_t) : Pxcb_query_extension_reply_t;
  external libXCB;

procedure xcb_prefetch_extension_data(c : Pxcb_connection_t; ext : Pxcb_extension_t);
  external libXCB;

(* xcb_conn.c *)

function xcb_get_setup(c : Pxcb_connection_t) : Pxcb_setup_t;
  external libXCB;

function xcb_get_file_descriptor(c : Pxcb_connection_t) : cint;
  external libXCB;

function xcb_connection_has_error(c : Pxcb_connection_t) : cint;
  external libXCB;

function xcb_connect_to_fd(fd : cint; auth_info : pxcb_auth_info_t) : pxcb_connection_t;
  external libXCB;

procedure xcb_disconnect(c : Pxcb_connection_t);
  external libXCB;

(* xcb_util.c *)

function xcb_parse_display(name : PChar; host : PPChar; display : pcint; screen : pcint) : cint;
  external libXCB;

function xcb_connect(displayname : PChar; screenp : pcint) : Pxcb_connection_t;
  external libXCB;

function xcb_connect_to_display_with_auth_info(display : PChar; auth : Pxcb_auth_info_t; screen : pcint) : Pxcb_connection_t;
  external libXCB;

(* xcb_xid.c *)

function xcb_generate_id(c : Pxcb_connection_t) : cuint32;
  external libXCB;

(* Добавленные функции *)
function xcb_setup_roots_iterator(const R: Pxcb_setup_t): xcb_screen_iterator_t; cdecl; external libXCB;

function xcb_create_window(
    c: Pxcb_connection_t;
    depth: cuint8;
    wid: xcb_window_t;
    parent: xcb_window_t;
    x, y: cint16;
    width, height: cuint16;
    border_width: cuint16;
    _class: cuint16;
    visual: xcb_visualid_t;
    value_mask: cuint32;
    value_list: pcuint32
): xcb_void_cookie_t; cdecl; external libXCB;

function xcb_map_window(c: Pxcb_connection_t; window: xcb_window_t): xcb_void_cookie_t; cdecl; external libXCB;

implementation

function XCB_TYPE_PAD ( const T, I : clong ) : clong;
begin
  if (-I and sizeof(T) >4) then
    XCB_TYPE_PAD := 3
  else
    XCB_TYPE_PAD := sizeof(T) - 1;
end;

end.