unit xcb_extra;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

interface

uses
  ctypes;

const
libXCB = 'libxcb.so';

type
  xcb_keycode_t = byte;
  xcb_window_t = cuint32;
  xcb_colormap_t = cuint32;
  xcb_visualid_t = cuint32;

  Pxcb_connection_t = ^xcb_connection_t;
  xcb_connection_t = record end;

  Pxcb_screen_t = ^xcb_screen_t;
  xcb_screen_t = record
    root: xcb_window_t;
    default_colormap: xcb_colormap_t;
    white_pixel: cuint32;
    black_pixel: cuint32;
    current_input_masks: cuint32;
    width_in_pixels: cuint16;
    height_in_pixels: cuint16;
    width_in_millimeters: cuint16;
    height_in_millimeters: cuint16;
    min_installed_maps: cuint16;
    max_installed_maps: cuint16;
    root_visual: xcb_visualid_t;
    backing_stores: cuint8;
    save_unders: cuint8;
    root_depth: cuint8;
    allowed_depths_len: cuint8;
  end;

  Pxcb_generic_event_t = ^xcb_generic_event_t;
  xcb_generic_event_t = record
    response_type: cuint8;
    pad0: cuint8;
    sequence: cuint16;
    pad: array[0..6] of cuint32;
  end;

  xcb_screen_iterator_t = record
    data: Pxcb_screen_t;
    rem: cint;
    index: cint;
  end;

  Pxcb_setup_t = ^xcb_setup_t;
  xcb_setup_t = record
    status: cuint8;
    pad0: cuint8;
    protocol_major_version: cuint16;
    protocol_minor_version: cuint16;
    length: cuint16;
    release_number: cuint32;
    resource_id_base: cuint32;
    resource_id_mask: cuint32;
    motion_buffer_size: cuint32;
    vendor_len: cuint16;
    maximum_request_length: cuint16;
    roots_len: cuint8;
    pixmap_formats_len: cuint8;
    image_byte_order: cuint8;
    bitmap_format_bit_order: cuint8;
    bitmap_format_scanline_unit: cuint8;
    bitmap_format_scanline_pad: cuint8;
    min_keycode: xcb_keycode_t;
    max_keycode: xcb_keycode_t;
    pad1: array[0..3] of cuint8;
  end;

  xcb_void_cookie_t = record
    sequence: cuint;
  end;

  Pxcb_query_extension_reply_t = ^xcb_query_extension_reply_t;
  xcb_query_extension_reply_t = record
    response_type: cuint8;
    pad0: cuint8;
    sequence: cuint16;
    length: cuint32;
    present: cuint8;
    major_opcode: cuint8;
    first_event: cuint8;
    first_error: cuint8;
  end;

const
  XCB_CW_BACK_PIXEL = 1 shl 0;
  XCB_CW_EVENT_MASK = 1 shl 1;
  XCB_EVENT_MASK_EXPOSURE = 1 shl 15;
  XCB_EVENT_MASK_KEY_PRESS = 1 shl 0;
  XCB_COPY_FROM_PARENT = 0;
  XCB_WINDOW_CLASS_INPUT_OUTPUT = 1;
  XCB_EXPOSE = 12;
  XCB_KEY_PRESS = 2;

implementation

end.