unit xcbconnectionunit;
{$MODE OBJFPC}{$LONGSTRINGS ON}{$RANGECHECKS ON}
interface
uses xcbunit;
const
  LC_ALL = 6;
function SetLocale(Context: Integer; Locale: PChar): PChar; cdecl; external name 'setlocale';
type
TXCBConnection = class
private
 FConnection: Pxcb_connection_t;
 FScreen: Pxcb_screen_t;
public
 procedure PrintScreenInfo;
 function Connect : bytebool;
 function Disconnect : bytebool;
 property Connection: Pxcb_connection_t read FConnection;
 property Screen: Pxcb_screen_t read FScreen;
end;

implementation

procedure TXCBConnection.PrintScreenInfo;
begin
with FScreen^ do begin
WriteLn('root = ', root);
WriteLn('default_colormap = ', default_colormap);
WriteLn('white_pixel = ', white_pixel);
WriteLn('black_pixel = ', black_pixel);
WriteLn('current_input_masks = ', current_input_masks);
WriteLn('width_in_pixels = ', width_in_pixels);
WriteLn('height_in_pixels = ', height_in_pixels);
WriteLn('width_in_millimeters = ', width_in_millimeters);
WriteLn('height_in_millimeters = ', height_in_millimeters);
WriteLn('min_installed_maps = ', min_installed_maps);
WriteLn('max_installed_maps = ', max_installed_maps);
WriteLn('root_visual = ', root_visual);
WriteLn('backing_stores = ', backing_stores);
WriteLn('save_unders = ', save_unders);
WriteLn('root_depth = ', root_depth);
WriteLn('allowed_depths_len = ', allowed_depths_len);
end;
end;

function TXCBConnection.Connect:bytebool;
begin
  // Установка локали
  WriteLn('Setting locale...');
  setlocale(LC_ALL, '');
  // Подключение к X-серверу
  WriteLn('Connecting to X server...');
  FConnection := xcb_connect(nil, nil);
  if xcb_connection_has_error(FConnection) <> 0 then begin
    WriteLn('Error: Unable to connect to X server');
    Exit(true);
  end;
  WriteLn('Connected to X server. FConnection = ', PtrUInt(FConnection));
  // Получение экрана
  WriteLn('Getting screen...');
  FScreen := xcb_setup_roots_iterator(xcb_get_setup(FConnection)).data;
  if FScreen = nil then begin
    WriteLn('Error: Unable to get screen');
    Exit(true);
  end;
  WriteLn('Screen obtained.');
  PrintScreenInfo;
Exit(false);
end;

function TXCBConnection.Disconnect:bytebool;
begin
WriteLn('Disconnecting...');
xcb_disconnect(FConnection);
Exit(false);
end;

end.