program xcbmin;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

uses
  xcbunit,ctypes; // Используем наш новый модуль

var
  connection: Pxcb_connection_t;
  screen: Pxcb_screen_t;
  window: xcb_window_t;
  event: Pxcb_generic_event_t;
  screen_iterator: xcb_screen_iterator_t;
  window_mask: cuint;
  window_values: array[0..1] of cuint32;

begin
  // Подключение к X-серверу
  connection := xcb_connect(nil, nil);
  if xcb_connection_has_error(connection) <> 0 then
  begin
    WriteLn('Error: Unable to connect to X server');
    Halt(1);
  end;

  // Получение экрана
  screen_iterator := xcb_setup_roots_iterator(xcb_get_setup(connection));
  screen := screen_iterator.data;

  // Создание окна
  window := xcb_generate_id(connection);
  window_mask := XCB_CW_BACK_PIXEL or XCB_CW_EVENT_MASK;
  window_values[0] := screen^.black_pixel;
  window_values[1] := XCB_EVENT_MASK_EXPOSURE or XCB_EVENT_MASK_KEY_PRESS;

  xcb_create_window(
    connection,
    XCB_COPY_FROM_PARENT,
    window,
    screen^.root,
    0, 0,
    400, 300,
    1,
    XCB_WINDOW_CLASS_INPUT_OUTPUT,
    screen^.root_visual,
    window_mask,
    @window_values
  );

  // Отображение окна
  xcb_map_window(connection, window);
  xcb_flush(connection);

  // Основной цикл обработки событий
  while True do
  begin
    event := xcb_wait_for_event(connection);
    if event = nil then
    begin
      WriteLn('Error: Unable to get event');
      Break;
    end;

    case event^.response_type and not $80 of
      XCB_EXPOSE:
        WriteLn('Expose event received');
      XCB_KEY_PRESS:
        WriteLn('Key press event received');
      else
        WriteLn('Unknown event received');
    end;

    FreeMem(event);
  end;

  // Закрытие соединения
  xcb_disconnect(connection);
end.