unit xcbunit;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$mode objfpc}{$H+}
{$PACKRECORDS C}
{$MACRO ON}
{$CALLING CDECL}

interface

uses
  ctypes;

// Основные типы
type
  xcb_keycode_t = cuint8;
  xcb_window_t = cuint32;
  xcb_colormap_t = cuint32;
  xcb_visualid_t = cuint32;
  xcb_gcontext_t = cuint32; // Графический контекст
  xcb_drawable_t = cuint32; // Drawable (окно или pixmap)
  xcb_atom_t = cuint32; // Атом
  xcb_timestamp_t = cuint32; // Временная метка
  xcb_button_t = cuint8; // Кнопка мыши
  xcb_key_t = cuint8; // Клавиша
  xcb_cursor_t = cuint32; // Курсор
  xcb_font_t = cuint32; // Шрифт
  xcb_pixmap_t = cuint32; // Pixmap

  Pxcb_connection_t = ^xcb_connection_t;
  xcb_connection_t = packed record end;

  Pxcb_screen_t = ^xcb_screen_t;
  xcb_screen_t = packed record
    root: xcb_window_t;
    default_colormap: xcb_colormap_t;
    white_pixel: cuint32;
    black_pixel: cuint32;
    current_input_masks: cuint32;
    width_in_pixels: cuint16;
    height_in_pixels: cuint16;
    width_in_millimeters: cuint16;
    height_in_millimeters: cuint16;
    min_installed_maps: cuint16;
    max_installed_maps: cuint16;
    root_visual: xcb_visualid_t;
    backing_stores: cuint8;
    save_unders: cuint8;
    root_depth: cuint8;
    allowed_depths_len: cuint8;
  end;

  Pxcb_generic_event_t = ^xcb_generic_event_t;
  xcb_generic_event_t = packed record
    response_type: cuint8;
    pad0: cuint8;
    sequence: cuint16;
    pad: array[0..6] of cuint32;
  end;

  Pxcb_generic_error_t = ^xcb_generic_error_t;
  xcb_generic_error_t = packed record
    response_type: cuint8;
    error_code: cuint8;
    sequence: cuint16;
    resource_id: cuint32;
    minor_code: cuint16;
    major_code: cuint8;
    pad0: cuint8;
    pad: array[0..4] of cuint32;
  end;

  Pxcb_expose_event_t = ^xcb_expose_event_t;
  xcb_expose_event_t = packed record
    response_type: cuint8;
    pad0: cuint8;
    sequence: cuint16;
    window: xcb_window_t;
    x: cuint16;
    y: cuint16;
    width: cuint16;
    height: cuint16;
    count: cuint16;
    pad1: array[0..1] of cuint8;
  end;

  xcb_screen_iterator_t = packed record
    data: Pxcb_screen_t;
    rem: cint;
    index: cint;
  end;

  Pxcb_setup_t = ^xcb_setup_t;
  xcb_setup_t = packed record
    status: cuint8;
    pad0: cuint8;
    protocol_major_version: cuint16;
    protocol_minor_version: cuint16;
    length: cuint16;
    release_number: cuint32;
    resource_id_base: cuint32;
    resource_id_mask: cuint32;
    motion_buffer_size: cuint32;
    vendor_len: cuint16;
    maximum_request_length: cuint16;
    roots_len: cuint8;
    pixmap_formats_len: cuint8;
    image_byte_order: cuint8;
    bitmap_format_bit_order: cuint8;
    bitmap_format_scanline_unit: cuint8;
    bitmap_format_scanline_pad: cuint8;
    min_keycode: xcb_keycode_t;
    max_keycode: xcb_keycode_t;
    pad1: array[0..3] of cuint8;
  end;

  Pxcb_configure_notify_event_t = ^xcb_configure_notify_event_t;
  xcb_configure_notify_event_t = packed record
    response_type: cuint8;
    pad0: cuint8;
    sequence: cuint16;
    event: xcb_window_t;
    window: xcb_window_t;
    above_sibling: xcb_window_t;
    x: cint16;
    y: cint16;
    width: cuint16;
    height: cuint16;
    border_width: cuint16;
    override_redirect: cuint8;
    pad1: cuint8;
  end;

  xcb_void_cookie_t = packed record
    sequence: cuint;
  end;

  Pxcb_extension_t = ^xcb_extension_t;
  xcb_extension_t = packed record
    name: PChar;
    global_id: cint;
  end;

  Pxcb_auth_info_t = ^xcb_auth_info_t;
  xcb_auth_info_t = packed record
    namelen: cint;
    name: PChar;
    datalen: cint;
    data: PChar;
  end;

  Pxcb_query_extension_reply_t = ^xcb_query_extension_reply_t;
  xcb_query_extension_reply_t = packed record
    response_type: cuint8;
    pad0: cuint8;
    sequence: cuint16;
    length: cuint32;
    present: cuint8;
    major_opcode: cuint8;
    first_event: cuint8;
    first_error: cuint8;
  end;

  Pxcb_client_message_event_t = ^xcb_client_message_event_t;
  xcb_client_message_event_t = packed record
    response_type: cuint8;
    format: cuint8;
    sequence: cuint16;
    window: xcb_window_t;
    _type: xcb_atom_t;
    data: record
      case Integer of
        0: (data8: array[0..19] of cuint8);
        1: (data16: array[0..9] of cuint16);
        2: (data32: array[0..4] of cuint32);
    end;
  end;

  Pxcb_intern_atom_cookie_t = ^xcb_intern_atom_cookie_t;
  xcb_intern_atom_cookie_t = packed record
    sequence: cuint;
  end;

  Pxcb_intern_atom_reply_t = ^xcb_intern_atom_reply_t;
  xcb_intern_atom_reply_t = packed record
    response_type: cuint8;
    pad0: cuint8;
    sequence: cuint16;
    length: cuint32;
    atom: xcb_atom_t;
  end;

  // Типы для событий
  Pxcb_button_press_event_t = ^xcb_button_press_event_t;
  xcb_button_press_event_t = packed record
    response_type: cuint8;
    detail: xcb_button_t;
    sequence: cuint16;
    time: xcb_timestamp_t;
    root: xcb_window_t;
    event: xcb_window_t;
    child: xcb_window_t;
    root_x: cint16;
    root_y: cint16;
    event_x: cint16;
    event_y: cint16;
    state: cuint16;
    same_screen: cuint8;
    pad0: cuint8;
  end;

  Pxcb_key_press_event_t = ^xcb_key_press_event_t;
  xcb_key_press_event_t = packed record
    response_type: cuint8;
    detail: xcb_key_t;
    sequence: cuint16;
    time: xcb_timestamp_t;
    root: xcb_window_t;
    event: xcb_window_t;
    child: xcb_window_t;
    root_x: cint16;
    root_y: cint16;
    event_x: cint16;
    event_y: cint16;
    state: cuint16;
    same_screen: cuint8;
    pad0: cuint8;
  end;

  // Типы для геометрических объектов
  xcb_point_t = packed record
    x, y: cint16;
  end;

  xcb_segment_t = packed record
    x1, y1, x2, y2: cint16;
  end;

  xcb_rectangle_t = packed record
    x, y: cint16;
    width, height: cuint16;
  end;

  xcb_arc_t = packed record
    x, y: cint16;
    width, height: cuint16;
    angle1, angle2: cint16;
  end;

  // Добавлено: структура для выделения цвета
  xcb_alloc_color_cookie_t = packed record
    sequence: cuint;
  end;

  // Добавлено: структура для ответа на выделение цвета
  Pxcb_alloc_color_reply_t = ^xcb_alloc_color_reply_t;
  xcb_alloc_color_reply_t = packed record
    response_type: cuint8;
    pad0: cuint8;
    sequence: cuint16;
    length: cuint32;
    pixel: cuint32;
    red: cuint16;
    green: cuint16;
    blue: cuint16;
    pad1: array[0..1] of cuint8;
  end;

  // Указатели на геометрические объекты
  Pxcb_point_t = ^xcb_point_t;
  Pxcb_segment_t = ^xcb_segment_t;
  Pxcb_rectangle_t = ^xcb_rectangle_t;
  Pxcb_arc_t = ^xcb_arc_t;

  // Типы для событий
  Pxcb_motion_notify_event_t = ^xcb_motion_notify_event_t;
  xcb_motion_notify_event_t = packed record
    response_type: cuint8;
    detail: xcb_button_t;
    sequence: cuint16;
    time: xcb_timestamp_t;
    root: xcb_window_t;
    event: xcb_window_t;
    child: xcb_window_t;
    root_x: cint16;
    root_y: cint16;
    event_x: cint16;
    event_y: cint16;
    state: cuint16;
    same_screen: cuint8;
    pad0: cuint8;
  end;

  Pxcb_button_release_event_t = ^xcb_button_release_event_t;
  xcb_button_release_event_t = packed record
    response_type: cuint8;
    detail: xcb_button_t;
    sequence: cuint16;
    time: xcb_timestamp_t;
    root: xcb_window_t;
    event: xcb_window_t;
    child: xcb_window_t;
    root_x: cint16;
    root_y: cint16;
    event_x: cint16;
    event_y: cint16;
    state: cuint16;
    same_screen: cuint8;
    pad0: cuint8;
  end;

// Константы
const
  // Обновлённые константы
  XCB_CW_BACK_PIXEL = 2;
  XCB_CW_EVENT_MASK = 2048;
  XCB_CW_BORDER_PIXEL = 4;
  XCB_CW_BACK_PIXMAP = 8;
  XCB_GC_FOREGROUND = 1 shl 2; // 00000004
  XCB_GC_BACKGROUND = 1 shl 3; // 00000008
  XCB_GC_GRAPHICS_EXPOSURES = 1 shl 16; // 00010000
  XCB_EVENT_MASK_EXPOSURE = 32768; // 00008000
  XCB_EVENT_MASK_BUTTON_PRESS = 4; // 00000004

  XCB_COPY_FROM_PARENT = 0;
  XCB_WINDOW_CLASS_INPUT_OUTPUT = 1;
  XCB_ATOM_WM_NAME = 39;
  XCB_ATOM_STRING  = 31;

  XCB_GC_FONT = 1 shl 5; // Добавлено: маска для шрифта

  // Константы для масок событий
  XCB_EVENT_MASK_KEY_PRESS = 1;          // Событие нажатия клавиши
  XCB_EVENT_MASK_STRUCTURE_NOTIFY = 131072; // События изменения структуры окна
  XCB_EVENT_MASK_BUTTON_RELEASE = 8;     // Событие отпускания кнопки мыши
  XCB_EVENT_MASK_BUTTON_MOTION = 16;     // Событие движения мыши с нажатой кнопкой
  XCB_EVENT_MASK_ENTER_WINDOW = 32;      // Событие входа курсора в окно
  XCB_EVENT_MASK_LEAVE_WINDOW = 64;      // Событие выхода курсора из окна

  XCB_CONFIGURE_NOTIFY = 22; // Событие изменения конфигурации окна

  // Типы событий
  XCB_EXPOSE = 12;
  XCB_BUTTON_PRESS = 4; // Событие нажатия кнопки мыши
  XCB_KEY_PRESS = 2;    // Событие нажатия клавиши
  XCB_DESTROY_NOTIFY = 17; // Событие закрытия окна
  XCB_CLIENT_MESSAGE = 33; // Событие клиентского сообщения
  XCB_MOTION_NOTIFY = 6;   // Событие движения мыши
  XCB_BUTTON_RELEASE = 5;  // Событие отпускания кнопки мыши

  // Константы для изменения свойств
  XCB_PROP_MODE_REPLACE = 0;
  XCB_ATOM_ATOM = 4;

  // Константы для режимов отрисовки
  XCB_COORD_MODE_ORIGIN = 0;
  XCB_COORD_MODE_PREVIOUS = 1;

  // Константы для захвата клавиш и мыши
  XCB_GRAB_MODE_SYNC = 0;
  XCB_GRAB_MODE_ASYNC = 1;
  XCB_GRAB_ANY = 0;

  // Константы для конфигурации окна
  XCB_CONFIG_WINDOW_X = 1 shl 0;
  XCB_CONFIG_WINDOW_Y = 1 shl 1;

// Функции
function xcb_connect(displayname: PChar; screenp: pcint): Pxcb_connection_t; cdecl; external 'xcb';
function xcb_connection_has_error(c: Pxcb_connection_t): cint; cdecl; external 'xcb';
function xcb_get_setup(c: Pxcb_connection_t): Pxcb_setup_t; cdecl; external 'xcb';
function xcb_setup_roots_iterator(const R: Pxcb_setup_t): xcb_screen_iterator_t; cdecl; external 'xcb';
function xcb_generate_id(c: Pxcb_connection_t): cuint32; cdecl; external 'xcb';
function xcb_create_window(
    c: Pxcb_connection_t;
    depth: cuint8;
    wid: xcb_window_t;
    parent: xcb_window_t;
    x, y: cint16;
    width, height: cuint16;
    border_width: cuint16;
    _class: cuint16;
    visual: xcb_visualid_t;
    value_mask: cuint32;
    value_list: pcuint32
): xcb_void_cookie_t; cdecl; external 'xcb';
function xcb_map_window(c: Pxcb_connection_t; window: xcb_window_t): xcb_void_cookie_t; cdecl; external 'xcb';
function xcb_flush(c: Pxcb_connection_t): cint; cdecl; external 'xcb';
function xcb_wait_for_event(c: Pxcb_connection_t): Pxcb_generic_event_t; cdecl; external 'xcb';
procedure xcb_disconnect(c: Pxcb_connection_t); cdecl; external 'xcb';

function xcb_send_event(
    c: Pxcb_connection_t;
    propagate: cuint8;
    destination: xcb_window_t;
    event_mask: cuint32;
    event: PChar
): xcb_void_cookie_t; cdecl; external 'xcb';

// Функции для работы с графическим контекстом
function xcb_create_gc(
    c: Pxcb_connection_t;
    cid: xcb_gcontext_t;
    window: xcb_window_t;
    value_mask: cuint32;
    value_list: pcuint32
): xcb_void_cookie_t; cdecl; external 'xcb';
procedure xcb_free_gc(c: Pxcb_connection_t; gc: xcb_gcontext_t); cdecl; external 'xcb';

// Добавлено: функция для проверки успешности выполнения запроса
function xcb_request_check(c: Pxcb_connection_t; cookie: xcb_void_cookie_t): Pxcb_generic_error_t; cdecl; external 'xcb';

// Функция для изменения графического контекста
function xcb_change_gc(
    c: Pxcb_connection_t;
    gc: xcb_gcontext_t;
    value_mask: cuint32;
    value_list: pcuint32
): xcb_void_cookie_t; cdecl; external 'xcb';

// Функция для отрисовки текста
procedure xcb_poly_text_8(
    c: Pxcb_connection_t;
    drawable: xcb_drawable_t;
    gc: xcb_gcontext_t;
    x, y: cint16;
    text_len: cuint8;
    text: PChar
); cdecl; external 'xcb';

// Функция для заливки прямоугольника
function xcb_poly_fill_rectangle(
    c: Pxcb_connection_t;
    drawable: xcb_drawable_t;
    gc: xcb_gcontext_t;
    rectangles_len: cuint32;
    rectangles: Pointer
):xcb_void_cookie_t; cdecl; external 'xcb';

// Функция для работы с атомами
function xcb_intern_atom(
    c: Pxcb_connection_t;
    only_if_exists: cuint8;
    name_len: cuint16;
    name: PChar
): xcb_intern_atom_cookie_t; cdecl; external 'xcb';

function xcb_intern_atom_reply(
    c: Pxcb_connection_t;
    cookie: xcb_intern_atom_cookie_t;
    error: Pxcb_generic_error_t
): Pxcb_intern_atom_reply_t; cdecl; external 'xcb';

// Функция для изменения свойств окна
function xcb_change_property(
    c: Pxcb_connection_t;
    mode: cuint8;
    window: xcb_window_t;
    prop: xcb_atom_t; // Переименовано с property на prop
    _type: xcb_atom_t;
    format: cuint8;
    data_len: cuint32;
    data: Pointer
): xcb_void_cookie_t; cdecl; external 'xcb';

// Функции для отрисовки фигур
procedure xcb_poly_point(
    c: Pxcb_connection_t;
    mode: cuint8;
    drawable: xcb_drawable_t;
    gc: xcb_gcontext_t;
    points_len: cuint32;
    points: Pxcb_point_t
); cdecl; external 'xcb';

procedure xcb_poly_line(
    c: Pxcb_connection_t;
    mode: cuint8;
    drawable: xcb_drawable_t;
    gc: xcb_gcontext_t;
    points_len: cuint32;
    points: Pxcb_point_t
); cdecl; external 'xcb';

procedure xcb_poly_segment(
    c: Pxcb_connection_t;
    drawable: xcb_drawable_t;
    gc: xcb_gcontext_t;
    segments_len: cuint32;
    segments: Pxcb_segment_t
); cdecl; external 'xcb';

procedure xcb_poly_rectangle(
    c: Pxcb_connection_t;
    drawable: xcb_drawable_t;
    gc: xcb_gcontext_t;
    rectangles_len: cuint32;
    rectangles: Pxcb_rectangle_t
); cdecl; external 'xcb';

procedure xcb_poly_arc(
    c: Pxcb_connection_t;
    drawable: xcb_drawable_t;
    gc: xcb_gcontext_t;
    arcs_len: cuint32;
    arcs: Pxcb_arc_t
); cdecl; external 'xcb';

// Добавьте это в раздел interface, где объявлены другие функции XCB
function xcb_poly_fill_arc(
    c: Pxcb_connection_t;
    drawable: xcb_drawable_t;
    gc: xcb_gcontext_t;
    arcs_len: cuint32;
    arcs: Pxcb_arc_t
): xcb_void_cookie_t; cdecl; external 'xcb';

// Функции для захвата клавиш и мыши
function xcb_grab_key(
    c: Pxcb_connection_t;
    owner_events: cuint8;
    grab_window: xcb_window_t;
    modifiers: cuint16;
    key: xcb_keycode_t;
    pointer_mode: cuint8;
    keyboard_mode: cuint8
): xcb_void_cookie_t; cdecl; external 'xcb';

function xcb_grab_button(
    c: Pxcb_connection_t;
    owner_events: cuint8;
    grab_window: xcb_window_t;
    event_mask: cuint16;
    pointer_mode: cuint8;
    keyboard_mode: cuint8;
    confine_to: xcb_window_t;
    cursor: xcb_cursor_t;
    button: xcb_button_t;
    modifiers: cuint16
): xcb_void_cookie_t; cdecl; external 'xcb';

// Функции для работы с курсорами
function xcb_create_cursor(
    c: Pxcb_connection_t;
    cid: xcb_cursor_t;
    source: xcb_pixmap_t;
    mask: xcb_pixmap_t;
    fore_red: cuint16;
    fore_green: cuint16;
    fore_blue: cuint16;
    back_red: cuint16;
    back_green: cuint16;
    back_blue: cuint16;
    x: cuint16;
    y: cuint16
): xcb_void_cookie_t; cdecl; external 'xcb';

// Функция для копирования области между drawable
function xcb_copy_area(
    c: Pxcb_connection_t;
    src_drawable: xcb_drawable_t;
    dst_drawable: xcb_drawable_t;
    gc: xcb_gcontext_t;
    src_x, src_y: cint16;
    dst_x, dst_y: cint16;
    width, height: cuint16
): xcb_void_cookie_t; cdecl; external 'xcb';

procedure xcb_free_cursor(
    c: Pxcb_connection_t;
    cursor: xcb_cursor_t
); cdecl; external 'xcb';

// Функции для работы со шрифтами
function xcb_open_font(
    c: Pxcb_connection_t;
    fid: xcb_font_t;
    name_len: cuint16;
    name: PChar
): xcb_void_cookie_t; cdecl; external 'xcb';

procedure xcb_close_font(
    c: Pxcb_connection_t;
    font: xcb_font_t
); cdecl; external 'xcb';

// Добавлено: функция для выделения цвета
function xcb_alloc_color(
    c: Pxcb_connection_t;
    cmap: xcb_colormap_t;
    red: cuint16;
    green: cuint16;
    blue: cuint16
): xcb_alloc_color_cookie_t; cdecl; external 'xcb';

// Добавлено: функция для получения ответа на выделение цвета
function xcb_alloc_color_reply(
    c: Pxcb_connection_t;
    cookie: xcb_alloc_color_cookie_t;
    error: Pxcb_generic_error_t
): Pxcb_alloc_color_reply_t; cdecl; external 'xcb';

function xcb_poll_for_event(Connection: Pxcb_connection_t): Pxcb_generic_event_t; cdecl; external 'xcb';

// Функции для работы с изображениями
procedure xcb_image_text_8(
    c: Pxcb_connection_t;
    drawable: xcb_drawable_t;
    gc: xcb_gcontext_t;
    x, y: cint16;
    text_len: cuint8;
    text: PChar
); cdecl; external 'xcb';

// Функции для работы с pixmap
function xcb_create_pixmap(
    c: Pxcb_connection_t;
    depth: cuint8;
    pid: xcb_pixmap_t;
    drawable: xcb_drawable_t;
    width, height: cuint16
): xcb_void_cookie_t; cdecl; external 'xcb';

// Функции для конфигурации окна
function xcb_configure_window(
    c: Pxcb_connection_t;
    window: xcb_window_t;
    value_mask: cuint16;
    value_list: pcuint32
): xcb_void_cookie_t; cdecl; external 'xcb';

// Основные типы
type
  // Добавлено: структура для создания цветовой карты
  xcb_create_colormap_request_t = packed record
    major_opcode: cuint8;
    alloc: cuint8;
    length: cuint16;
    mid: xcb_colormap_t;
    window: xcb_window_t;
    visual: xcb_visualid_t;
  end;

  // Добавлено: структура для выделения цвета
  xcb_alloc_color_request_t = packed record
    major_opcode: cuint8;
    pad0: cuint8;
    length: cuint16;
    cmap: xcb_colormap_t;
    red: cuint16;
    green: cuint16;
    blue: cuint16;
    pad1: array[0..1] of cuint8;
  end;

  // Остальные типы и структуры...

type
  // Декларация структуры xcb_visualtype_t
  Pxcb_visualtype_t = ^xcb_visualtype_t;
  xcb_visualtype_t = record
    visual_id: cuint32;
    _class: cuint8;
    bits_per_rgb_value: cuint8;
    colormap_entries: cuint16;
    red_mask: cuint32;
    green_mask: cuint32;
    blue_mask: cuint32;
    pad0: array[0..7] of cuint8; // Выравнивание
  end;

  // Декларация итератора для xcb_visualtype_t
  xcb_visualtype_iterator_t = record
    data: Pxcb_visualtype_t;
    rem: cint;
    index: cint;
  end;

  // Декларация структуры xcb_depth_t
  Pxcb_depth_t = ^xcb_depth_t;
  xcb_depth_t = record
    depth: cuint8;
    pad0: cuint8;
    visuals_len: cuint16;
    pad1: array[0..3] of cuint8; // Выравнивание
  end;

  // Декларация итератора для xcb_depth_t
  xcb_depth_iterator_t = record
    data: Pxcb_depth_t;
    rem: cint;
    index: cint;
  end;

  // Декларация констант
const
  XCB_VISUAL_CLASS_TRUE_COLOR = 4;

// Константы
const
  // Добавлено: константа для создания цветовой карты
XCB_COLORMAP_ALLOC_NONE = 0;
XCB_COLORMAP_ALLOC_ALL  = $01;

  // Остальные константы...

// Функции

// Добавлено: функция для создания цветовой карты
function xcb_create_colormap(
    c: Pxcb_connection_t;
    alloc: cuint8;
    mid: xcb_colormap_t;
    window: xcb_window_t;
    visual: xcb_visualid_t
): xcb_void_cookie_t; cdecl; external 'xcb';

// Добавлено: функция для получения ответа на выделение цвета
function xcb_alloc_color_reply(
    c: Pxcb_connection_t;
    cookie: xcb_void_cookie_t;
    error: Pxcb_generic_error_t
): Pxcb_alloc_color_reply_t; cdecl; external 'xcb';

type
Pxcb_visualtype_iterator_t = ^xcb_visualtype_iterator_t;
Pxcb_depth_iterator_t = ^xcb_depth_iterator_t;

function xcb_screen_allowed_depths_iterator(screen: Pxcb_screen_t): xcb_depth_iterator_t; cdecl; external 'xcb';
function xcb_depth_visuals_iterator(depth: Pxcb_depth_t): xcb_visualtype_iterator_t; cdecl; external 'xcb';
procedure xcb_visualtype_next(iterator: Pxcb_visualtype_iterator_t); cdecl; external 'xcb';
procedure xcb_depth_next(iterator: Pxcb_depth_iterator_t); cdecl; external 'xcb';

implementation
end.