program test_connection;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.
                              
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$mode objfpc}{$H+}

uses
  xcb_bindings, BaseUnix, SysUtils;

var
  conn: Pxcb_connection_t;
  screen: cint = 0;
  setup: Pxcb_setup_t;
  fd: cint;
  has_error: cint;
  i: integer;
  xid: uint32_t;

begin
  WriteLn('Testing XCB connection...');
  
  // Connect to X server
  conn := xcb_connect(nil, @screen);
  
  if conn = nil then
  begin
    WriteLn('Failed to connect to X server');
    Halt(1);
  end;
  
  // Check connection error
  has_error := xcb_connection_has_error(conn);
  if has_error <> 0 then
  begin
    WriteLn('Connection error: ', has_error);
    xcb_disconnect(conn);
    Halt(1);
  end;
  
  WriteLn('Successfully connected to X server');
  
  // Get setup information
  setup := xcb_get_setup(conn);
  if setup <> nil then
  begin
    WriteLn('X server protocol version: ', setup^.protocol_major_version, '.', setup^.protocol_minor_version);
    WriteLn('Release number: ', setup^.release_number);
    WriteLn('Screen count: ', setup^.roots_len);
    WriteLn('Maximum request length: ', setup^.maximum_request_length);
    WriteLn('Resource ID base: ', setup^.resource_id_base);
    WriteLn('Resource ID mask: ', setup^.resource_id_mask);
    WriteLn('Min keycode: ', setup^.min_keycode);
    WriteLn('Max keycode: ', setup^.max_keycode);
  end;
  
  // Get file descriptor
  fd := xcb_get_file_descriptor(conn);
  WriteLn('File descriptor: ', fd);
  
  // Test XID generation
  WriteLn('Testing XID generation...');
  for i := 1 to 5 do
  begin
    xid := xcb_generate_id(conn);
    if xid <> uint32_t(-1) then
      WriteLn('  Generated XID ', i, ': ', xid)
    else
      WriteLn('  Failed to generate XID ', i);
  end;
  
  // Test flush
  WriteLn('Testing flush...');
  if xcb_flush(conn) > 0 then
    WriteLn('  Flush successful')
  else
    WriteLn('  Flush failed');
  
  // Test maximum request length
  WriteLn('Testing maximum request length...');
  xcb_prefetch_maximum_request_length(conn);
  WriteLn('  Prefetch completed');
  WriteLn('  Maximum request length: ', xcb_get_maximum_request_length(conn));
  
  // Test statistics
  WriteLn('Connection statistics:');
  WriteLn('  Total bytes read: ', xcb_total_read(conn));
  WriteLn('  Total bytes written: ', xcb_total_written(conn));
  
  // Test extension prefetch (basic test)
  WriteLn('Testing extension prefetch...');
  // Note: We don't have specific extensions loaded, but we can test the function call
  // xcb_prefetch_extension_data(conn, some_extension);
  WriteLn('  Extension prefetch test completed');
  
  // Cleanup
  WriteLn('Cleaning up...');
  xcb_disconnect(conn);
  WriteLn('Disconnected from X server');
  WriteLn('All tests completed successfully!');
end.