program test_events;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.
                              
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$mode objfpc}{$H+}

uses
  xcb_bindings, BaseUnix, SysUtils;

var
  conn: Pxcb_connection_t;
  event: Pxcb_generic_event_t;
  has_error: cint;
  event_count: integer = 0;
  start_time: QWord;

begin
  WriteLn('Testing XCB event handling...');
  
  // Connect to X server
  conn := xcb_connect(nil, nil);
  
  if conn = nil then
  begin
    WriteLn('Failed to connect to X server');
    Halt(1);
  end;
  
  has_error := xcb_connection_has_error(conn);
  if has_error <> 0 then
  begin
    WriteLn('Connection error: ', has_error);
    xcb_disconnect(conn);
    Halt(1);
  end;
  
  WriteLn('Connected to X server');
  WriteLn('Listening for events for 10 seconds...');
  WriteLn('Move mouse, press keys, or focus/unfocus windows to generate events...');
  
  // Flush to make sure our connection is ready
  xcb_flush(conn);
  
  start_time := GetTickCount64;
  
  while (GetTickCount64 - start_time) < 10000 do // Run for 10 seconds
  begin
    // Try to poll for events first (non-blocking)
    event := xcb_poll_for_event(conn);
    
    if event <> nil then
    begin
      Inc(event_count);
      Write('Event #', event_count, ': Type=', event^.response_type and $7F);
      
      // Определяем тип события
      case (event^.response_type and $7F) of
        0: Write(' (Error)');
        1: Write(' (Reply)');
        2: Write(' (KeyPress)');
        3: Write(' (KeyRelease)');
        4: Write(' (ButtonPress)');
        5: Write(' (ButtonRelease)');
        6: Write(' (MotionNotify)');
        7: Write(' (EnterNotify)');
        8: Write(' (LeaveNotify)');
        9: Write(' (FocusIn)');
        10: Write(' (FocusOut)');
        11: Write(' (KeymapNotify)');
        12: Write(' (Expose)');
        18: Write(' (ConfigureNotify)');
        19: Write(' (PropertyNotify)');
        22: Write(' (ClientMessage)');
        33: Write(' (MappingNotify)');
        else Write(' (Other)');
      end;
      
      WriteLn(' Sequence=', event^.sequence);
      
      // Free the event
      FreeMem(event);
    end
    else
    begin
      // No events available, wait a bit
      Sleep(10);
    end;
  end;
  
  WriteLn('Processed ', event_count, ' events in 10 seconds');
  
  // Test queued events
  event := xcb_poll_for_queued_event(conn);
  if event <> nil then
  begin
    WriteLn('Found queued event after timeout');
    FreeMem(event);
  end;
  
  xcb_disconnect(conn);
  WriteLn('Disconnected from X server');
end.