program test_final_comprehensive;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.
                              
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$mode objfpc}{$H+}

uses
  xcb_bindings, xcb_ext_bindings, xproto_bindings, SysUtils;

var
  conn: Pxcb_connection_t;

procedure Test(title: string; condition: Boolean);
begin
  Write('• ', title, ': ');
  if condition then
    WriteLn('✅ PASS')
  else
    WriteLn('❌ FAIL');
end;

begin
  WriteLn('XCB Comprehensive Final Test');
  WriteLn('============================');
  WriteLn;
  
  // Test 1: Connection
  WriteLn('1. Connection Tests');
  WriteLn('-------------------');
  conn := xcb_connect(nil, nil);
  Test('Connect to X server', conn <> nil);
  
  if conn <> nil then
  begin
    Test('Connection has no error', xcb_connection_has_error(conn) = 0);
    Test('Get file descriptor', xcb_get_file_descriptor(conn) > 0);
    
    // Test 2: Setup information
    WriteLn;
    WriteLn('2. Setup Information Tests');
    WriteLn('--------------------------');
    Test('Get setup data', xcb_get_setup(conn) <> nil);
    
    if xcb_get_setup(conn) <> nil then
    begin
      with xcb_get_setup(conn)^ do
      begin
        Test('Protocol version valid', (protocol_major_version > 0) and (protocol_minor_version >= 0));
        Test('Has screens', roots_len > 0);
      end;
    end;
    
    // Test 3: XID generation
    WriteLn;
    WriteLn('3. XID Generation Tests');
    WriteLn('-----------------------');
    Test('Generate XID', xcb_generate_id(conn) <> uint32_t(-1));
    
    // Test 4: I/O operations
    WriteLn;
    WriteLn('4. I/O Operation Tests');
    WriteLn('----------------------');
    Test('Flush connection', xcb_flush(conn) > 0);
    Test('Get maximum request length', xcb_get_maximum_request_length(conn) > 0);
    
    // Test 5: Utility functions
    WriteLn;
    WriteLn('5. Utility Function Tests');
    WriteLn('-------------------------');
    Test('Popcount function', xcb_popcount($F0F0F0F0) = 16);
    Test('Get read/write statistics', 
         (xcb_total_read(conn) >= 0) and (xcb_total_written(conn) >= 0));
    
    // Test 6: Cleanup
    WriteLn;
    WriteLn('6. Cleanup Tests');
    WriteLn('----------------');
    xcb_disconnect(conn);
    Test('Disconnect from X server', True);
  end;
  
  WriteLn;
  WriteLn('================================');
  WriteLn('All basic XCB functions work!');
  WriteLn('Pascal bindings are ready for use.');
  WriteLn('================================');
end.