program test_utils;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.
                              
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$mode objfpc}{$H+}

uses
  ctypes,xcb_bindings, xcb_ext_bindings, SysUtils;

var
  host: PChar;
  display: cint;
  screen: cint;
  ret: cint;
  popcount_result: cint;
  sum_result: cint;
  test_array: array[0..4] of uint8_t = (1, 2, 3, 4, 5);

begin
  WriteLn('Testing XCB utility functions...');
  
  // Test display parsing
  WriteLn('Testing display parsing...');
  host := nil;
  display := 0;
  screen := 0;
  
  ret := xcb_parse_display(nil, @host, @display, @screen);
  
  if ret <> 0 then
  begin
    WriteLn('Display parsing successful:');
    if host <> nil then
    begin
      WriteLn('  Host: ', host);
      // Не освобождаем память, так как xcb_parse_display использует внутреннее управление
      // или передает указатель на статическую память
    end
    else
      WriteLn('  Host: (nil)');
    WriteLn('  Display: ', display);
    WriteLn('  Screen: ', screen);
  end
  else
  begin
    WriteLn('Display parsing failed');
  end;
  
  // Test popcount
  popcount_result := xcb_popcount($F0F0F0F0);
  WriteLn('Popcount of $F0F0F0F0: ', popcount_result);
  
  // Test sumof
  sum_result := xcb_sumof(@test_array[0], 5);
  WriteLn('Sum of [1,2,3,4,5]: ', sum_result);
  
  WriteLn('Utility function tests completed');
end.