unit xcb_bindings;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.
                              
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$mode objfpc}{$H+}
{$PACKRECORDS C}

interface

uses
  CTypes, BaseUnix, xcb_const;

//const
//  libxcb = 'libxcb.so.1';

type
  // Basic types
  uint8_t = cuint8;
  uint16_t = cuint16;
  uint32_t = cuint32;
  uint64_t = cuint64;
  int = cint;
  size_t = csize_t;
  
  // Opaque structures
  Pxcb_connection_t = ^xcb_connection_t;
  xcb_connection_t = record end;
  
  Pxcb_special_event_t = ^xcb_special_event_t;
  xcb_special_event_t = record end;
  
  Pxcb_extension_t = ^xcb_extension_t;
  xcb_extension_t = record
    name: PChar;
    global_id: cint;
  end;

  // Generic structures
  Pxcb_generic_iterator_t = ^xcb_generic_iterator_t;
  xcb_generic_iterator_t = record
    data: Pointer;
    rem: cint;
    index: cint;
  end;

  Pxcb_generic_reply_t = ^xcb_generic_reply_t;
  xcb_generic_reply_t = record
    response_type: uint8_t;
    pad0: uint8_t;
    sequence: uint16_t;
    length: uint32_t;
  end;

  Pxcb_generic_event_t = ^xcb_generic_event_t;
  PPxcb_generic_event_t = ^Pxcb_generic_event_t;
  xcb_generic_event_t = record
    response_type: uint8_t;
    pad0: uint8_t;
    sequence: uint16_t;
    pad: array[0..6] of uint32_t;
    full_sequence: uint32_t;
  end;

  Pxcb_generic_error_t = ^xcb_generic_error_t;
  xcb_generic_error_t = record
    response_type: uint8_t;
    error_code: uint8_t;
    sequence: uint16_t;
    resource_id: uint32_t;
    minor_code: uint16_t;
    major_code: uint8_t;
    pad0: uint8_t;
    pad: array[0..4] of uint32_t;
    full_sequence: uint32_t;
  end;

  Pxcb_void_cookie_t = ^xcb_void_cookie_t;
  xcb_void_cookie_t = record
    sequence: cuint;
  end;

  // Auth structure
  Pxcb_auth_info_t = ^xcb_auth_info_t;
  xcb_auth_info_t = record
    namelen: cint;
    name: PChar;
    datalen: cint;
    data: PChar;
  end;

  // Setup structure
  Pxcb_setup_t = ^xcb_setup_t;
  xcb_setup_t = record
    status: uint8_t;
    pad0: uint8_t;
    protocol_major_version: uint16_t;
    protocol_minor_version: uint16_t;
    length: uint16_t;
    release_number: uint32_t;
    resource_id_base: uint32_t;
    resource_id_mask: uint32_t;
    motion_buffer_size: uint32_t;
    vendor_len: uint16_t;
    maximum_request_length: uint16_t;
    roots_len: uint16_t;
    pixmap_formats_len: uint16_t;
    image_byte_order: uint8_t;
    bitmap_format_bit_order: uint8_t;
    bitmap_format_scanline_unit: uint8_t;
    bitmap_format_scanline_pad: uint8_t;
    min_keycode: uint8_t;
    max_keycode: uint8_t;
    pad1: array[0..3] of uint8_t;
  end;

  // Pointer types for function parameters
  PPxcb_generic_error_t = ^Pxcb_generic_error_t;
  Puint32_t = ^uint32_t;

  // Geometry functions
  Pxcb_get_geometry_cookie_t = ^xcb_get_geometry_cookie_t;
  xcb_get_geometry_cookie_t = record
    sequence: cuint;
  end;

  Pxcb_get_geometry_reply_t = ^xcb_get_geometry_reply_t;
  xcb_get_geometry_reply_t = record
    response_type: cuint8;
    depth: cuint8;
    sequence: cuint16;
    length: cuint32;
    root: cuint32;
    x: cint16;
    y: cint16;
    width: cuint16;
    height: cuint16;
    border_width: cuint16;
    pad0: array[0..1] of cuint8;
  end;

{
const
  XCB_NONE = 0;
  XCB_COPY_FROM_PARENT = 0;
  XCB_CURRENT_TIME = 0;
  XCB_NO_SYMBOL = 0;

  // Connection errors
  XCB_CONN_ERROR = 1;
  XCB_CONN_CLOSED_EXT_NOTSUPPORTED = 2;
  XCB_CONN_CLOSED_MEM_INSUFFICIENT = 3;
  XCB_CONN_CLOSED_REQ_LEN_EXCEED = 4;
  XCB_CONN_CLOSED_PARSE_ERR = 5;
  XCB_CONN_CLOSED_INVALID_SCREEN = 6;
  XCB_CONN_CLOSED_FDPASSING_FAILED = 7;

  // Event types
  XCB_EXPOSE = 12;
  XCB_BUTTON_PRESS = 4;
  XCB_BUTTON_RELEASE = 5;
  XCB_MOTION_NOTIFY = 6;
  XCB_ENTER_NOTIFY = 7;
  XCB_LEAVE_NOTIFY = 8;
  XCB_KEY_PRESS = 2;
  XCB_KEY_RELEASE = 3;

  // Window creation masks
  XCB_CW_BACK_PIXEL = 1 shl 0;
  XCB_CW_BORDER_PIXEL = 1 shl 1;
  XCB_CW_BIT_GRAVITY = 1 shl 2;
  XCB_CW_WIN_GRAVITY = 1 shl 3;
  XCB_CW_BACKING_STORE = 1 shl 4;
  XCB_CW_BACKING_PLANES = 1 shl 5;
  XCB_CW_BACKING_PIXEL = 1 shl 6;
  XCB_CW_OVERRIDE_REDIRECT = 1 shl 7;
  XCB_CW_SAVE_UNDER = 1 shl 8;
  XCB_CW_EVENT_MASK = 1 shl 9;
  XCB_CW_DONT_PROPAGATE = 1 shl 10;
  XCB_CW_COLORMAP = 1 shl 11;
  XCB_CW_CURSOR = 1 shl 12;
}

// Core connection functions
function xcb_connect(displayname: PChar; screenp: Pcint): Pxcb_connection_t; cdecl; external libxcb;
function xcb_connect_to_fd(fd: cint; auth_info: Pxcb_auth_info_t): Pxcb_connection_t; cdecl; external libxcb;
procedure xcb_disconnect(c: Pxcb_connection_t); cdecl; external libxcb;
function xcb_connection_has_error(c: Pxcb_connection_t): cint; cdecl; external libxcb;

// Setup and file descriptor
function xcb_get_setup(c: Pxcb_connection_t): Pxcb_setup_t; cdecl; external libxcb;
function xcb_get_file_descriptor(c: Pxcb_connection_t): cint; cdecl; external libxcb;

// Event handling
function xcb_wait_for_event(c: Pxcb_connection_t): Pxcb_generic_event_t; cdecl; external libxcb;
function xcb_poll_for_event(c: Pxcb_connection_t): Pxcb_generic_event_t; cdecl; external libxcb;
function xcb_poll_for_queued_event(c: Pxcb_connection_t): Pxcb_generic_event_t; cdecl; external libxcb;

// Special events
function xcb_poll_for_special_event(c: Pxcb_connection_t; se: Pxcb_special_event_t): Pxcb_generic_event_t; cdecl; external libxcb;
function xcb_wait_for_special_event(c: Pxcb_connection_t; se: Pxcb_special_event_t): Pxcb_generic_event_t; cdecl; external libxcb;
function xcb_register_for_special_xge(c: Pxcb_connection_t; ext: Pxcb_extension_t; eid: uint32_t; stamp: Puint32_t): Pxcb_special_event_t; cdecl; external libxcb;
procedure xcb_unregister_for_special_event(c: Pxcb_connection_t; se: Pxcb_special_event_t); cdecl; external libxcb;

// Request handling
function xcb_request_check(c: Pxcb_connection_t; cookie: xcb_void_cookie_t): PPxcb_generic_error_t; cdecl; external libxcb;
procedure xcb_discard_reply(c: Pxcb_connection_t; sequence: cuint); cdecl; external libxcb;
procedure xcb_discard_reply64(c: Pxcb_connection_t; sequence: uint64_t); cdecl; external libxcb;

// Extension handling
function xcb_get_extension_data(c: Pxcb_connection_t; ext: Pxcb_extension_t): Pointer; cdecl; external libxcb;
procedure xcb_prefetch_extension_data(c: Pxcb_connection_t; ext: Pxcb_extension_t); cdecl; external libxcb;

// I/O operations
function xcb_flush(c: Pxcb_connection_t): cint; cdecl; external libxcb;
function xcb_get_maximum_request_length(c: Pxcb_connection_t): uint32_t; cdecl; external libxcb;
procedure xcb_prefetch_maximum_request_length(c: Pxcb_connection_t); cdecl; external libxcb;

// XID generation
function xcb_generate_id(c: Pxcb_connection_t): uint32_t; cdecl; external libxcb;

// Utility functions
function xcb_parse_display(name: PChar; host: PPChar; display: Pcint; screen: Pcint): cint; cdecl; external libxcb;

// Reply functions
function xcb_wait_for_reply(c: Pxcb_connection_t; request: cuint; e: PPxcb_generic_error_t): Pointer; cdecl; external libxcb;
function xcb_wait_for_reply64(c: Pxcb_connection_t; request: uint64_t; e: PPxcb_generic_error_t): Pointer; cdecl; external libxcb;
function xcb_poll_for_reply(c: Pxcb_connection_t; request: cuint; reply: PPointer; error: PPxcb_generic_error_t): cint; cdecl; external libxcb;
function xcb_poll_for_reply64(c: Pxcb_connection_t; request: uint64_t; reply: PPointer; error: PPxcb_generic_error_t): cint; cdecl; external libxcb;

// Statistics
function xcb_total_read(c: Pxcb_connection_t): uint64_t; cdecl; external libxcb;
function xcb_total_written(c: Pxcb_connection_t): uint64_t; cdecl; external libxcb;

procedure cfree(event: Pointer); cdecl; external 'c' name 'free'; // Use standard C free

// GEOMETRY FUNCTIONS
function xcb_get_geometry(conn: Pxcb_connection_t; drawable: cuint32): xcb_get_geometry_cookie_t; cdecl; external libxcb;
function xcb_get_geometry_reply(conn: Pxcb_connection_t; cookie: xcb_get_geometry_cookie_t; error: PPxcb_generic_error_t): Pxcb_get_geometry_reply_t; cdecl; external libxcb;

implementation

end.