unit xcb_const;

{
    XCB Bindings.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026  Artyomov Alexander
    http://self-made-free.ru/
    Used https://chat.deepseek.com/, https://chatgpt.com/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.
                              
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}

interface

const
libxcb = 'libxcb.so.1';
// @defgroup XCB_BigRequests_API XCB BigRequests API
XCB_BIGREQUESTS_MAJOR_VERSION=0;
XCB_BIGREQUESTS_MINOR_VERSION=0;
XCB_BIG_REQUESTS_ENABLE=0;
// @defgroup XCB_Composite_API XCB Composite API
XCB_COMPOSITE_MAJOR_VERSION=0;
XCB_COMPOSITE_MINOR_VERSION=4;
XCB_COMPOSITE_REDIRECT_AUTOMATIC=0;
XCB_COMPOSITE_REDIRECT_MANUAL=1;
XCB_COMPOSITE_QUERY_VERSION=0;
XCB_COMPOSITE_REDIRECT_WINDOW=1;
XCB_COMPOSITE_REDIRECT_SUBWINDOWS=2;
XCB_COMPOSITE_UNREDIRECT_WINDOW=3;
XCB_COMPOSITE_UNREDIRECT_SUBWINDOWS=4;
XCB_COMPOSITE_CREATE_REGION_FROM_BORDER_CLIP=5;
XCB_COMPOSITE_NAME_WINDOW_PIXMAP=6;
XCB_COMPOSITE_GET_OVERLAY_WINDOW=7;
XCB_COMPOSITE_RELEASE_OVERLAY_WINDOW=8;
// @defgroup XCB_Damage_API XCB Damage API
XCB_DAMAGE_MAJOR_VERSION=1;
XCB_DAMAGE_MINOR_VERSION=1;
XCB_DAMAGE_REPORT_LEVEL_RAW_RECTANGLES=0;
XCB_DAMAGE_REPORT_LEVEL_DELTA_RECTANGLES=1;
XCB_DAMAGE_REPORT_LEVEL_BOUNDING_BOX=2;
XCB_DAMAGE_REPORT_LEVEL_NON_EMPTY=3;
XCB_DAMAGE_BAD_DAMAGE=0;
XCB_DAMAGE_QUERY_VERSION=0;
XCB_DAMAGE_CREATE=1;
XCB_DAMAGE_DESTROY=2;
XCB_DAMAGE_SUBTRACT=3;
XCB_DAMAGE_ADD=4;
XCB_DAMAGE_NOTIFY=0;
// @defgroup XCB_DPMS_API XCB DPMS API
XCB_DPMS_MAJOR_VERSION=1;
XCB_DPMS_MINOR_VERSION=2;
XCB_DPMS_GET_VERSION=0;
XCB_DPMS_CAPABLE=1;
XCB_DPMS_GET_TIMEOUTS=2;
XCB_DPMS_SET_TIMEOUTS=3;
XCB_DPMS_ENABLE=4;
XCB_DPMS_DISABLE=5;
XCB_DPMS_DPMS_MODE_ON=0;
XCB_DPMS_DPMS_MODE_STANDBY=1;
XCB_DPMS_DPMS_MODE_SUSPEND=2;
XCB_DPMS_DPMS_MODE_OFF=3;
XCB_DPMS_FORCE_LEVEL=6;
XCB_DPMS_INFO=7;
XCB_DPMS_EVENT_MASK_INFO_NOTIFY=1;
XCB_DPMS_SELECT_INPUT=8;
XCB_DPMS_INFO_NOTIFY=0;
// @defgroup XCB_DRI2_API XCB DRI2 API
XCB_DRI2_MAJOR_VERSION=1;
XCB_DRI2_MINOR_VERSION=4;
XCB_DRI2_ATTACHMENT_BUFFER_FRONT_LEFT=0;
XCB_DRI2_ATTACHMENT_BUFFER_BACK_LEFT=1;
XCB_DRI2_ATTACHMENT_BUFFER_FRONT_RIGHT=2;
XCB_DRI2_ATTACHMENT_BUFFER_BACK_RIGHT=3;
XCB_DRI2_ATTACHMENT_BUFFER_DEPTH=4;
XCB_DRI2_ATTACHMENT_BUFFER_STENCIL=5;
XCB_DRI2_ATTACHMENT_BUFFER_ACCUM=6;
XCB_DRI2_ATTACHMENT_BUFFER_FAKE_FRONT_LEFT=7;
XCB_DRI2_ATTACHMENT_BUFFER_FAKE_FRONT_RIGHT=8;
XCB_DRI2_ATTACHMENT_BUFFER_DEPTH_STENCIL=9;
XCB_DRI2_ATTACHMENT_BUFFER_HIZ=10;
XCB_DRI2_DRIVER_TYPE_DRI=0;
XCB_DRI2_DRIVER_TYPE_VDPAU=1;
XCB_DRI2_EVENT_TYPE_EXCHANGE_COMPLETE=1;
XCB_DRI2_EVENT_TYPE_BLIT_COMPLETE=2;
XCB_DRI2_EVENT_TYPE_FLIP_COMPLETE=3;
XCB_DRI2_QUERY_VERSION=0;
XCB_DRI2_CONNECT=1;
XCB_DRI2_AUTHENTICATE=2;
XCB_DRI2_CREATE_DRAWABLE=3;
XCB_DRI2_DESTROY_DRAWABLE=4;
XCB_DRI2_GET_BUFFERS=5;
XCB_DRI2_COPY_REGION=6;
XCB_DRI2_GET_BUFFERS_WITH_FORMAT=7;
XCB_DRI2_SWAP_BUFFERS=8;
XCB_DRI2_GET_MSC=9;
XCB_DRI2_WAIT_MSC=10;
XCB_DRI2_WAIT_SBC=11;
XCB_DRI2_SWAP_INTERVAL=12;
XCB_DRI2_GET_PARAM=13;
XCB_DRI2_BUFFER_SWAP_COMPLETE=0;
XCB_DRI2_INVALIDATE_BUFFERS=1;
// @defgroup XCB_DRI3_API XCB DRI3 API
XCB_DRI3_MAJOR_VERSION=1;
XCB_DRI3_MINOR_VERSION=4;
XCB_DRI3_QUERY_VERSION=0;
XCB_DRI3_OPEN=1;
XCB_DRI3_PIXMAP_FROM_BUFFER=2;
XCB_DRI3_BUFFER_FROM_PIXMAP=3;
XCB_DRI3_FENCE_FROM_FD=4;
XCB_DRI3_FD_FROM_FENCE=5;
XCB_DRI3_GET_SUPPORTED_MODIFIERS=6;
XCB_DRI3_PIXMAP_FROM_BUFFERS=7;
XCB_DRI3_BUFFERS_FROM_PIXMAP=8;
XCB_DRI3_SET_DRM_DEVICE_IN_USE=9;
XCB_DRI3_IMPORT_SYNCOBJ=10;
XCB_DRI3_FREE_SYNCOBJ=11;
// @defgroup XCB_Glx_API XCB Glx API
XCB_GLX_MAJOR_VERSION=1;
XCB_GLX_MINOR_VERSION=4;
XCB_GLX_GENERIC=-1;
XCB_GLX_BAD_CONTEXT=0;
XCB_GLX_BAD_CONTEXT_STATE=1;
XCB_GLX_BAD_DRAWABLE=2;
XCB_GLX_BAD_PIXMAP=3;
XCB_GLX_BAD_CONTEXT_TAG=4;
XCB_GLX_BAD_CURRENT_WINDOW=5;
XCB_GLX_BAD_RENDER_REQUEST=6;
XCB_GLX_BAD_LARGE_REQUEST=7;
XCB_GLX_UNSUPPORTED_PRIVATE_REQUEST=8;
XCB_GLX_BAD_FB_CONFIG=9;
XCB_GLX_BAD_PBUFFER=10;
XCB_GLX_BAD_CURRENT_DRAWABLE=11;
XCB_GLX_BAD_WINDOW=12;
XCB_GLX_GLX_BAD_PROFILE_ARB=13;
XCB_GLX_PBUFFER_CLOBBER=0;
XCB_GLX_BUFFER_SWAP_COMPLETE=1;
XCB_GLX_PBCET_DAMAGED=32791;
XCB_GLX_PBCET_SAVED=32792;
XCB_GLX_PBCDT_WINDOW=32793;
XCB_GLX_PBCDT_PBUFFER=32794;
XCB_GLX_RENDER=1;
XCB_GLX_RENDER_LARGE=2;
XCB_GLX_CREATE_CONTEXT=3;
XCB_GLX_DESTROY_CONTEXT=4;
XCB_GLX_MAKE_CURRENT=5;
XCB_GLX_IS_DIRECT=6;
XCB_GLX_QUERY_VERSION=7;
XCB_GLX_WAIT_GL=8;
XCB_GLX_WAIT_X=9;
XCB_GLX_COPY_CONTEXT=10;
XCB_GLX_GC_GL_CURRENT_BIT=1;
XCB_GLX_GC_GL_POINT_BIT=2;
XCB_GLX_GC_GL_LINE_BIT=4;
XCB_GLX_GC_GL_POLYGON_BIT=8;
XCB_GLX_GC_GL_POLYGON_STIPPLE_BIT=16;
XCB_GLX_GC_GL_PIXEL_MODE_BIT=32;
XCB_GLX_GC_GL_LIGHTING_BIT=64;
XCB_GLX_GC_GL_FOG_BIT=128;
XCB_GLX_GC_GL_DEPTH_BUFFER_BIT=256;
XCB_GLX_GC_GL_ACCUM_BUFFER_BIT=512;
XCB_GLX_GC_GL_STENCIL_BUFFER_BIT=1024;
XCB_GLX_GC_GL_VIEWPORT_BIT=2048;
XCB_GLX_GC_GL_TRANSFORM_BIT=4096;
XCB_GLX_GC_GL_ENABLE_BIT=8192;
XCB_GLX_GC_GL_COLOR_BUFFER_BIT=16384;
XCB_GLX_GC_GL_HINT_BIT=32768;
XCB_GLX_GC_GL_EVAL_BIT=65536;
XCB_GLX_GC_GL_LIST_BIT=131072;
XCB_GLX_GC_GL_TEXTURE_BIT=262144;
XCB_GLX_GC_GL_SCISSOR_BIT=524288;
XCB_GLX_GC_GL_ALL_ATTRIB_BITS=16777215;
XCB_GLX_SWAP_BUFFERS=11;
XCB_GLX_USE_X_FONT=12;
XCB_GLX_CREATE_GLX_PIXMAP=13;
XCB_GLX_GET_VISUAL_CONFIGS=14;
XCB_GLX_DESTROY_GLX_PIXMAP=15;
XCB_GLX_VENDOR_PRIVATE=16;
XCB_GLX_VENDOR_PRIVATE_WITH_REPLY=17;
XCB_GLX_QUERY_EXTENSIONS_STRING=18;
XCB_GLX_QUERY_SERVER_STRING=19;
XCB_GLX_CLIENT_INFO=20;
XCB_GLX_GET_FB_CONFIGS=21;
XCB_GLX_CREATE_PIXMAP=22;
XCB_GLX_DESTROY_PIXMAP=23;
XCB_GLX_CREATE_NEW_CONTEXT=24;
XCB_GLX_QUERY_CONTEXT=25;
XCB_GLX_MAKE_CONTEXT_CURRENT=26;
XCB_GLX_CREATE_PBUFFER=27;
XCB_GLX_DESTROY_PBUFFER=28;
XCB_GLX_GET_DRAWABLE_ATTRIBUTES=29;
XCB_GLX_CHANGE_DRAWABLE_ATTRIBUTES=30;
XCB_GLX_CREATE_WINDOW=31;
XCB_GLX_DELETE_WINDOW=32;
XCB_GLX_SET_CLIENT_INFO_ARB=33;
XCB_GLX_CREATE_CONTEXT_ATTRIBS_ARB=34;
XCB_GLX_SET_CLIENT_INFO_2ARB=35;
XCB_GLX_NEW_LIST=101;
XCB_GLX_END_LIST=102;
XCB_GLX_DELETE_LISTS=103;
XCB_GLX_GEN_LISTS=104;
XCB_GLX_FEEDBACK_BUFFER=105;
XCB_GLX_SELECT_BUFFER=106;
XCB_GLX_RENDER_MODE=107;
XCB_GLX_RM_GL_RENDER=7168;
XCB_GLX_RM_GL_FEEDBACK=7169;
XCB_GLX_RM_GL_SELECT=7170;
XCB_GLX_FINISH=108;
XCB_GLX_PIXEL_STOREF=109;
XCB_GLX_PIXEL_STOREI=110;
XCB_GLX_READ_PIXELS=111;
XCB_GLX_GET_BOOLEANV=112;
XCB_GLX_GET_CLIP_PLANE=113;
XCB_GLX_GET_DOUBLEV=114;
XCB_GLX_GET_ERROR=115;
XCB_GLX_GET_FLOATV=116;
XCB_GLX_GET_INTEGERV=117;
XCB_GLX_GET_LIGHTFV=118;
XCB_GLX_GET_LIGHTIV=119;
XCB_GLX_GET_MAPDV=120;
XCB_GLX_GET_MAPFV=121;
XCB_GLX_GET_MAPIV=122;
XCB_GLX_GET_MATERIALFV=123;
XCB_GLX_GET_MATERIALIV=124;
XCB_GLX_GET_PIXEL_MAPFV=125;
XCB_GLX_GET_PIXEL_MAPUIV=126;
XCB_GLX_GET_PIXEL_MAPUSV=127;
XCB_GLX_GET_POLYGON_STIPPLE=128;
XCB_GLX_GET_STRING=129;
XCB_GLX_GET_TEX_ENVFV=130;
XCB_GLX_GET_TEX_ENVIV=131;
XCB_GLX_GET_TEX_GENDV=132;
XCB_GLX_GET_TEX_GENFV=133;
XCB_GLX_GET_TEX_GENIV=134;
XCB_GLX_GET_TEX_IMAGE=135;
XCB_GLX_GET_TEX_PARAMETERFV=136;
XCB_GLX_GET_TEX_PARAMETERIV=137;
XCB_GLX_GET_TEX_LEVEL_PARAMETERFV=138;
XCB_GLX_GET_TEX_LEVEL_PARAMETERIV=139;
XCB_GLX_IS_ENABLED=140;
XCB_GLX_IS_LIST=141;
XCB_GLX_FLUSH=142;
XCB_GLX_ARE_TEXTURES_RESIDENT=143;
XCB_GLX_DELETE_TEXTURES=144;
XCB_GLX_GEN_TEXTURES=145;
XCB_GLX_IS_TEXTURE=146;
XCB_GLX_GET_COLOR_TABLE=147;
XCB_GLX_GET_COLOR_TABLE_PARAMETERFV=148;
XCB_GLX_GET_COLOR_TABLE_PARAMETERIV=149;
XCB_GLX_GET_CONVOLUTION_FILTER=150;
XCB_GLX_GET_CONVOLUTION_PARAMETERFV=151;
XCB_GLX_GET_CONVOLUTION_PARAMETERIV=152;
XCB_GLX_GET_SEPARABLE_FILTER=153;
XCB_GLX_GET_HISTOGRAM=154;
XCB_GLX_GET_HISTOGRAM_PARAMETERFV=155;
XCB_GLX_GET_HISTOGRAM_PARAMETERIV=156;
XCB_GLX_GET_MINMAX=157;
XCB_GLX_GET_MINMAX_PARAMETERFV=158;
XCB_GLX_GET_MINMAX_PARAMETERIV=159;
XCB_GLX_GET_COMPRESSED_TEX_IMAGE_ARB=160;
XCB_GLX_DELETE_QUERIES_ARB=161;
XCB_GLX_GEN_QUERIES_ARB=162;
XCB_GLX_IS_QUERY_ARB=163;
XCB_GLX_GET_QUERYIV_ARB=164;
XCB_GLX_GET_QUERY_OBJECTIV_ARB=165;
XCB_GLX_GET_QUERY_OBJECTUIV_ARB=166;
// @defgroup XCB_Present_API XCB Present API
XCB_PRESENT_MAJOR_VERSION=1;
XCB_PRESENT_MINOR_VERSION=4;
XCB_PRESENT_EVENT_CONFIGURE_NOTIFY=0;
XCB_PRESENT_EVENT_COMPLETE_NOTIFY=1;
XCB_PRESENT_EVENT_IDLE_NOTIFY=2;
XCB_PRESENT_EVENT_REDIRECT_NOTIFY=3;
XCB_PRESENT_EVENT_MASK_NO_EVENT=0;
XCB_PRESENT_EVENT_MASK_CONFIGURE_NOTIFY=1;
XCB_PRESENT_EVENT_MASK_COMPLETE_NOTIFY=2;
XCB_PRESENT_EVENT_MASK_IDLE_NOTIFY=4;
XCB_PRESENT_EVENT_MASK_REDIRECT_NOTIFY=8;
XCB_PRESENT_OPTION_NONE=0;
XCB_PRESENT_OPTION_ASYNC=1;
XCB_PRESENT_OPTION_COPY=2;
XCB_PRESENT_OPTION_UST=4;
XCB_PRESENT_OPTION_SUBOPTIMAL=8;
XCB_PRESENT_OPTION_ASYNC_MAY_TEAR=16;
XCB_PRESENT_CAPABILITY_NONE=0;
XCB_PRESENT_CAPABILITY_ASYNC=1;
XCB_PRESENT_CAPABILITY_FENCE=2;
XCB_PRESENT_CAPABILITY_UST=4;
XCB_PRESENT_CAPABILITY_ASYNC_MAY_TEAR=8;
XCB_PRESENT_CAPABILITY_SYNCOBJ=16;
XCB_PRESENT_COMPLETE_KIND_PIXMAP=0;
XCB_PRESENT_COMPLETE_KIND_NOTIFY_MSC=1;
XCB_PRESENT_COMPLETE_MODE_COPY=0;
XCB_PRESENT_COMPLETE_MODE_FLIP=1;
XCB_PRESENT_COMPLETE_MODE_SKIP=2;
XCB_PRESENT_COMPLETE_MODE_SUBOPTIMAL_COPY=3;
XCB_PRESENT_QUERY_VERSION=0;
XCB_PRESENT_PIXMAP=1;
XCB_PRESENT_NOTIFY_MSC=2;
XCB_PRESENT_SELECT_INPUT=3;
XCB_PRESENT_QUERY_CAPABILITIES=4;
XCB_PRESENT_PIXMAP_SYNCED=5;
XCB_PRESENT_GENERIC=0;
XCB_PRESENT_CONFIGURE_NOTIFY=0;
XCB_PRESENT_COMPLETE_NOTIFY=1;
XCB_PRESENT_IDLE_NOTIFY=2;
XCB_PRESENT_REDIRECT_NOTIFY=3;
// @defgroup XCB_RandR_API XCB RandR API
XCB_RANDR_MAJOR_VERSION=1;
XCB_RANDR_MINOR_VERSION=6;
XCB_RANDR_BAD_OUTPUT=0;
XCB_RANDR_BAD_CRTC=1;
XCB_RANDR_BAD_MODE=2;
XCB_RANDR_BAD_PROVIDER=3;
XCB_RANDR_ROTATION_ROTATE_0=1;
XCB_RANDR_ROTATION_ROTATE_90=2;
XCB_RANDR_ROTATION_ROTATE_180=4;
XCB_RANDR_ROTATION_ROTATE_270=8;
XCB_RANDR_ROTATION_REFLECT_X=16;
XCB_RANDR_ROTATION_REFLECT_Y=32;
XCB_RANDR_QUERY_VERSION=0;
XCB_RANDR_SET_CONFIG_SUCCESS=0;
XCB_RANDR_SET_CONFIG_INVALID_CONFIG_TIME=1;
XCB_RANDR_SET_CONFIG_INVALID_TIME=2;
XCB_RANDR_SET_CONFIG_FAILED=3;
XCB_RANDR_SET_SCREEN_CONFIG=2;
XCB_RANDR_NOTIFY_MASK_SCREEN_CHANGE=1;
XCB_RANDR_NOTIFY_MASK_CRTC_CHANGE=2;
XCB_RANDR_NOTIFY_MASK_OUTPUT_CHANGE=4;
XCB_RANDR_NOTIFY_MASK_OUTPUT_PROPERTY=8;
XCB_RANDR_NOTIFY_MASK_PROVIDER_CHANGE=16;
XCB_RANDR_NOTIFY_MASK_PROVIDER_PROPERTY=32;
XCB_RANDR_NOTIFY_MASK_RESOURCE_CHANGE=64;
XCB_RANDR_NOTIFY_MASK_LEASE=128;
XCB_RANDR_SELECT_INPUT=4;
XCB_RANDR_GET_SCREEN_INFO=5;
XCB_RANDR_GET_SCREEN_SIZE_RANGE=6;
XCB_RANDR_SET_SCREEN_SIZE=7;
XCB_RANDR_MODE_FLAG_HSYNC_POSITIVE=1;
XCB_RANDR_MODE_FLAG_HSYNC_NEGATIVE=2;
XCB_RANDR_MODE_FLAG_VSYNC_POSITIVE=4;
XCB_RANDR_MODE_FLAG_VSYNC_NEGATIVE=8;
XCB_RANDR_MODE_FLAG_INTERLACE=16;
XCB_RANDR_MODE_FLAG_DOUBLE_SCAN=32;
XCB_RANDR_MODE_FLAG_CSYNC=64;
XCB_RANDR_MODE_FLAG_CSYNC_POSITIVE=128;
XCB_RANDR_MODE_FLAG_CSYNC_NEGATIVE=256;
XCB_RANDR_MODE_FLAG_HSKEW_PRESENT=512;
XCB_RANDR_MODE_FLAG_BCAST=1024;
XCB_RANDR_MODE_FLAG_PIXEL_MULTIPLEX=2048;
XCB_RANDR_MODE_FLAG_DOUBLE_CLOCK=4096;
XCB_RANDR_MODE_FLAG_HALVE_CLOCK=8192;
XCB_RANDR_GET_SCREEN_RESOURCES=8;
XCB_RANDR_CONNECTION_CONNECTED=0;
XCB_RANDR_CONNECTION_DISCONNECTED=1;
XCB_RANDR_CONNECTION_UNKNOWN=2;
XCB_RANDR_GET_OUTPUT_INFO=9;
XCB_RANDR_LIST_OUTPUT_PROPERTIES=10;
XCB_RANDR_QUERY_OUTPUT_PROPERTY=11;
XCB_RANDR_CONFIGURE_OUTPUT_PROPERTY=12;
XCB_RANDR_CHANGE_OUTPUT_PROPERTY=13;
XCB_RANDR_DELETE_OUTPUT_PROPERTY=14;
XCB_RANDR_GET_OUTPUT_PROPERTY=15;
XCB_RANDR_CREATE_MODE=16;
XCB_RANDR_DESTROY_MODE=17;
XCB_RANDR_ADD_OUTPUT_MODE=18;
XCB_RANDR_DELETE_OUTPUT_MODE=19;
XCB_RANDR_GET_CRTC_INFO=20;
XCB_RANDR_SET_CRTC_CONFIG=21;
XCB_RANDR_GET_CRTC_GAMMA_SIZE=22;
XCB_RANDR_GET_CRTC_GAMMA=23;
XCB_RANDR_SET_CRTC_GAMMA=24;
XCB_RANDR_GET_SCREEN_RESOURCES_CURRENT=25;
XCB_RANDR_TRANSFORM_UNIT=1;
XCB_RANDR_TRANSFORM_SCALE_UP=2;
XCB_RANDR_TRANSFORM_SCALE_DOWN=4;
XCB_RANDR_TRANSFORM_PROJECTIVE=8;
XCB_RANDR_SET_CRTC_TRANSFORM=26;
XCB_RANDR_GET_CRTC_TRANSFORM=27;
XCB_RANDR_GET_PANNING=28;
XCB_RANDR_SET_PANNING=29;
XCB_RANDR_SET_OUTPUT_PRIMARY=30;
XCB_RANDR_GET_OUTPUT_PRIMARY=31;
XCB_RANDR_GET_PROVIDERS=32;
XCB_RANDR_PROVIDER_CAPABILITY_SOURCE_OUTPUT=1;
XCB_RANDR_PROVIDER_CAPABILITY_SINK_OUTPUT=2;
XCB_RANDR_PROVIDER_CAPABILITY_SOURCE_OFFLOAD=4;
XCB_RANDR_PROVIDER_CAPABILITY_SINK_OFFLOAD=8;
XCB_RANDR_GET_PROVIDER_INFO=33;
XCB_RANDR_SET_PROVIDER_OFFLOAD_SINK=34;
XCB_RANDR_SET_PROVIDER_OUTPUT_SOURCE=35;
XCB_RANDR_LIST_PROVIDER_PROPERTIES=36;
XCB_RANDR_QUERY_PROVIDER_PROPERTY=37;
XCB_RANDR_CONFIGURE_PROVIDER_PROPERTY=38;
XCB_RANDR_CHANGE_PROVIDER_PROPERTY=39;
XCB_RANDR_DELETE_PROVIDER_PROPERTY=40;
XCB_RANDR_GET_PROVIDER_PROPERTY=41;
XCB_RANDR_SCREEN_CHANGE_NOTIFY=0;
XCB_RANDR_NOTIFY_CRTC_CHANGE=0;
XCB_RANDR_NOTIFY_OUTPUT_CHANGE=1;
XCB_RANDR_NOTIFY_OUTPUT_PROPERTY=2;
XCB_RANDR_NOTIFY_PROVIDER_CHANGE=3;
XCB_RANDR_NOTIFY_PROVIDER_PROPERTY=4;
XCB_RANDR_NOTIFY_RESOURCE_CHANGE=5;
XCB_RANDR_NOTIFY_LEASE=6;
XCB_RANDR_GET_MONITORS=42;
XCB_RANDR_SET_MONITOR=43;
XCB_RANDR_DELETE_MONITOR=44;
XCB_RANDR_CREATE_LEASE=45;
XCB_RANDR_FREE_LEASE=46;
XCB_RANDR_NOTIFY=1;
// @defgroup XCB_Record_API XCB Record API
XCB_RECORD_MAJOR_VERSION=1;
XCB_RECORD_MINOR_VERSION=13;
XCB_RECORD_H_TYPE_FROM_SERVER_TIME=1;
XCB_RECORD_H_TYPE_FROM_CLIENT_TIME=2;
XCB_RECORD_H_TYPE_FROM_CLIENT_SEQUENCE=4;
XCB_RECORD_CS_CURRENT_CLIENTS=1;
XCB_RECORD_CS_FUTURE_CLIENTS=2;
XCB_RECORD_CS_ALL_CLIENTS=3;
XCB_RECORD_BAD_CONTEXT=0;
XCB_RECORD_QUERY_VERSION=0;
XCB_RECORD_CREATE_CONTEXT=1;
XCB_RECORD_REGISTER_CLIENTS=2;
XCB_RECORD_UNREGISTER_CLIENTS=3;
XCB_RECORD_GET_CONTEXT=4;
XCB_RECORD_ENABLE_CONTEXT=5;
XCB_RECORD_DISABLE_CONTEXT=6;
XCB_RECORD_FREE_CONTEXT=7;
// @defgroup XCB_Render_API XCB Render API
XCB_RENDER_MAJOR_VERSION=0;
XCB_RENDER_MINOR_VERSION=11;
XCB_RENDER_PICT_TYPE_INDEXED=0;
XCB_RENDER_PICT_TYPE_DIRECT=1;
XCB_RENDER_PICTURE_NONE=0;
XCB_RENDER_PICT_OP_CLEAR=0;
XCB_RENDER_PICT_OP_SRC=1;
XCB_RENDER_PICT_OP_DST=2;
XCB_RENDER_PICT_OP_OVER=3;
XCB_RENDER_PICT_OP_OVER_REVERSE=4;
XCB_RENDER_PICT_OP_IN=5;
XCB_RENDER_PICT_OP_IN_REVERSE=6;
XCB_RENDER_PICT_OP_OUT=7;
XCB_RENDER_PICT_OP_OUT_REVERSE=8;
XCB_RENDER_PICT_OP_ATOP=9;
XCB_RENDER_PICT_OP_ATOP_REVERSE=10;
XCB_RENDER_PICT_OP_XOR=11;
XCB_RENDER_PICT_OP_ADD=12;
XCB_RENDER_PICT_OP_SATURATE=13;
XCB_RENDER_PICT_OP_DISJOINT_CLEAR=16;
XCB_RENDER_PICT_OP_DISJOINT_SRC=17;
XCB_RENDER_PICT_OP_DISJOINT_DST=18;
XCB_RENDER_PICT_OP_DISJOINT_OVER=19;
XCB_RENDER_PICT_OP_DISJOINT_OVER_REVERSE=20;
XCB_RENDER_PICT_OP_DISJOINT_IN=21;
XCB_RENDER_PICT_OP_DISJOINT_IN_REVERSE=22;
XCB_RENDER_PICT_OP_DISJOINT_OUT=23;
XCB_RENDER_PICT_OP_DISJOINT_OUT_REVERSE=24;
XCB_RENDER_PICT_OP_DISJOINT_ATOP=25;
XCB_RENDER_PICT_OP_DISJOINT_ATOP_REVERSE=26;
XCB_RENDER_PICT_OP_DISJOINT_XOR=27;
XCB_RENDER_PICT_OP_CONJOINT_CLEAR=32;
XCB_RENDER_PICT_OP_CONJOINT_SRC=33;
XCB_RENDER_PICT_OP_CONJOINT_DST=34;
XCB_RENDER_PICT_OP_CONJOINT_OVER=35;
XCB_RENDER_PICT_OP_CONJOINT_OVER_REVERSE=36;
XCB_RENDER_PICT_OP_CONJOINT_IN=37;
XCB_RENDER_PICT_OP_CONJOINT_IN_REVERSE=38;
XCB_RENDER_PICT_OP_CONJOINT_OUT=39;
XCB_RENDER_PICT_OP_CONJOINT_OUT_REVERSE=40;
XCB_RENDER_PICT_OP_CONJOINT_ATOP=41;
XCB_RENDER_PICT_OP_CONJOINT_ATOP_REVERSE=42;
XCB_RENDER_PICT_OP_CONJOINT_XOR=43;
XCB_RENDER_PICT_OP_MULTIPLY=48;
XCB_RENDER_PICT_OP_SCREEN=49;
XCB_RENDER_PICT_OP_OVERLAY=50;
XCB_RENDER_PICT_OP_DARKEN=51;
XCB_RENDER_PICT_OP_LIGHTEN=52;
XCB_RENDER_PICT_OP_COLOR_DODGE=53;
XCB_RENDER_PICT_OP_COLOR_BURN=54;
XCB_RENDER_PICT_OP_HARD_LIGHT=55;
XCB_RENDER_PICT_OP_SOFT_LIGHT=56;
XCB_RENDER_PICT_OP_DIFFERENCE=57;
XCB_RENDER_PICT_OP_EXCLUSION=58;
XCB_RENDER_PICT_OP_HSL_HUE=59;
XCB_RENDER_PICT_OP_HSL_SATURATION=60;
XCB_RENDER_PICT_OP_HSL_COLOR=61;
XCB_RENDER_PICT_OP_HSL_LUMINOSITY=62;
XCB_RENDER_POLY_EDGE_SHARP=0;
XCB_RENDER_POLY_EDGE_SMOOTH=1;
XCB_RENDER_POLY_MODE_PRECISE=0;
XCB_RENDER_POLY_MODE_IMPRECISE=1;
XCB_RENDER_CP_REPEAT=1;
XCB_RENDER_CP_ALPHA_MAP=2;
XCB_RENDER_CP_ALPHA_X_ORIGIN=4;
XCB_RENDER_CP_ALPHA_Y_ORIGIN=8;
XCB_RENDER_CP_CLIP_X_ORIGIN=16;
XCB_RENDER_CP_CLIP_Y_ORIGIN=32;
XCB_RENDER_CP_CLIP_MASK=64;
XCB_RENDER_CP_GRAPHICS_EXPOSURE=128;
XCB_RENDER_CP_SUBWINDOW_MODE=256;
XCB_RENDER_CP_POLY_EDGE=512;
XCB_RENDER_CP_POLY_MODE=1024;
XCB_RENDER_CP_DITHER=2048;
XCB_RENDER_CP_COMPONENT_ALPHA=4096;
XCB_RENDER_SUB_PIXEL_UNKNOWN=0;
XCB_RENDER_SUB_PIXEL_HORIZONTAL_RGB=1;
XCB_RENDER_SUB_PIXEL_HORIZONTAL_BGR=2;
XCB_RENDER_SUB_PIXEL_VERTICAL_RGB=3;
XCB_RENDER_SUB_PIXEL_VERTICAL_BGR=4;
XCB_RENDER_SUB_PIXEL_NONE=5;
XCB_RENDER_REPEAT_NONE=0;
XCB_RENDER_REPEAT_NORMAL=1;
XCB_RENDER_REPEAT_PAD=2;
XCB_RENDER_REPEAT_REFLECT=3;
XCB_RENDER_PICT_FORMAT=0;
XCB_RENDER_PICTURE=1;
XCB_RENDER_PICT_OP=2;
XCB_RENDER_GLYPH_SET=3;
XCB_RENDER_GLYPH=4;
XCB_RENDER_QUERY_VERSION=0;
XCB_RENDER_QUERY_PICT_FORMATS=1;
XCB_RENDER_QUERY_PICT_INDEX_VALUES=2;
XCB_RENDER_CREATE_PICTURE=4;
XCB_RENDER_CHANGE_PICTURE=5;
XCB_RENDER_SET_PICTURE_CLIP_RECTANGLES=6;
XCB_RENDER_FREE_PICTURE=7;
XCB_RENDER_COMPOSITE=8;
XCB_RENDER_TRAPEZOIDS=10;
XCB_RENDER_TRIANGLES=11;
XCB_RENDER_TRI_STRIP=12;
XCB_RENDER_TRI_FAN=13;
XCB_RENDER_CREATE_GLYPH_SET=17;
XCB_RENDER_REFERENCE_GLYPH_SET=18;
XCB_RENDER_FREE_GLYPH_SET=19;
XCB_RENDER_ADD_GLYPHS=20;
XCB_RENDER_FREE_GLYPHS=22;
XCB_RENDER_COMPOSITE_GLYPHS_8=23;
XCB_RENDER_COMPOSITE_GLYPHS_16=24;
XCB_RENDER_COMPOSITE_GLYPHS_32=25;
XCB_RENDER_FILL_RECTANGLES=26;
XCB_RENDER_CREATE_CURSOR=27;
XCB_RENDER_SET_PICTURE_TRANSFORM=28;
XCB_RENDER_QUERY_FILTERS=29;
XCB_RENDER_SET_PICTURE_FILTER=30;
XCB_RENDER_CREATE_ANIM_CURSOR=31;
XCB_RENDER_ADD_TRAPS=32;
XCB_RENDER_CREATE_SOLID_FILL=33;
XCB_RENDER_CREATE_LINEAR_GRADIENT=34;
XCB_RENDER_CREATE_RADIAL_GRADIENT=35;
XCB_RENDER_CREATE_CONICAL_GRADIENT=36;
// @defgroup XCB_Res_API XCB Res API
XCB_RES_MAJOR_VERSION=1;
XCB_RES_MINOR_VERSION=2;
XCB_RES_CLIENT_ID_MASK_CLIENT_XID=1;
XCB_RES_CLIENT_ID_MASK_LOCAL_CLIENT_PID=2;
XCB_RES_QUERY_VERSION=0;
XCB_RES_QUERY_CLIENTS=1;
XCB_RES_QUERY_CLIENT_RESOURCES=2;
XCB_RES_QUERY_CLIENT_PIXMAP_BYTES=3;
XCB_RES_QUERY_CLIENT_IDS=4;
XCB_RES_QUERY_RESOURCE_BYTES=5;
// @defgroup XCB_ScreenSaver_API XCB ScreenSaver API
XCB_SCREENSAVER_MAJOR_VERSION=1;
XCB_SCREENSAVER_MINOR_VERSION=1;
XCB_SCREENSAVER_KIND_BLANKED=0;
XCB_SCREENSAVER_KIND_INTERNAL=1;
XCB_SCREENSAVER_KIND_EXTERNAL=2;
XCB_SCREENSAVER_EVENT_NOTIFY_MASK=1;
XCB_SCREENSAVER_EVENT_CYCLE_MASK=2;
XCB_SCREENSAVER_STATE_OFF=0;
XCB_SCREENSAVER_STATE_ON=1;
XCB_SCREENSAVER_STATE_CYCLE=2;
XCB_SCREENSAVER_STATE_DISABLED=3;
XCB_SCREENSAVER_QUERY_VERSION=0;
XCB_SCREENSAVER_QUERY_INFO=1;
XCB_SCREENSAVER_SELECT_INPUT=2;
XCB_SCREENSAVER_SET_ATTRIBUTES=3;
XCB_SCREENSAVER_UNSET_ATTRIBUTES=4;
XCB_SCREENSAVER_SUSPEND=5;
XCB_SCREENSAVER_NOTIFY=0;
// @defgroup XCB_Shape_API XCB Shape API
XCB_SHAPE_MAJOR_VERSION=1;
XCB_SHAPE_MINOR_VERSION=1;
XCB_SHAPE_SO_SET=0;
XCB_SHAPE_SO_UNION=1;
XCB_SHAPE_SO_INTERSECT=2;
XCB_SHAPE_SO_SUBTRACT=3;
XCB_SHAPE_SO_INVERT=4;
XCB_SHAPE_SK_BOUNDING=0;
XCB_SHAPE_SK_CLIP=1;
XCB_SHAPE_SK_INPUT=2;
XCB_SHAPE_NOTIFY=0;
XCB_SHAPE_QUERY_VERSION=0;
XCB_SHAPE_RECTANGLES=1;
XCB_SHAPE_MASK=2;
XCB_SHAPE_COMBINE=3;
XCB_SHAPE_OFFSET=4;
XCB_SHAPE_QUERY_EXTENTS=5;
XCB_SHAPE_SELECT_INPUT=6;
XCB_SHAPE_INPUT_SELECTED=7;
XCB_SHAPE_GET_RECTANGLES=8;
// @defgroup XCB_Shm_API XCB Shm API
XCB_SHM_MAJOR_VERSION=1;
XCB_SHM_MINOR_VERSION=2;
XCB_SHM_COMPLETION=0;
XCB_SHM_BAD_SEG=0;
XCB_SHM_QUERY_VERSION=0;
XCB_SHM_ATTACH=1;
XCB_SHM_DETACH=2;
XCB_SHM_PUT_IMAGE=3;
XCB_SHM_GET_IMAGE=4;
XCB_SHM_CREATE_PIXMAP=5;
XCB_SHM_ATTACH_FD=6;
XCB_SHM_CREATE_SEGMENT=7;
XCB_SYNC_MAJOR_VERSION=3;
XCB_SYNC_MINOR_VERSION=1;
XCB_SYNC_ALARMSTATE_ACTIVE=0;
XCB_SYNC_ALARMSTATE_INACTIVE=1;
XCB_SYNC_ALARMSTATE_DESTROYED=2;
XCB_SYNC_TESTTYPE_POSITIVE_TRANSITION=0;
XCB_SYNC_TESTTYPE_NEGATIVE_TRANSITION=1;
XCB_SYNC_TESTTYPE_POSITIVE_COMPARISON=2;
XCB_SYNC_TESTTYPE_NEGATIVE_COMPARISON=3;
XCB_SYNC_VALUETYPE_ABSOLUTE=0;
XCB_SYNC_VALUETYPE_RELATIVE=1;
XCB_SYNC_CA_COUNTER=1;
XCB_SYNC_CA_VALUE_TYPE=2;
XCB_SYNC_CA_VALUE=4;
XCB_SYNC_CA_TEST_TYPE=8;
XCB_SYNC_CA_DELTA=16;
XCB_SYNC_CA_EVENTS=32;
XCB_SYNC_COUNTER=0;
XCB_SYNC_ALARM=1;
XCB_SYNC_INITIALIZE=0;
XCB_SYNC_LIST_SYSTEM_COUNTERS=1;
XCB_SYNC_CREATE_COUNTER=2;
XCB_SYNC_DESTROY_COUNTER=6;
XCB_SYNC_QUERY_COUNTER=5;
XCB_SYNC_AWAIT=7;
XCB_SYNC_CHANGE_COUNTER=4;
XCB_SYNC_SET_COUNTER=3;
XCB_SYNC_CREATE_ALARM=8;
XCB_SYNC_CHANGE_ALARM=9;
XCB_SYNC_DESTROY_ALARM=11;
XCB_SYNC_QUERY_ALARM=10;
XCB_SYNC_SET_PRIORITY=12;
XCB_SYNC_GET_PRIORITY=13;
XCB_SYNC_CREATE_FENCE=14;
XCB_SYNC_TRIGGER_FENCE=15;
XCB_SYNC_RESET_FENCE=16;
XCB_SYNC_DESTROY_FENCE=17;
XCB_SYNC_QUERY_FENCE=18;
XCB_SYNC_AWAIT_FENCE=19;
XCB_SYNC_COUNTER_NOTIFY=0;
XCB_SYNC_ALARM_NOTIFY=1;
XCB_EWMH_CLIENT_SOURCE_TYPE_NONE=0;
XCB_EWMH_CLIENT_SOURCE_TYPE_NORMAL=1;
XCB_EWMH_CLIENT_SOURCE_TYPE_OTHER=2;
XCB_EWMH_WM_ORIENTATION_HORZ=0;
XCB_EWMH_WM_ORIENTATION_VERT=1;
XCB_EWMH_WM_TOPLEFT=0;
XCB_EWMH_WM_TOPRIGHT=1;
XCB_EWMH_WM_BOTTOMRIGHT=2;
XCB_EWMH_WM_BOTTOMLEFT=3;
XCB_EWMH_MOVERESIZE_WINDOW_X=(1 shl 8);
XCB_EWMH_MOVERESIZE_WINDOW_Y=(1 shl 9);
XCB_EWMH_MOVERESIZE_WINDOW_WIDTH=(1 shl 10);
XCB_EWMH_MOVERESIZE_WINDOW_HEIGHT=(1 shl 11);
XCB_EWMH_WM_MOVERESIZE_SIZE_TOPLEFT=0;
XCB_EWMH_WM_MOVERESIZE_SIZE_TOP=1;
XCB_EWMH_WM_MOVERESIZE_SIZE_TOPRIGHT=2;
XCB_EWMH_WM_MOVERESIZE_SIZE_RIGHT=3;
XCB_EWMH_WM_MOVERESIZE_SIZE_BOTTOMRIGHT=4;
XCB_EWMH_WM_MOVERESIZE_SIZE_BOTTOM=5;
XCB_EWMH_WM_MOVERESIZE_SIZE_BOTTOMLEFT=6;
XCB_EWMH_WM_MOVERESIZE_SIZE_LEFT=7;
XCB_EWMH_WM_MOVERESIZE_MOVE=8;
XCB_EWMH_WM_MOVERESIZE_SIZE_KEYBOARD=9;
XCB_EWMH_WM_MOVERESIZE_MOVE_KEYBOARD=10;
XCB_EWMH_WM_MOVERESIZE_CANCEL=11;
XCB_EWMH_WM_STATE_REMOVE=0;
XCB_EWMH_WM_STATE_ADD=1;
XCB_EWMH_WM_STATE_TOGGLE=2;
XCB_REQUEST_CHECKED=(1 shl 0);
XCB_REQUEST_RAW=(1 shl 1);
XCB_REQUEST_DISCARD_REPLY=(1 shl 2);
XCB_REQUEST_REPLY_FDS=(1 shl 3);
// @defgroup XCB_Core_API XCB Core API
XCB_CONN_ERROR=1;
XCB_CONN_CLOSED_EXT_NOTSUPPORTED=2;
XCB_CONN_CLOSED_MEM_INSUFFICIENT=3;
XCB_CONN_CLOSED_REQ_LEN_EXCEED=4;
XCB_CONN_CLOSED_PARSE_ERR=5;
XCB_CONN_CLOSED_INVALID_SCREEN=6;
XCB_CONN_CLOSED_FDPASSING_FAILED=7;
XCB_NONE=0;
XCB_COPY_FROM_PARENT=0;
XCB_CURRENT_TIME=0;
XCB_NO_SYMBOL=0;
XCB_ICCCM_SIZE_HINT_US_POSITION=(1 shl 0);
XCB_ICCCM_SIZE_HINT_US_SIZE=(1 shl 1);
XCB_ICCCM_SIZE_HINT_P_POSITION=(1 shl 2);
XCB_ICCCM_SIZE_HINT_P_SIZE=(1 shl 3);
XCB_ICCCM_SIZE_HINT_P_MIN_SIZE=(1 shl 4);
XCB_ICCCM_SIZE_HINT_P_MAX_SIZE=(1 shl 5);
XCB_ICCCM_SIZE_HINT_P_RESIZE_INC=(1 shl 6);
XCB_ICCCM_SIZE_HINT_P_ASPECT=(1 shl 7);
XCB_ICCCM_SIZE_HINT_BASE_SIZE=(1 shl 8);
XCB_ICCCM_SIZE_HINT_P_WIN_GRAVITY=(1 shl 9);
XCB_ICCCM_NUM_WM_SIZE_HINTS_ELEMENTS=18;
XCB_ICCCM_NUM_WM_HINTS_ELEMENTS=9;
XCB_ICCCM_WM_STATE_WITHDRAWN=0;
XCB_ICCCM_WM_STATE_NORMAL=1;
XCB_ICCCM_WM_STATE_ICONIC=3;
XCB_ICCCM_WM_HINT_INPUT=(1 shl 0);
XCB_ICCCM_WM_HINT_STATE=(1 shl 1);
XCB_ICCCM_WM_HINT_ICON_PIXMAP=(1 shl 2);
XCB_ICCCM_WM_HINT_ICON_WINDOW=(1 shl 3);
XCB_ICCCM_WM_HINT_ICON_POSITION=(1 shl 4);
XCB_ICCCM_WM_HINT_ICON_MASK=(1 shl 5);
XCB_ICCCM_WM_HINT_WINDOW_GROUP=(1 shl 6);
XCB_ICCCM_WM_HINT_X_URGENCY=(1 shl 8);
XCB_ICCCM_WM_ALL_HINTS=(XCB_ICCCM_WM_HINT_INPUT or XCB_ICCCM_WM_HINT_STATE or XCB_ICCCM_WM_HINT_ICON_PIXMAP or
 XCB_ICCCM_WM_HINT_ICON_WINDOW or XCB_ICCCM_WM_HINT_ICON_POSITION or XCB_ICCCM_WM_HINT_ICON_MASK or XCB_ICCCM_WM_HINT_WINDOW_GROUP);
XCB_PICT_FORMAT_ID=(1 shl 0);
XCB_PICT_FORMAT_TYPE=(1 shl 1);
XCB_PICT_FORMAT_DEPTH=(1 shl 2);
XCB_PICT_FORMAT_RED=(1 shl 3);
XCB_PICT_FORMAT_RED_MASK=(1 shl 4);
XCB_PICT_FORMAT_GREEN=(1 shl 5);
XCB_PICT_FORMAT_GREEN_MASK=(1 shl 6);
XCB_PICT_FORMAT_BLUE=(1 shl 7);
XCB_PICT_FORMAT_BLUE_MASK=(1 shl 8);
XCB_PICT_FORMAT_ALPHA=(1 shl 9);
XCB_PICT_FORMAT_ALPHA_MASK=(1 shl 10);
XCB_PICT_FORMAT_COLORMAP=(1 shl 11);
// @defgroup XCB_XCMisc_API XCB XCMisc API
XCB_XCMISC_MAJOR_VERSION=1;
XCB_XCMISC_MINOR_VERSION=1;
XCB_XC_MISC_GET_VERSION=0;
XCB_XC_MISC_GET_XID_RANGE=1;
XCB_XC_MISC_GET_XID_LIST=2;
// @defgroup XCB_XFixes_API XCB XFixes API
XCB_XFIXES_MAJOR_VERSION=6;
XCB_XFIXES_MINOR_VERSION=0;
XCB_XFIXES_QUERY_VERSION=0;
XCB_XFIXES_SAVE_SET_MODE_INSERT=0;
XCB_XFIXES_SAVE_SET_MODE_DELETE=1;
XCB_XFIXES_SAVE_SET_TARGET_NEAREST=0;
XCB_XFIXES_SAVE_SET_TARGET_ROOT=1;
XCB_XFIXES_SAVE_SET_MAPPING_MAP=0;
XCB_XFIXES_SAVE_SET_MAPPING_UNMAP=1;
XCB_XFIXES_CHANGE_SAVE_SET=1;
XCB_XFIXES_SELECTION_EVENT_SET_SELECTION_OWNER=0;
XCB_XFIXES_SELECTION_EVENT_SELECTION_WINDOW_DESTROY=1;
XCB_XFIXES_SELECTION_EVENT_SELECTION_CLIENT_CLOSE=2;
XCB_XFIXES_SELECTION_EVENT_MASK_SET_SELECTION_OWNER=1;
XCB_XFIXES_SELECTION_EVENT_MASK_SELECTION_WINDOW_DESTROY=2;
XCB_XFIXES_SELECTION_EVENT_MASK_SELECTION_CLIENT_CLOSE=4;
XCB_XFIXES_SELECTION_NOTIFY=0;
XCB_XFIXES_SELECT_SELECTION_INPUT=2;
XCB_XFIXES_CURSOR_NOTIFY_DISPLAY_CURSOR=0;
XCB_XFIXES_CURSOR_NOTIFY_MASK_DISPLAY_CURSOR=1;
XCB_XFIXES_CURSOR_NOTIFY=1;
XCB_XFIXES_SELECT_CURSOR_INPUT=3;
XCB_XFIXES_GET_CURSOR_IMAGE=4;
XCB_XFIXES_BAD_REGION=0;
XCB_XFIXES_REGION_NONE=0;
XCB_XFIXES_CREATE_REGION=5;
XCB_XFIXES_CREATE_REGION_FROM_BITMAP=6;
XCB_XFIXES_CREATE_REGION_FROM_WINDOW=7;
XCB_XFIXES_CREATE_REGION_FROM_GC=8;
XCB_XFIXES_CREATE_REGION_FROM_PICTURE=9;
XCB_XFIXES_DESTROY_REGION=10;
XCB_XFIXES_SET_REGION=11;
XCB_XFIXES_COPY_REGION=12;
XCB_XFIXES_UNION_REGION=13;
XCB_XFIXES_INTERSECT_REGION=14;
XCB_XFIXES_SUBTRACT_REGION=15;
XCB_XFIXES_INVERT_REGION=16;
XCB_XFIXES_TRANSLATE_REGION=17;
XCB_XFIXES_REGION_EXTENTS=18;
XCB_XFIXES_FETCH_REGION=19;
XCB_XFIXES_SET_GC_CLIP_REGION=20;
XCB_XFIXES_SET_WINDOW_SHAPE_REGION=21;
XCB_XFIXES_SET_PICTURE_CLIP_REGION=22;
XCB_XFIXES_SET_CURSOR_NAME=23;
XCB_XFIXES_GET_CURSOR_NAME=24;
XCB_XFIXES_GET_CURSOR_IMAGE_AND_NAME=25;
XCB_XFIXES_CHANGE_CURSOR=26;
XCB_XFIXES_CHANGE_CURSOR_BY_NAME=27;
XCB_XFIXES_EXPAND_REGION=28;
XCB_XFIXES_HIDE_CURSOR=29;
XCB_XFIXES_SHOW_CURSOR=30;
XCB_XFIXES_BARRIER_DIRECTIONS_POSITIVE_X=1;
XCB_XFIXES_BARRIER_DIRECTIONS_POSITIVE_Y=2;
XCB_XFIXES_BARRIER_DIRECTIONS_NEGATIVE_X=4;
XCB_XFIXES_BARRIER_DIRECTIONS_NEGATIVE_Y=8;
XCB_XFIXES_CREATE_POINTER_BARRIER=31;
XCB_XFIXES_DELETE_POINTER_BARRIER=32;
XCB_XFIXES_CLIENT_DISCONNECT_FLAGS_DEFAULT=0;
XCB_XFIXES_CLIENT_DISCONNECT_FLAGS_TERMINATE=1;
XCB_XFIXES_SET_CLIENT_DISCONNECT_MODE=33;
XCB_XFIXES_GET_CLIENT_DISCONNECT_MODE=34;
// @defgroup XCB_Xinerama_API XCB Xinerama API
XCB_XINERAMA_MAJOR_VERSION=1;
XCB_XINERAMA_MINOR_VERSION=1;
XCB_XINERAMA_QUERY_VERSION=0;
XCB_XINERAMA_GET_STATE=1;
XCB_XINERAMA_GET_SCREEN_COUNT=2;
XCB_XINERAMA_GET_SCREEN_SIZE=3;
XCB_XINERAMA_IS_ACTIVE=4;
XCB_XINERAMA_QUERY_SCREENS=5;
// @defgroup XCB_Input_API XCB Input API
XCB_INPUT_MAJOR_VERSION=2;
XCB_INPUT_MINOR_VERSION=4;
XCB_INPUT_GET_EXTENSION_VERSION=1;
XCB_INPUT_DEVICE_USE_IS_X_POINTER=0;
XCB_INPUT_DEVICE_USE_IS_X_KEYBOARD=1;
XCB_INPUT_DEVICE_USE_IS_X_EXTENSION_DEVICE=2;
XCB_INPUT_DEVICE_USE_IS_X_EXTENSION_KEYBOARD=3;
XCB_INPUT_DEVICE_USE_IS_X_EXTENSION_POINTER=4;
XCB_INPUT_INPUT_CLASS_KEY=0;
XCB_INPUT_INPUT_CLASS_BUTTON=1;
XCB_INPUT_INPUT_CLASS_VALUATOR=2;
XCB_INPUT_INPUT_CLASS_FEEDBACK=3;
XCB_INPUT_INPUT_CLASS_PROXIMITY=4;
XCB_INPUT_INPUT_CLASS_FOCUS=5;
XCB_INPUT_INPUT_CLASS_OTHER=6;
XCB_INPUT_VALUATOR_MODE_RELATIVE=0;
XCB_INPUT_VALUATOR_MODE_ABSOLUTE=1;
XCB_INPUT_LIST_INPUT_DEVICES=2;
XCB_INPUT_OPEN_DEVICE=3;
XCB_INPUT_CLOSE_DEVICE=4;
XCB_INPUT_SET_DEVICE_MODE=5;
XCB_INPUT_SELECT_EXTENSION_EVENT=6;
XCB_INPUT_GET_SELECTED_EXTENSION_EVENTS=7;
XCB_INPUT_PROPAGATE_MODE_ADD_TO_LIST=0;
XCB_INPUT_PROPAGATE_MODE_DELETE_FROM_LIST=1;
XCB_INPUT_CHANGE_DEVICE_DONT_PROPAGATE_LIST=8;
XCB_INPUT_GET_DEVICE_DONT_PROPAGATE_LIST=9;
XCB_INPUT_GET_DEVICE_MOTION_EVENTS=10;
XCB_INPUT_CHANGE_KEYBOARD_DEVICE=11;
XCB_INPUT_CHANGE_POINTER_DEVICE=12;
XCB_INPUT_GRAB_DEVICE=13;
XCB_INPUT_UNGRAB_DEVICE=14;
XCB_INPUT_MODIFIER_DEVICE_USE_X_KEYBOARD=255;
XCB_INPUT_GRAB_DEVICE_KEY=15;
XCB_INPUT_UNGRAB_DEVICE_KEY=16;
XCB_INPUT_GRAB_DEVICE_BUTTON=17;
XCB_INPUT_UNGRAB_DEVICE_BUTTON=18;
XCB_INPUT_DEVICE_INPUT_MODE_ASYNC_THIS_DEVICE=0;
XCB_INPUT_DEVICE_INPUT_MODE_SYNC_THIS_DEVICE=1;
XCB_INPUT_DEVICE_INPUT_MODE_REPLAY_THIS_DEVICE=2;
XCB_INPUT_DEVICE_INPUT_MODE_ASYNC_OTHER_DEVICES=3;
XCB_INPUT_DEVICE_INPUT_MODE_ASYNC_ALL=4;
XCB_INPUT_DEVICE_INPUT_MODE_SYNC_ALL=5;
XCB_INPUT_ALLOW_DEVICE_EVENTS=19;
XCB_INPUT_GET_DEVICE_FOCUS=20;
XCB_INPUT_SET_DEVICE_FOCUS=21;
XCB_INPUT_FEEDBACK_CLASS_KEYBOARD=0;
XCB_INPUT_FEEDBACK_CLASS_POINTER=1;
XCB_INPUT_FEEDBACK_CLASS_STRING=2;
XCB_INPUT_FEEDBACK_CLASS_INTEGER=3;
XCB_INPUT_FEEDBACK_CLASS_LED=4;
XCB_INPUT_FEEDBACK_CLASS_BELL=5;
XCB_INPUT_GET_FEEDBACK_CONTROL=22;
XCB_INPUT_CHANGE_FEEDBACK_CONTROL_MASK_KEY_CLICK_PERCENT=1;
XCB_INPUT_CHANGE_FEEDBACK_CONTROL_MASK_PERCENT=2;
XCB_INPUT_CHANGE_FEEDBACK_CONTROL_MASK_PITCH=4;
XCB_INPUT_CHANGE_FEEDBACK_CONTROL_MASK_DURATION=8;
XCB_INPUT_CHANGE_FEEDBACK_CONTROL_MASK_LED=16;
XCB_INPUT_CHANGE_FEEDBACK_CONTROL_MASK_LED_MODE=32;
XCB_INPUT_CHANGE_FEEDBACK_CONTROL_MASK_KEY=64;
XCB_INPUT_CHANGE_FEEDBACK_CONTROL_MASK_AUTO_REPEAT_MODE=128;
XCB_INPUT_CHANGE_FEEDBACK_CONTROL_MASK_STRING=1;
XCB_INPUT_CHANGE_FEEDBACK_CONTROL_MASK_INTEGER=1;
XCB_INPUT_CHANGE_FEEDBACK_CONTROL_MASK_ACCEL_NUM=1;
XCB_INPUT_CHANGE_FEEDBACK_CONTROL_MASK_ACCEL_DENOM=2;
XCB_INPUT_CHANGE_FEEDBACK_CONTROL_MASK_THRESHOLD=4;
XCB_INPUT_CHANGE_FEEDBACK_CONTROL=23;
XCB_INPUT_GET_DEVICE_KEY_MAPPING=24;
XCB_INPUT_CHANGE_DEVICE_KEY_MAPPING=25;
XCB_INPUT_GET_DEVICE_MODIFIER_MAPPING=26;
XCB_INPUT_SET_DEVICE_MODIFIER_MAPPING=27;
XCB_INPUT_GET_DEVICE_BUTTON_MAPPING=28;
XCB_INPUT_SET_DEVICE_BUTTON_MAPPING=29;
XCB_INPUT_VALUATOR_STATE_MODE_MASK_DEVICE_MODE_ABSOLUTE=1;
XCB_INPUT_VALUATOR_STATE_MODE_MASK_OUT_OF_PROXIMITY=2;
XCB_INPUT_QUERY_DEVICE_STATE=30;
XCB_INPUT_DEVICE_BELL=32;
XCB_INPUT_SET_DEVICE_VALUATORS=33;
XCB_INPUT_DEVICE_CONTROL_RESOLUTION=1;
XCB_INPUT_DEVICE_CONTROL_ABS_CALIB=2;
XCB_INPUT_DEVICE_CONTROL_CORE=3;
XCB_INPUT_DEVICE_CONTROL_ENABLE=4;
XCB_INPUT_DEVICE_CONTROL_ABS_AREA=5;
XCB_INPUT_GET_DEVICE_CONTROL=34;
XCB_INPUT_CHANGE_DEVICE_CONTROL=35;
XCB_INPUT_LIST_DEVICE_PROPERTIES=36;
XCB_INPUT_PROPERTY_FORMAT_8_BITS=8;
XCB_INPUT_PROPERTY_FORMAT_16_BITS=16;
XCB_INPUT_PROPERTY_FORMAT_32_BITS=32;
XCB_INPUT_CHANGE_DEVICE_PROPERTY=37;
XCB_INPUT_DELETE_DEVICE_PROPERTY=38;
XCB_INPUT_GET_DEVICE_PROPERTY=39;
XCB_INPUT_DEVICE_ALL=0;
XCB_INPUT_DEVICE_ALL_MASTER=1;
XCB_INPUT_XI_QUERY_POINTER=40;
XCB_INPUT_XI_WARP_POINTER=41;
XCB_INPUT_XI_CHANGE_CURSOR=42;
XCB_INPUT_HIERARCHY_CHANGE_TYPE_ADD_MASTER=1;
XCB_INPUT_HIERARCHY_CHANGE_TYPE_REMOVE_MASTER=2;
XCB_INPUT_HIERARCHY_CHANGE_TYPE_ATTACH_SLAVE=3;
XCB_INPUT_HIERARCHY_CHANGE_TYPE_DETACH_SLAVE=4;
XCB_INPUT_CHANGE_MODE_ATTACH=1;
XCB_INPUT_CHANGE_MODE_FLOAT=2;
XCB_INPUT_XI_CHANGE_HIERARCHY=43;
XCB_INPUT_XI_SET_CLIENT_POINTER=44;
XCB_INPUT_XI_GET_CLIENT_POINTER=45;
XCB_INPUT_XI_EVENT_MASK_DEVICE_CHANGED=2;
XCB_INPUT_XI_EVENT_MASK_KEY_PRESS=4;
XCB_INPUT_XI_EVENT_MASK_KEY_RELEASE=8;
XCB_INPUT_XI_EVENT_MASK_BUTTON_PRESS=16;
XCB_INPUT_XI_EVENT_MASK_BUTTON_RELEASE=32;
XCB_INPUT_XI_EVENT_MASK_MOTION=64;
XCB_INPUT_XI_EVENT_MASK_ENTER=128;
XCB_INPUT_XI_EVENT_MASK_LEAVE=256;
XCB_INPUT_XI_EVENT_MASK_FOCUS_IN=512;
XCB_INPUT_XI_EVENT_MASK_FOCUS_OUT=1024;
XCB_INPUT_XI_EVENT_MASK_HIERARCHY=2048;
XCB_INPUT_XI_EVENT_MASK_PROPERTY=4096;
XCB_INPUT_XI_EVENT_MASK_RAW_KEY_PRESS=8192;
XCB_INPUT_XI_EVENT_MASK_RAW_KEY_RELEASE=16384;
XCB_INPUT_XI_EVENT_MASK_RAW_BUTTON_PRESS=32768;
XCB_INPUT_XI_EVENT_MASK_RAW_BUTTON_RELEASE=65536;
XCB_INPUT_XI_EVENT_MASK_RAW_MOTION=131072;
XCB_INPUT_XI_EVENT_MASK_TOUCH_BEGIN=262144;
XCB_INPUT_XI_EVENT_MASK_TOUCH_UPDATE=524288;
XCB_INPUT_XI_EVENT_MASK_TOUCH_END=1048576;
XCB_INPUT_XI_EVENT_MASK_TOUCH_OWNERSHIP=2097152;
XCB_INPUT_XI_EVENT_MASK_RAW_TOUCH_BEGIN=4194304;
XCB_INPUT_XI_EVENT_MASK_RAW_TOUCH_UPDATE=8388608;
XCB_INPUT_XI_EVENT_MASK_RAW_TOUCH_END=16777216;
XCB_INPUT_XI_EVENT_MASK_BARRIER_HIT=33554432;
XCB_INPUT_XI_EVENT_MASK_BARRIER_LEAVE=67108864;
XCB_INPUT_XI_SELECT_EVENTS=46;
XCB_INPUT_XI_QUERY_VERSION=47;
XCB_INPUT_DEVICE_CLASS_TYPE_KEY=0;
XCB_INPUT_DEVICE_CLASS_TYPE_BUTTON=1;
XCB_INPUT_DEVICE_CLASS_TYPE_VALUATOR=2;
XCB_INPUT_DEVICE_CLASS_TYPE_SCROLL=3;
XCB_INPUT_DEVICE_CLASS_TYPE_TOUCH=8;
XCB_INPUT_DEVICE_CLASS_TYPE_GESTURE=9;
XCB_INPUT_DEVICE_TYPE_MASTER_POINTER=1;
XCB_INPUT_DEVICE_TYPE_MASTER_KEYBOARD=2;
XCB_INPUT_DEVICE_TYPE_SLAVE_POINTER=3;
XCB_INPUT_DEVICE_TYPE_SLAVE_KEYBOARD=4;
XCB_INPUT_DEVICE_TYPE_FLOATING_SLAVE=5;
XCB_INPUT_SCROLL_FLAGS_NO_EMULATION=1;
XCB_INPUT_SCROLL_FLAGS_PREFERRED=2;
XCB_INPUT_SCROLL_TYPE_VERTICAL=1;
XCB_INPUT_SCROLL_TYPE_HORIZONTAL=2;
XCB_INPUT_TOUCH_MODE_DIRECT=1;
XCB_INPUT_TOUCH_MODE_DEPENDENT=2;
XCB_INPUT_XI_QUERY_DEVICE=48;
XCB_INPUT_XI_SET_FOCUS=49;
XCB_INPUT_XI_GET_FOCUS=50;
XCB_INPUT_GRAB_OWNER_NO_OWNER=0;
XCB_INPUT_GRAB_OWNER_OWNER=1;
XCB_INPUT_XI_GRAB_DEVICE=51;
XCB_INPUT_XI_UNGRAB_DEVICE=52;
XCB_INPUT_EVENT_MODE_ASYNC_DEVICE=0;
XCB_INPUT_EVENT_MODE_SYNC_DEVICE=1;
XCB_INPUT_EVENT_MODE_REPLAY_DEVICE=2;
XCB_INPUT_EVENT_MODE_ASYNC_PAIRED_DEVICE=3;
XCB_INPUT_EVENT_MODE_ASYNC_PAIR=4;
XCB_INPUT_EVENT_MODE_SYNC_PAIR=5;
XCB_INPUT_EVENT_MODE_ACCEPT_TOUCH=6;
XCB_INPUT_EVENT_MODE_REJECT_TOUCH=7;
XCB_INPUT_XI_ALLOW_EVENTS=53;
XCB_INPUT_GRAB_MODE_22_SYNC=0;
XCB_INPUT_GRAB_MODE_22_ASYNC=1;
XCB_INPUT_GRAB_MODE_22_TOUCH=2;
XCB_INPUT_GRAB_TYPE_BUTTON=0;
XCB_INPUT_GRAB_TYPE_KEYCODE=1;
XCB_INPUT_GRAB_TYPE_ENTER=2;
XCB_INPUT_GRAB_TYPE_FOCUS_IN=3;
XCB_INPUT_GRAB_TYPE_TOUCH_BEGIN=4;
XCB_INPUT_GRAB_TYPE_GESTURE_PINCH_BEGIN=5;
XCB_INPUT_GRAB_TYPE_GESTURE_SWIPE_BEGIN=6;
XCB_INPUT_MODIFIER_MASK_ANY=2147483648;
XCB_INPUT_XI_PASSIVE_GRAB_DEVICE=54;
XCB_INPUT_XI_PASSIVE_UNGRAB_DEVICE=55;
XCB_INPUT_XI_LIST_PROPERTIES=56;
XCB_INPUT_XI_CHANGE_PROPERTY=57;
XCB_INPUT_XI_DELETE_PROPERTY=58;
XCB_INPUT_XI_GET_PROPERTY=59;
XCB_INPUT_XI_GET_SELECTED_EVENTS=60;
XCB_INPUT_XI_BARRIER_RELEASE_POINTER=61;
XCB_INPUT_DEVICE_VALUATOR=0;
XCB_INPUT_MORE_EVENTS_MASK_MORE_EVENTS=128;
XCB_INPUT_DEVICE_KEY_PRESS=1;
XCB_INPUT_DEVICE_KEY_RELEASE=2;
XCB_INPUT_DEVICE_BUTTON_PRESS=3;
XCB_INPUT_DEVICE_BUTTON_RELEASE=4;
XCB_INPUT_DEVICE_MOTION_NOTIFY=5;
XCB_INPUT_DEVICE_FOCUS_IN=6;
XCB_INPUT_DEVICE_FOCUS_OUT=7;
XCB_INPUT_PROXIMITY_IN=8;
XCB_INPUT_PROXIMITY_OUT=9;
XCB_INPUT_CLASSES_REPORTED_MASK_OUT_OF_PROXIMITY=128;
XCB_INPUT_CLASSES_REPORTED_MASK_DEVICE_MODE_ABSOLUTE=64;
XCB_INPUT_CLASSES_REPORTED_MASK_REPORTING_VALUATORS=4;
XCB_INPUT_CLASSES_REPORTED_MASK_REPORTING_BUTTONS=2;
XCB_INPUT_CLASSES_REPORTED_MASK_REPORTING_KEYS=1;
XCB_INPUT_DEVICE_STATE_NOTIFY=10;
XCB_INPUT_DEVICE_MAPPING_NOTIFY=11;
XCB_INPUT_CHANGE_DEVICE_NEW_POINTER=0;
XCB_INPUT_CHANGE_DEVICE_NEW_KEYBOARD=1;
XCB_INPUT_CHANGE_DEVICE_NOTIFY=12;
XCB_INPUT_DEVICE_KEY_STATE_NOTIFY=13;
XCB_INPUT_DEVICE_BUTTON_STATE_NOTIFY=14;
XCB_INPUT_DEVICE_CHANGE_ADDED=0;
XCB_INPUT_DEVICE_CHANGE_REMOVED=1;
XCB_INPUT_DEVICE_CHANGE_ENABLED=2;
XCB_INPUT_DEVICE_CHANGE_DISABLED=3;
XCB_INPUT_DEVICE_CHANGE_UNRECOVERABLE=4;
XCB_INPUT_DEVICE_CHANGE_CONTROL_CHANGED=5;
XCB_INPUT_DEVICE_PRESENCE_NOTIFY=15;
XCB_INPUT_DEVICE_PROPERTY_NOTIFY=16;
XCB_INPUT_CHANGE_REASON_SLAVE_SWITCH=1;
XCB_INPUT_CHANGE_REASON_DEVICE_CHANGE=2;
XCB_INPUT_DEVICE_CHANGED=1;
XCB_INPUT_KEY_EVENT_FLAGS_KEY_REPEAT=65536;
XCB_INPUT_KEY_PRESS=2;
XCB_INPUT_KEY_RELEASE=3;
XCB_INPUT_POINTER_EVENT_FLAGS_POINTER_EMULATED=65536;
XCB_INPUT_BUTTON_PRESS=4;
XCB_INPUT_BUTTON_RELEASE=5;
XCB_INPUT_MOTION=6;
XCB_INPUT_NOTIFY_MODE_NORMAL=0;
XCB_INPUT_NOTIFY_MODE_GRAB=1;
XCB_INPUT_NOTIFY_MODE_UNGRAB=2;
XCB_INPUT_NOTIFY_MODE_WHILE_GRABBED=3;
XCB_INPUT_NOTIFY_MODE_PASSIVE_GRAB=4;
XCB_INPUT_NOTIFY_MODE_PASSIVE_UNGRAB=5;
XCB_INPUT_NOTIFY_DETAIL_ANCESTOR=0;
XCB_INPUT_NOTIFY_DETAIL_VIRTUAL=1;
XCB_INPUT_NOTIFY_DETAIL_INFERIOR=2;
XCB_INPUT_NOTIFY_DETAIL_NONLINEAR=3;
XCB_INPUT_NOTIFY_DETAIL_NONLINEAR_VIRTUAL=4;
XCB_INPUT_NOTIFY_DETAIL_POINTER=5;
XCB_INPUT_NOTIFY_DETAIL_POINTER_ROOT=6;
XCB_INPUT_NOTIFY_DETAIL_NONE=7;
XCB_INPUT_ENTER=7;
XCB_INPUT_LEAVE=8;
XCB_INPUT_FOCUS_IN=9;
XCB_INPUT_FOCUS_OUT=10;
XCB_INPUT_HIERARCHY_MASK_MASTER_ADDED=1;
XCB_INPUT_HIERARCHY_MASK_MASTER_REMOVED=2;
XCB_INPUT_HIERARCHY_MASK_SLAVE_ADDED=4;
XCB_INPUT_HIERARCHY_MASK_SLAVE_REMOVED=8;
XCB_INPUT_HIERARCHY_MASK_SLAVE_ATTACHED=16;
XCB_INPUT_HIERARCHY_MASK_SLAVE_DETACHED=32;
XCB_INPUT_HIERARCHY_MASK_DEVICE_ENABLED=64;
XCB_INPUT_HIERARCHY_MASK_DEVICE_DISABLED=128;
XCB_INPUT_HIERARCHY=11;
XCB_INPUT_PROPERTY_FLAG_DELETED=0;
XCB_INPUT_PROPERTY_FLAG_CREATED=1;
XCB_INPUT_PROPERTY_FLAG_MODIFIED=2;
XCB_INPUT_PROPERTY=12;
XCB_INPUT_RAW_KEY_PRESS=13;
XCB_INPUT_RAW_KEY_RELEASE=14;
XCB_INPUT_RAW_BUTTON_PRESS=15;
XCB_INPUT_RAW_BUTTON_RELEASE=16;
XCB_INPUT_RAW_MOTION=17;
XCB_INPUT_TOUCH_EVENT_FLAGS_TOUCH_PENDING_END=65536;
XCB_INPUT_TOUCH_EVENT_FLAGS_TOUCH_EMULATING_POINTER=131072;
XCB_INPUT_TOUCH_BEGIN=18;
XCB_INPUT_TOUCH_UPDATE=19;
XCB_INPUT_TOUCH_END=20;
XCB_INPUT_TOUCH_OWNERSHIP_FLAGS_NONE=0;
XCB_INPUT_TOUCH_OWNERSHIP=21;
XCB_INPUT_RAW_TOUCH_BEGIN=22;
XCB_INPUT_RAW_TOUCH_UPDATE=23;
XCB_INPUT_RAW_TOUCH_END=24;
XCB_INPUT_BARRIER_FLAGS_POINTER_RELEASED=1;
XCB_INPUT_BARRIER_FLAGS_DEVICE_IS_GRABBED=2;
XCB_INPUT_BARRIER_HIT=25;
XCB_INPUT_BARRIER_LEAVE=26;
XCB_INPUT_GESTURE_PINCH_EVENT_FLAGS_GESTURE_PINCH_CANCELLED=1;
XCB_INPUT_GESTURE_PINCH_BEGIN=27;
XCB_INPUT_GESTURE_PINCH_UPDATE=28;
XCB_INPUT_GESTURE_PINCH_END=29;
XCB_INPUT_GESTURE_SWIPE_EVENT_FLAGS_GESTURE_SWIPE_CANCELLED=1;
XCB_INPUT_GESTURE_SWIPE_BEGIN=30;
XCB_INPUT_GESTURE_SWIPE_UPDATE=31;
XCB_INPUT_GESTURE_SWIPE_END=32;
XCB_INPUT_SEND_EXTENSION_EVENT=31;
XCB_INPUT_DEVICE=0;
XCB_INPUT_EVENT=1;
XCB_INPUT_MODE=2;
XCB_INPUT_DEVICE_BUSY=3;
XCB_INPUT_CLASS=4;
// @defgroup XCB_xkb_API XCB xkb API
XCB_XKB_MAJOR_VERSION=1;
XCB_XKB_MINOR_VERSION=0;
XCB_XKB_CONST_MAX_LEGAL_KEY_CODE=255;
XCB_XKB_CONST_PER_KEY_BIT_ARRAY_SIZE=32;
XCB_XKB_CONST_KEY_NAME_LENGTH=4;
XCB_XKB_EVENT_TYPE_NEW_KEYBOARD_NOTIFY=1;
XCB_XKB_EVENT_TYPE_MAP_NOTIFY=2;
XCB_XKB_EVENT_TYPE_STATE_NOTIFY=4;
XCB_XKB_EVENT_TYPE_CONTROLS_NOTIFY=8;
XCB_XKB_EVENT_TYPE_INDICATOR_STATE_NOTIFY=16;
XCB_XKB_EVENT_TYPE_INDICATOR_MAP_NOTIFY=32;
XCB_XKB_EVENT_TYPE_NAMES_NOTIFY=64;
XCB_XKB_EVENT_TYPE_COMPAT_MAP_NOTIFY=128;
XCB_XKB_EVENT_TYPE_BELL_NOTIFY=256;
XCB_XKB_EVENT_TYPE_ACTION_MESSAGE=512;
XCB_XKB_EVENT_TYPE_ACCESS_X_NOTIFY=1024;
XCB_XKB_EVENT_TYPE_EXTENSION_DEVICE_NOTIFY=2048;
XCB_XKB_NKN_DETAIL_KEYCODES=1;
XCB_XKB_NKN_DETAIL_GEOMETRY=2;
XCB_XKB_NKN_DETAIL_DEVICE_ID=4;
XCB_XKB_AXN_DETAIL_SK_PRESS=1;
XCB_XKB_AXN_DETAIL_SK_ACCEPT=2;
XCB_XKB_AXN_DETAIL_SK_REJECT=4;
XCB_XKB_AXN_DETAIL_SK_RELEASE=8;
XCB_XKB_AXN_DETAIL_BK_ACCEPT=16;
XCB_XKB_AXN_DETAIL_BK_REJECT=32;
XCB_XKB_AXN_DETAIL_AXK_WARNING=64;
XCB_XKB_MAP_PART_KEY_TYPES=1;
XCB_XKB_MAP_PART_KEY_SYMS=2;
XCB_XKB_MAP_PART_MODIFIER_MAP=4;
XCB_XKB_MAP_PART_EXPLICIT_COMPONENTS=8;
XCB_XKB_MAP_PART_KEY_ACTIONS=16;
XCB_XKB_MAP_PART_KEY_BEHAVIORS=32;
XCB_XKB_MAP_PART_VIRTUAL_MODS=64;
XCB_XKB_MAP_PART_VIRTUAL_MOD_MAP=128;
XCB_XKB_SET_MAP_FLAGS_RESIZE_TYPES=1;
XCB_XKB_SET_MAP_FLAGS_RECOMPUTE_ACTIONS=2;
XCB_XKB_STATE_PART_MODIFIER_STATE=1;
XCB_XKB_STATE_PART_MODIFIER_BASE=2;
XCB_XKB_STATE_PART_MODIFIER_LATCH=4;
XCB_XKB_STATE_PART_MODIFIER_LOCK=8;
XCB_XKB_STATE_PART_GROUP_STATE=16;
XCB_XKB_STATE_PART_GROUP_BASE=32;
XCB_XKB_STATE_PART_GROUP_LATCH=64;
XCB_XKB_STATE_PART_GROUP_LOCK=128;
XCB_XKB_STATE_PART_COMPAT_STATE=256;
XCB_XKB_STATE_PART_GRAB_MODS=512;
XCB_XKB_STATE_PART_COMPAT_GRAB_MODS=1024;
XCB_XKB_STATE_PART_LOOKUP_MODS=2048;
XCB_XKB_STATE_PART_COMPAT_LOOKUP_MODS=4096;
XCB_XKB_STATE_PART_POINTER_BUTTONS=8192;
XCB_XKB_BOOL_CTRL_REPEAT_KEYS=1;
XCB_XKB_BOOL_CTRL_SLOW_KEYS=2;
XCB_XKB_BOOL_CTRL_BOUNCE_KEYS=4;
XCB_XKB_BOOL_CTRL_STICKY_KEYS=8;
XCB_XKB_BOOL_CTRL_MOUSE_KEYS=16;
XCB_XKB_BOOL_CTRL_MOUSE_KEYS_ACCEL=32;
XCB_XKB_BOOL_CTRL_ACCESS_X_KEYS=64;
XCB_XKB_BOOL_CTRL_ACCESS_X_TIMEOUT_MASK=128;
XCB_XKB_BOOL_CTRL_ACCESS_X_FEEDBACK_MASK=256;
XCB_XKB_BOOL_CTRL_AUDIBLE_BELL_MASK=512;
XCB_XKB_BOOL_CTRL_OVERLAY_1_MASK=1024;
XCB_XKB_BOOL_CTRL_OVERLAY_2_MASK=2048;
XCB_XKB_BOOL_CTRL_IGNORE_GROUP_LOCK_MASK=4096;
XCB_XKB_CONTROL_GROUPS_WRAP=134217728;
XCB_XKB_CONTROL_INTERNAL_MODS=268435456;
XCB_XKB_CONTROL_IGNORE_LOCK_MODS=536870912;
XCB_XKB_CONTROL_PER_KEY_REPEAT=1073741824;
XCB_XKB_CONTROL_CONTROLS_ENABLED=2147483648;
XCB_XKB_AX_OPTION_SK_PRESS_FB=1;
XCB_XKB_AX_OPTION_SK_ACCEPT_FB=2;
XCB_XKB_AX_OPTION_FEATURE_FB=4;
XCB_XKB_AX_OPTION_SLOW_WARN_FB=8;
XCB_XKB_AX_OPTION_INDICATOR_FB=16;
XCB_XKB_AX_OPTION_STICKY_KEYS_FB=32;
XCB_XKB_AX_OPTION_TWO_KEYS=64;
XCB_XKB_AX_OPTION_LATCH_TO_LOCK=128;
XCB_XKB_AX_OPTION_SK_RELEASE_FB=256;
XCB_XKB_AX_OPTION_SK_REJECT_FB=512;
XCB_XKB_AX_OPTION_BK_REJECT_FB=1024;
XCB_XKB_AX_OPTION_DUMB_BELL=2048;
XCB_XKB_LED_CLASS_RESULT_KBD_FEEDBACK_CLASS=0;
XCB_XKB_LED_CLASS_RESULT_LED_FEEDBACK_CLASS=4;
XCB_XKB_LED_CLASS_KBD_FEEDBACK_CLASS=0;
XCB_XKB_LED_CLASS_LED_FEEDBACK_CLASS=4;
XCB_XKB_LED_CLASS_DFLT_XI_CLASS=768;
XCB_XKB_LED_CLASS_ALL_XI_CLASSES=1280;
XCB_XKB_BELL_CLASS_RESULT_KBD_FEEDBACK_CLASS=0;
XCB_XKB_BELL_CLASS_RESULT_BELL_FEEDBACK_CLASS=5;
XCB_XKB_BELL_CLASS_KBD_FEEDBACK_CLASS=0;
XCB_XKB_BELL_CLASS_BELL_FEEDBACK_CLASS=5;
XCB_XKB_BELL_CLASS_DFLT_XI_CLASS=768;
XCB_XKB_ID_USE_CORE_KBD=256;
XCB_XKB_ID_USE_CORE_PTR=512;
XCB_XKB_ID_DFLT_XI_CLASS=768;
XCB_XKB_ID_DFLT_XI_ID=1024;
XCB_XKB_ID_ALL_XI_CLASS=1280;
XCB_XKB_ID_ALL_XI_ID=1536;
XCB_XKB_ID_XI_NONE=65280;
XCB_XKB_GROUP_1=0;
XCB_XKB_GROUP_2=1;
XCB_XKB_GROUP_3=2;
XCB_XKB_GROUP_4=3;
XCB_XKB_GROUPS_ANY=254;
XCB_XKB_GROUPS_ALL=255;
XCB_XKB_SET_OF_GROUP_GROUP_1=1;
XCB_XKB_SET_OF_GROUP_GROUP_2=2;
XCB_XKB_SET_OF_GROUP_GROUP_3=4;
XCB_XKB_SET_OF_GROUP_GROUP_4=8;
XCB_XKB_SET_OF_GROUPS_ANY=128;
XCB_XKB_GROUPS_WRAP_WRAP_INTO_RANGE=0;
XCB_XKB_GROUPS_WRAP_CLAMP_INTO_RANGE=64;
XCB_XKB_GROUPS_WRAP_REDIRECT_INTO_RANGE=128;
XCB_XKB_V_MODS_HIGH_15=128;
XCB_XKB_V_MODS_HIGH_14=64;
XCB_XKB_V_MODS_HIGH_13=32;
XCB_XKB_V_MODS_HIGH_12=16;
XCB_XKB_V_MODS_HIGH_11=8;
XCB_XKB_V_MODS_HIGH_10=4;
XCB_XKB_V_MODS_HIGH_9=2;
XCB_XKB_V_MODS_HIGH_8=1;
XCB_XKB_V_MODS_LOW_7=128;
XCB_XKB_V_MODS_LOW_6=64;
XCB_XKB_V_MODS_LOW_5=32;
XCB_XKB_V_MODS_LOW_4=16;
XCB_XKB_V_MODS_LOW_3=8;
XCB_XKB_V_MODS_LOW_2=4;
XCB_XKB_V_MODS_LOW_1=2;
XCB_XKB_V_MODS_LOW_0=1;
XCB_XKB_V_MOD_15=32768;
XCB_XKB_V_MOD_14=16384;
XCB_XKB_V_MOD_13=8192;
XCB_XKB_V_MOD_12=4096;
XCB_XKB_V_MOD_11=2048;
XCB_XKB_V_MOD_10=1024;
XCB_XKB_V_MOD_9=512;
XCB_XKB_V_MOD_8=256;
XCB_XKB_V_MOD_7=128;
XCB_XKB_V_MOD_6=64;
XCB_XKB_V_MOD_5=32;
XCB_XKB_V_MOD_4=16;
XCB_XKB_V_MOD_3=8;
XCB_XKB_V_MOD_2=4;
XCB_XKB_V_MOD_1=2;
XCB_XKB_V_MOD_0=1;
XCB_XKB_EXPLICIT_V_MOD_MAP=128;
XCB_XKB_EXPLICIT_BEHAVIOR=64;
XCB_XKB_EXPLICIT_AUTO_REPEAT=32;
XCB_XKB_EXPLICIT_INTERPRET=16;
XCB_XKB_EXPLICIT_KEY_TYPE_4=8;
XCB_XKB_EXPLICIT_KEY_TYPE_3=4;
XCB_XKB_EXPLICIT_KEY_TYPE_2=2;
XCB_XKB_EXPLICIT_KEY_TYPE_1=1;
XCB_XKB_SYM_INTERPRET_MATCH_NONE_OF=0;
XCB_XKB_SYM_INTERPRET_MATCH_ANY_OF_OR_NONE=1;
XCB_XKB_SYM_INTERPRET_MATCH_ANY_OF=2;
XCB_XKB_SYM_INTERPRET_MATCH_ALL_OF=3;
XCB_XKB_SYM_INTERPRET_MATCH_EXACTLY=4;
XCB_XKB_SYM_INTERP_MATCH_LEVEL_ONE_ONLY=128;
XCB_XKB_SYM_INTERP_MATCH_OP_MASK=127;
XCB_XKB_IM_FLAG_NO_EXPLICIT=128;
XCB_XKB_IM_FLAG_NO_AUTOMATIC=64;
XCB_XKB_IM_FLAG_LED_DRIVES_KB=32;
XCB_XKB_IM_MODS_WHICH_USE_COMPAT=16;
XCB_XKB_IM_MODS_WHICH_USE_EFFECTIVE=8;
XCB_XKB_IM_MODS_WHICH_USE_LOCKED=4;
XCB_XKB_IM_MODS_WHICH_USE_LATCHED=2;
XCB_XKB_IM_MODS_WHICH_USE_BASE=1;
XCB_XKB_IM_GROUPS_WHICH_USE_COMPAT=16;
XCB_XKB_IM_GROUPS_WHICH_USE_EFFECTIVE=8;
XCB_XKB_IM_GROUPS_WHICH_USE_LOCKED=4;
XCB_XKB_IM_GROUPS_WHICH_USE_LATCHED=2;
XCB_XKB_IM_GROUPS_WHICH_USE_BASE=1;
XCB_XKB_CM_DETAIL_SYM_INTERP=1;
XCB_XKB_CM_DETAIL_GROUP_COMPAT=2;
XCB_XKB_NAME_DETAIL_KEYCODES=1;
XCB_XKB_NAME_DETAIL_GEOMETRY=2;
XCB_XKB_NAME_DETAIL_SYMBOLS=4;
XCB_XKB_NAME_DETAIL_PHYS_SYMBOLS=8;
XCB_XKB_NAME_DETAIL_TYPES=16;
XCB_XKB_NAME_DETAIL_COMPAT=32;
XCB_XKB_NAME_DETAIL_KEY_TYPE_NAMES=64;
XCB_XKB_NAME_DETAIL_KT_LEVEL_NAMES=128;
XCB_XKB_NAME_DETAIL_INDICATOR_NAMES=256;
XCB_XKB_NAME_DETAIL_KEY_NAMES=512;
XCB_XKB_NAME_DETAIL_KEY_ALIASES=1024;
XCB_XKB_NAME_DETAIL_VIRTUAL_MOD_NAMES=2048;
XCB_XKB_NAME_DETAIL_GROUP_NAMES=4096;
XCB_XKB_NAME_DETAIL_RG_NAMES=8192;
XCB_XKB_GBN_DETAIL_TYPES=1;
XCB_XKB_GBN_DETAIL_COMPAT_MAP=2;
XCB_XKB_GBN_DETAIL_CLIENT_SYMBOLS=4;
XCB_XKB_GBN_DETAIL_SERVER_SYMBOLS=8;
XCB_XKB_GBN_DETAIL_INDICATOR_MAPS=16;
XCB_XKB_GBN_DETAIL_KEY_NAMES=32;
XCB_XKB_GBN_DETAIL_GEOMETRY=64;
XCB_XKB_GBN_DETAIL_OTHER_NAMES=128;
XCB_XKB_XI_FEATURE_KEYBOARDS=1;
XCB_XKB_XI_FEATURE_BUTTON_ACTIONS=2;
XCB_XKB_XI_FEATURE_INDICATOR_NAMES=4;
XCB_XKB_XI_FEATURE_INDICATOR_MAPS=8;
XCB_XKB_XI_FEATURE_INDICATOR_STATE=16;
XCB_XKB_PER_CLIENT_FLAG_DETECTABLE_AUTO_REPEAT=1;
XCB_XKB_PER_CLIENT_FLAG_GRABS_USE_XKB_STATE=2;
XCB_XKB_PER_CLIENT_FLAG_AUTO_RESET_CONTROLS=4;
XCB_XKB_PER_CLIENT_FLAG_LOOKUP_STATE_WHEN_GRABBED=8;
XCB_XKB_PER_CLIENT_FLAG_SEND_EVENT_USES_XKB_STATE=16;
XCB_XKB_BEHAVIOR_TYPE_DEFAULT=0;
XCB_XKB_BEHAVIOR_TYPE_LOCK=1;
XCB_XKB_BEHAVIOR_TYPE_RADIO_GROUP=2;
XCB_XKB_BEHAVIOR_TYPE_OVERLAY_1=3;
XCB_XKB_BEHAVIOR_TYPE_OVERLAY_2=4;
XCB_XKB_BEHAVIOR_TYPE_PERMAMENT_LOCK=129;
XCB_XKB_BEHAVIOR_TYPE_PERMAMENT_RADIO_GROUP=130;
XCB_XKB_BEHAVIOR_TYPE_PERMAMENT_OVERLAY_1=131;
XCB_XKB_BEHAVIOR_TYPE_PERMAMENT_OVERLAY_2=132;
XCB_XKB_DOODAD_TYPE_OUTLINE=1;
XCB_XKB_DOODAD_TYPE_SOLID=2;
XCB_XKB_DOODAD_TYPE_TEXT=3;
XCB_XKB_DOODAD_TYPE_INDICATOR=4;
XCB_XKB_DOODAD_TYPE_LOGO=5;
XCB_XKB_ERROR_BAD_DEVICE=255;
XCB_XKB_ERROR_BAD_CLASS=254;
XCB_XKB_ERROR_BAD_ID=253;
XCB_XKB_KEYBOARD=0;
XCB_XKB_SA_CLEAR_LOCKS=1;
XCB_XKB_SA_LATCH_TO_LOCK=2;
XCB_XKB_SA_USE_MOD_MAP_MODS=4;
XCB_XKB_SA_GROUP_ABSOLUTE=4;
XCB_XKB_SA_TYPE_NO_ACTION=0;
XCB_XKB_SA_TYPE_SET_MODS=1;
XCB_XKB_SA_TYPE_LATCH_MODS=2;
XCB_XKB_SA_TYPE_LOCK_MODS=3;
XCB_XKB_SA_TYPE_SET_GROUP=4;
XCB_XKB_SA_TYPE_LATCH_GROUP=5;
XCB_XKB_SA_TYPE_LOCK_GROUP=6;
XCB_XKB_SA_TYPE_MOVE_PTR=7;
XCB_XKB_SA_TYPE_PTR_BTN=8;
XCB_XKB_SA_TYPE_LOCK_PTR_BTN=9;
XCB_XKB_SA_TYPE_SET_PTR_DFLT=10;
XCB_XKB_SA_TYPE_ISO_LOCK=11;
XCB_XKB_SA_TYPE_TERMINATE=12;
XCB_XKB_SA_TYPE_SWITCH_SCREEN=13;
XCB_XKB_SA_TYPE_SET_CONTROLS=14;
XCB_XKB_SA_TYPE_LOCK_CONTROLS=15;
XCB_XKB_SA_TYPE_ACTION_MESSAGE=16;
XCB_XKB_SA_TYPE_REDIRECT_KEY=17;
XCB_XKB_SA_TYPE_DEVICE_BTN=18;
XCB_XKB_SA_TYPE_LOCK_DEVICE_BTN=19;
XCB_XKB_SA_TYPE_DEVICE_VALUATOR=20;
XCB_XKB_SA_MOVE_PTR_FLAG_NO_ACCELERATION=1;
XCB_XKB_SA_MOVE_PTR_FLAG_MOVE_ABSOLUTE_X=2;
XCB_XKB_SA_MOVE_PTR_FLAG_MOVE_ABSOLUTE_Y=4;
XCB_XKB_SA_SET_PTR_DFLT_FLAG_DFLT_BTN_ABSOLUTE=4;
XCB_XKB_SA_SET_PTR_DFLT_FLAG_AFFECT_DFLT_BUTTON=1;
XCB_XKB_SA_ISO_LOCK_FLAG_NO_LOCK=1;
XCB_XKB_SA_ISO_LOCK_FLAG_NO_UNLOCK=2;
XCB_XKB_SA_ISO_LOCK_FLAG_USE_MOD_MAP_MODS=4;
XCB_XKB_SA_ISO_LOCK_FLAG_GROUP_ABSOLUTE=4;
XCB_XKB_SA_ISO_LOCK_FLAG_ISO_DFLT_IS_GROUP=8;
XCB_XKB_SA_ISO_LOCK_NO_AFFECT_CTRLS=8;
XCB_XKB_SA_ISO_LOCK_NO_AFFECT_PTR=16;
XCB_XKB_SA_ISO_LOCK_NO_AFFECT_GROUP=32;
XCB_XKB_SA_ISO_LOCK_NO_AFFECT_MODS=64;
XCB_XKB_SWITCH_SCREEN_FLAG_APPLICATION=1;
XCB_XKB_SWITCH_SCREEN_FLAG_ABSOLUTE=4;
XCB_XKB_BOOL_CTRLS_HIGH_ACCESS_X_FEEDBACK=1;
XCB_XKB_BOOL_CTRLS_HIGH_AUDIBLE_BELL=2;
XCB_XKB_BOOL_CTRLS_HIGH_OVERLAY_1=4;
XCB_XKB_BOOL_CTRLS_HIGH_OVERLAY_2=8;
XCB_XKB_BOOL_CTRLS_HIGH_IGNORE_GROUP_LOCK=16;
XCB_XKB_BOOL_CTRLS_LOW_REPEAT_KEYS=1;
XCB_XKB_BOOL_CTRLS_LOW_SLOW_KEYS=2;
XCB_XKB_BOOL_CTRLS_LOW_BOUNCE_KEYS=4;
XCB_XKB_BOOL_CTRLS_LOW_STICKY_KEYS=8;
XCB_XKB_BOOL_CTRLS_LOW_MOUSE_KEYS=16;
XCB_XKB_BOOL_CTRLS_LOW_MOUSE_KEYS_ACCEL=32;
XCB_XKB_BOOL_CTRLS_LOW_ACCESS_X_KEYS=64;
XCB_XKB_BOOL_CTRLS_LOW_ACCESS_X_TIMEOUT=128;
XCB_XKB_ACTION_MESSAGE_FLAG_ON_PRESS=1;
XCB_XKB_ACTION_MESSAGE_FLAG_ON_RELEASE=2;
XCB_XKB_ACTION_MESSAGE_FLAG_GEN_KEY_EVENT=4;
XCB_XKB_LOCK_DEVICE_FLAGS_NO_LOCK=1;
XCB_XKB_LOCK_DEVICE_FLAGS_NO_UNLOCK=2;
XCB_XKB_SA_VAL_WHAT_IGNORE_VAL=0;
XCB_XKB_SA_VAL_WHAT_SET_VAL_MIN=1;
XCB_XKB_SA_VAL_WHAT_SET_VAL_CENTER=2;
XCB_XKB_SA_VAL_WHAT_SET_VAL_MAX=3;
XCB_XKB_SA_VAL_WHAT_SET_VAL_RELATIVE=4;
XCB_XKB_SA_VAL_WHAT_SET_VAL_ABSOLUTE=5;
XCB_XKB_USE_EXTENSION=0;
XCB_XKB_SELECT_EVENTS=1;
XCB_XKB_BELL=3;
XCB_XKB_GET_STATE=4;
XCB_XKB_LATCH_LOCK_STATE=5;
XCB_XKB_GET_CONTROLS=6;
XCB_XKB_SET_CONTROLS=7;
XCB_XKB_GET_MAP=8;
XCB_XKB_SET_MAP=9;
XCB_XKB_GET_COMPAT_MAP=10;
XCB_XKB_SET_COMPAT_MAP=11;
XCB_XKB_GET_INDICATOR_STATE=12;
XCB_XKB_GET_INDICATOR_MAP=13;
XCB_XKB_SET_INDICATOR_MAP=14;
XCB_XKB_GET_NAMED_INDICATOR=15;
XCB_XKB_SET_NAMED_INDICATOR=16;
XCB_XKB_GET_NAMES=17;
XCB_XKB_SET_NAMES=18;
XCB_XKB_PER_CLIENT_FLAGS=21;
XCB_XKB_LIST_COMPONENTS=22;
XCB_XKB_GET_KBD_BY_NAME=23;
XCB_XKB_GET_DEVICE_INFO=24;
XCB_XKB_SET_DEVICE_INFO=25;
XCB_XKB_SET_DEBUGGING_FLAGS=101;
XCB_XKB_NEW_KEYBOARD_NOTIFY=0;
XCB_XKB_MAP_NOTIFY=1;
XCB_XKB_STATE_NOTIFY=2;
XCB_XKB_CONTROLS_NOTIFY=3;
XCB_XKB_INDICATOR_STATE_NOTIFY=4;
XCB_XKB_INDICATOR_MAP_NOTIFY=5;
XCB_XKB_NAMES_NOTIFY=6;
XCB_XKB_COMPAT_MAP_NOTIFY=7;
XCB_XKB_BELL_NOTIFY=8;
XCB_XKB_ACTION_MESSAGE=9;
XCB_XKB_ACCESS_X_NOTIFY=10;
XCB_XKB_EXTENSION_DEVICE_NOTIFY=11;
// @defgroup XCB__API XCB  API
XCB_VISUAL_CLASS_STATIC_GRAY=0;
XCB_VISUAL_CLASS_GRAY_SCALE=1;
XCB_VISUAL_CLASS_STATIC_COLOR=2;
XCB_VISUAL_CLASS_PSEUDO_COLOR=3;
XCB_VISUAL_CLASS_TRUE_COLOR=4;
XCB_VISUAL_CLASS_DIRECT_COLOR=5;
XCB_EVENT_MASK_NO_EVENT=0;
XCB_EVENT_MASK_KEY_PRESS=1;
XCB_EVENT_MASK_KEY_RELEASE=2;
XCB_EVENT_MASK_BUTTON_PRESS=4;
XCB_EVENT_MASK_BUTTON_RELEASE=8;
XCB_EVENT_MASK_ENTER_WINDOW=16;
XCB_EVENT_MASK_LEAVE_WINDOW=32;
XCB_EVENT_MASK_POINTER_MOTION=64;
XCB_EVENT_MASK_POINTER_MOTION_HINT=128;
XCB_EVENT_MASK_BUTTON_1_MOTION=256;
XCB_EVENT_MASK_BUTTON_2_MOTION=512;
XCB_EVENT_MASK_BUTTON_3_MOTION=1024;
XCB_EVENT_MASK_BUTTON_4_MOTION=2048;
XCB_EVENT_MASK_BUTTON_5_MOTION=4096;
XCB_EVENT_MASK_BUTTON_MOTION=8192;
XCB_EVENT_MASK_KEYMAP_STATE=16384;
XCB_EVENT_MASK_EXPOSURE=32768;
XCB_EVENT_MASK_VISIBILITY_CHANGE=65536;
XCB_EVENT_MASK_STRUCTURE_NOTIFY=131072;
XCB_EVENT_MASK_RESIZE_REDIRECT=262144;
XCB_EVENT_MASK_SUBSTRUCTURE_NOTIFY=524288;
XCB_EVENT_MASK_SUBSTRUCTURE_REDIRECT=1048576;
XCB_EVENT_MASK_FOCUS_CHANGE=2097152;
XCB_EVENT_MASK_PROPERTY_CHANGE=4194304;
XCB_EVENT_MASK_COLOR_MAP_CHANGE=8388608;
XCB_EVENT_MASK_OWNER_GRAB_BUTTON=16777216;
XCB_BACKING_STORE_NOT_USEFUL=0;
XCB_BACKING_STORE_WHEN_MAPPED=1;
XCB_BACKING_STORE_ALWAYS=2;
XCB_IMAGE_ORDER_LSB_FIRST=0;
XCB_IMAGE_ORDER_MSB_FIRST=1;
XCB_MOD_MASK_SHIFT=1;
XCB_MOD_MASK_LOCK=2;
XCB_MOD_MASK_CONTROL=4;
XCB_MOD_MASK_1=8;
XCB_MOD_MASK_2=16;
XCB_MOD_MASK_3=32;
XCB_MOD_MASK_4=64;
XCB_MOD_MASK_5=128;
XCB_MOD_MASK_ANY=32768;
XCB_KEY_BUT_MASK_SHIFT=1;
XCB_KEY_BUT_MASK_LOCK=2;
XCB_KEY_BUT_MASK_CONTROL=4;
XCB_KEY_BUT_MASK_MOD_1=8;
XCB_KEY_BUT_MASK_MOD_2=16;
XCB_KEY_BUT_MASK_MOD_3=32;
XCB_KEY_BUT_MASK_MOD_4=64;
XCB_KEY_BUT_MASK_MOD_5=128;
XCB_KEY_BUT_MASK_BUTTON_1=256;
XCB_KEY_BUT_MASK_BUTTON_2=512;
XCB_KEY_BUT_MASK_BUTTON_3=1024;
XCB_KEY_BUT_MASK_BUTTON_4=2048;
XCB_KEY_BUT_MASK_BUTTON_5=4096;
XCB_WINDOW_NONE=0;
XCB_KEY_PRESS=2;
XCB_KEY_RELEASE=3;
XCB_BUTTON_MASK_1=256;
XCB_BUTTON_MASK_2=512;
XCB_BUTTON_MASK_3=1024;
XCB_BUTTON_MASK_4=2048;
XCB_BUTTON_MASK_5=4096;
XCB_BUTTON_MASK_ANY=32768;
XCB_BUTTON_PRESS=4;
XCB_BUTTON_RELEASE=5;
XCB_MOTION_NORMAL=0;
XCB_MOTION_HINT=1;
XCB_MOTION_NOTIFY=6;
XCB_NOTIFY_DETAIL_ANCESTOR=0;
XCB_NOTIFY_DETAIL_VIRTUAL=1;
XCB_NOTIFY_DETAIL_INFERIOR=2;
XCB_NOTIFY_DETAIL_NONLINEAR=3;
XCB_NOTIFY_DETAIL_NONLINEAR_VIRTUAL=4;
XCB_NOTIFY_DETAIL_POINTER=5;
XCB_NOTIFY_DETAIL_POINTER_ROOT=6;
XCB_NOTIFY_DETAIL_NONE=7;
XCB_NOTIFY_MODE_NORMAL=0;
XCB_NOTIFY_MODE_GRAB=1;
XCB_NOTIFY_MODE_UNGRAB=2;
XCB_NOTIFY_MODE_WHILE_GRABBED=3;
XCB_ENTER_NOTIFY=7;
XCB_LEAVE_NOTIFY=8;
XCB_FOCUS_IN=9;
XCB_FOCUS_OUT=10;
XCB_KEYMAP_NOTIFY=11;
XCB_EXPOSE=12;
XCB_GRAPHICS_EXPOSURE=13;
XCB_NO_EXPOSURE=14;
XCB_VISIBILITY_UNOBSCURED=0;
XCB_VISIBILITY_PARTIALLY_OBSCURED=1;
XCB_VISIBILITY_FULLY_OBSCURED=2;
XCB_VISIBILITY_NOTIFY=15;
XCB_CREATE_NOTIFY=16;
XCB_DESTROY_NOTIFY=17;
XCB_UNMAP_NOTIFY=18;
XCB_MAP_NOTIFY=19;
XCB_MAP_REQUEST=20;
XCB_REPARENT_NOTIFY=21;
XCB_CONFIGURE_NOTIFY=22;
XCB_CONFIGURE_REQUEST=23;
XCB_GRAVITY_NOTIFY=24;
XCB_RESIZE_REQUEST=25;
XCB_PLACE_ON_TOP=0;
XCB_PLACE_ON_BOTTOM=1;
XCB_CIRCULATE_NOTIFY=26;
XCB_CIRCULATE_REQUEST=27;
XCB_PROPERTY_NEW_VALUE=0;
XCB_PROPERTY_DELETE=1;
XCB_PROPERTY_NOTIFY=28;
XCB_SELECTION_CLEAR=29;
XCB_TIME_CURRENT_TIME=0;
XCB_ATOM_NONE=0;
XCB_ATOM_ANY=0;
XCB_ATOM_PRIMARY=1;
XCB_ATOM_SECONDARY=2;
XCB_ATOM_ARC=3;
XCB_ATOM_ATOM=4;
XCB_ATOM_BITMAP=5;
XCB_ATOM_CARDINAL=6;
XCB_ATOM_COLORMAP=7;
XCB_ATOM_CURSOR=8;
XCB_ATOM_CUT_BUFFER0=9;
XCB_ATOM_CUT_BUFFER1=10;
XCB_ATOM_CUT_BUFFER2=11;
XCB_ATOM_CUT_BUFFER3=12;
XCB_ATOM_CUT_BUFFER4=13;
XCB_ATOM_CUT_BUFFER5=14;
XCB_ATOM_CUT_BUFFER6=15;
XCB_ATOM_CUT_BUFFER7=16;
XCB_ATOM_DRAWABLE=17;
XCB_ATOM_FONT=18;
XCB_ATOM_INTEGER=19;
XCB_ATOM_PIXMAP=20;
XCB_ATOM_POINT=21;
XCB_ATOM_RECTANGLE=22;
XCB_ATOM_RESOURCE_MANAGER=23;
XCB_ATOM_RGB_COLOR_MAP=24;
XCB_ATOM_RGB_BEST_MAP=25;
XCB_ATOM_RGB_BLUE_MAP=26;
XCB_ATOM_RGB_DEFAULT_MAP=27;
XCB_ATOM_RGB_GRAY_MAP=28;
XCB_ATOM_RGB_GREEN_MAP=29;
XCB_ATOM_RGB_RED_MAP=30;
XCB_ATOM_STRING=31;
XCB_ATOM_VISUALID=32;
XCB_ATOM_WINDOW=33;
XCB_ATOM_WM_COMMAND=34;
XCB_ATOM_WM_HINTS=35;
XCB_ATOM_WM_CLIENT_MACHINE=36;
XCB_ATOM_WM_ICON_NAME=37;
XCB_ATOM_WM_ICON_SIZE=38;
XCB_ATOM_WM_NAME=39;
XCB_ATOM_WM_NORMAL_HINTS=40;
XCB_ATOM_WM_SIZE_HINTS=41;
XCB_ATOM_WM_ZOOM_HINTS=42;
XCB_ATOM_MIN_SPACE=43;
XCB_ATOM_NORM_SPACE=44;
XCB_ATOM_MAX_SPACE=45;
XCB_ATOM_END_SPACE=46;
XCB_ATOM_SUPERSCRIPT_X=47;
XCB_ATOM_SUPERSCRIPT_Y=48;
XCB_ATOM_SUBSCRIPT_X=49;
XCB_ATOM_SUBSCRIPT_Y=50;
XCB_ATOM_UNDERLINE_POSITION=51;
XCB_ATOM_UNDERLINE_THICKNESS=52;
XCB_ATOM_STRIKEOUT_ASCENT=53;
XCB_ATOM_STRIKEOUT_DESCENT=54;
XCB_ATOM_ITALIC_ANGLE=55;
XCB_ATOM_X_HEIGHT=56;
XCB_ATOM_QUAD_WIDTH=57;
XCB_ATOM_WEIGHT=58;
XCB_ATOM_POINT_SIZE=59;
XCB_ATOM_RESOLUTION=60;
XCB_ATOM_COPYRIGHT=61;
XCB_ATOM_NOTICE=62;
XCB_ATOM_FONT_NAME=63;
XCB_ATOM_FAMILY_NAME=64;
XCB_ATOM_FULL_NAME=65;
XCB_ATOM_CAP_HEIGHT=66;
XCB_ATOM_WM_CLASS=67;
XCB_ATOM_WM_TRANSIENT_FOR=68;
XCB_SELECTION_REQUEST=30;
XCB_SELECTION_NOTIFY=31;
XCB_COLORMAP_STATE_UNINSTALLED=0;
XCB_COLORMAP_STATE_INSTALLED=1;
XCB_COLORMAP_NONE=0;
XCB_COLORMAP_NOTIFY=32;
XCB_CLIENT_MESSAGE=33;
XCB_MAPPING_MODIFIER=0;
XCB_MAPPING_KEYBOARD=1;
XCB_MAPPING_POINTER=2;
XCB_MAPPING_NOTIFY=34;
XCB_GE_GENERIC=35;
XCB_REQUEST=1;
XCB_VALUE=2;
XCB_WINDOW=3;
XCB_PIXMAP=4;
XCB_ATOM=5;
XCB_CURSOR=6;
XCB_FONT=7;
XCB_MATCH=8;
XCB_DRAWABLE=9;
XCB_ACCESS=10;
XCB_ALLOC=11;
XCB_COLORMAP=12;
XCB_G_CONTEXT=13;
XCB_ID_CHOICE=14;
XCB_NAME=15;
XCB_LENGTH=16;
XCB_IMPLEMENTATION=17;
XCB_WINDOW_CLASS_COPY_FROM_PARENT=0;
XCB_WINDOW_CLASS_INPUT_OUTPUT=1;
XCB_WINDOW_CLASS_INPUT_ONLY=2;
XCB_CW_BACK_PIXMAP=1;
XCB_CW_BACK_PIXEL=2;
XCB_CW_BORDER_PIXMAP=4;
XCB_CW_BORDER_PIXEL=8;
XCB_CW_BIT_GRAVITY=16;
XCB_CW_WIN_GRAVITY=32;
XCB_CW_BACKING_STORE=64;
XCB_CW_BACKING_PLANES=128;
XCB_CW_BACKING_PIXEL=256;
XCB_CW_OVERRIDE_REDIRECT=512;
XCB_CW_SAVE_UNDER=1024;
XCB_CW_EVENT_MASK=2048;
XCB_CW_DONT_PROPAGATE=4096;
XCB_CW_COLORMAP=8192;
XCB_CW_CURSOR=16384;
XCB_BACK_PIXMAP_NONE=0;
XCB_BACK_PIXMAP_PARENT_RELATIVE=1;
XCB_GRAVITY_BIT_FORGET=0;
XCB_GRAVITY_WIN_UNMAP=0;
XCB_GRAVITY_NORTH_WEST=1;
XCB_GRAVITY_NORTH=2;
XCB_GRAVITY_NORTH_EAST=3;
XCB_GRAVITY_WEST=4;
XCB_GRAVITY_CENTER=5;
XCB_GRAVITY_EAST=6;
XCB_GRAVITY_SOUTH_WEST=7;
XCB_GRAVITY_SOUTH=8;
XCB_GRAVITY_SOUTH_EAST=9;
XCB_GRAVITY_STATIC=10;
CONST_XCB_CREATE_WINDOW=1;
CONST_XCB_CHANGE_WINDOW_ATTRIBUTES=2;
XCB_MAP_STATE_UNMAPPED=0;
XCB_MAP_STATE_UNVIEWABLE=1;
XCB_MAP_STATE_VIEWABLE=2;
XCB_GET_WINDOW_ATTRIBUTES=3;
XCB_DESTROY_WINDOW=4;
XCB_DESTROY_SUBWINDOWS=5;
XCB_SET_MODE_INSERT=0;
XCB_SET_MODE_DELETE=1;
XCB_CHANGE_SAVE_SET=6;
XCB_REPARENT_WINDOW=7;
CONST_XCB_MAP_WINDOW=8;
XCB_MAP_SUBWINDOWS=9;
XCB_UNMAP_WINDOW=10;
XCB_UNMAP_SUBWINDOWS=11;
XCB_CONFIG_WINDOW_X=1;
XCB_CONFIG_WINDOW_Y=2;
XCB_CONFIG_WINDOW_WIDTH=4;
XCB_CONFIG_WINDOW_HEIGHT=8;
XCB_CONFIG_WINDOW_BORDER_WIDTH=16;
XCB_CONFIG_WINDOW_SIBLING=32;
XCB_CONFIG_WINDOW_STACK_MODE=64;
XCB_STACK_MODE_ABOVE=0;
XCB_STACK_MODE_BELOW=1;
XCB_STACK_MODE_TOP_IF=2;
XCB_STACK_MODE_BOTTOM_IF=3;
XCB_STACK_MODE_OPPOSITE=4;
XCB_CONFIGURE_WINDOW=12;
XCB_CIRCULATE_RAISE_LOWEST=0;
XCB_CIRCULATE_LOWER_HIGHEST=1;
XCB_CIRCULATE_WINDOW=13;
XCB_GET_GEOMETRY=14;
XCB_QUERY_TREE=15;
CONST_XCB_INTERN_ATOM=16;
XCB_GET_ATOM_NAME=17;
XCB_PROP_MODE_REPLACE=0;
XCB_PROP_MODE_PREPEND=1;
XCB_PROP_MODE_APPEND=2;
CONST_XCB_CHANGE_PROPERTY=18;
XCB_DELETE_PROPERTY=19;
XCB_GET_PROPERTY_TYPE_ANY=0;
XCB_GET_PROPERTY=20;
XCB_LIST_PROPERTIES=21;
XCB_SET_SELECTION_OWNER=22;
XCB_GET_SELECTION_OWNER=23;
XCB_CONVERT_SELECTION=24;
XCB_SEND_EVENT_DEST_POINTER_WINDOW=0;
XCB_SEND_EVENT_DEST_ITEM_FOCUS=1;
XCB_SEND_EVENT=25;
XCB_GRAB_MODE_SYNC=0;
XCB_GRAB_MODE_ASYNC=1;
XCB_GRAB_STATUS_SUCCESS=0;
XCB_GRAB_STATUS_ALREADY_GRABBED=1;
XCB_GRAB_STATUS_INVALID_TIME=2;
XCB_GRAB_STATUS_NOT_VIEWABLE=3;
XCB_GRAB_STATUS_FROZEN=4;
XCB_CURSOR_NONE=0;
XCB_GRAB_POINTER=26;
XCB_UNGRAB_POINTER=27;
XCB_BUTTON_INDEX_ANY=0;
XCB_BUTTON_INDEX_1=1;
XCB_BUTTON_INDEX_2=2;
XCB_BUTTON_INDEX_3=3;
XCB_BUTTON_INDEX_4=4;
XCB_BUTTON_INDEX_5=5;
XCB_GRAB_BUTTON=28;
XCB_UNGRAB_BUTTON=29;
XCB_CHANGE_ACTIVE_POINTER_GRAB=30;
XCB_GRAB_KEYBOARD=31;
XCB_UNGRAB_KEYBOARD=32;
XCB_GRAB_ANY=0;
XCB_GRAB_KEY=33;
XCB_UNGRAB_KEY=34;
XCB_ALLOW_ASYNC_POINTER=0;
XCB_ALLOW_SYNC_POINTER=1;
XCB_ALLOW_REPLAY_POINTER=2;
XCB_ALLOW_ASYNC_KEYBOARD=3;
XCB_ALLOW_SYNC_KEYBOARD=4;
XCB_ALLOW_REPLAY_KEYBOARD=5;
XCB_ALLOW_ASYNC_BOTH=6;
XCB_ALLOW_SYNC_BOTH=7;
XCB_ALLOW_EVENTS=35;
XCB_GRAB_SERVER=36;
XCB_UNGRAB_SERVER=37;
XCB_QUERY_POINTER=38;
XCB_GET_MOTION_EVENTS=39;
XCB_TRANSLATE_COORDINATES=40;
XCB_WARP_POINTER=41;
XCB_INPUT_FOCUS_NONE=0;
XCB_INPUT_FOCUS_POINTER_ROOT=1;
XCB_INPUT_FOCUS_PARENT=2;
XCB_INPUT_FOCUS_FOLLOW_KEYBOARD=3;
XCB_SET_INPUT_FOCUS=42;
XCB_GET_INPUT_FOCUS=43;
XCB_QUERY_KEYMAP=44;
XCB_OPEN_FONT=45;
XCB_CLOSE_FONT=46;
XCB_FONT_DRAW_LEFT_TO_RIGHT=0;
XCB_FONT_DRAW_RIGHT_TO_LEFT=1;
XCB_QUERY_FONT=47;
XCB_QUERY_TEXT_EXTENTS=48;
XCB_LIST_FONTS=49;
XCB_LIST_FONTS_WITH_INFO=50;
XCB_SET_FONT_PATH=51;
XCB_GET_FONT_PATH=52;
XCB_CREATE_PIXMAP=53;
XCB_FREE_PIXMAP=54;
XCB_GC_FUNCTION=1;
XCB_GC_PLANE_MASK=2;
XCB_GC_FOREGROUND=4;
XCB_GC_BACKGROUND=8;
XCB_GC_LINE_WIDTH=16;
XCB_GC_LINE_STYLE=32;
XCB_GC_CAP_STYLE=64;
XCB_GC_JOIN_STYLE=128;
XCB_GC_FILL_STYLE=256;
XCB_GC_FILL_RULE=512;
XCB_GC_TILE=1024;
XCB_GC_STIPPLE=2048;
XCB_GC_TILE_STIPPLE_ORIGIN_X=4096;
XCB_GC_TILE_STIPPLE_ORIGIN_Y=8192;
XCB_GC_FONT=16384;
XCB_GC_SUBWINDOW_MODE=32768;
XCB_GC_GRAPHICS_EXPOSURES=65536;
XCB_GC_CLIP_ORIGIN_X=131072;
XCB_GC_CLIP_ORIGIN_Y=262144;
XCB_GC_CLIP_MASK=524288;
XCB_GC_DASH_OFFSET=1048576;
XCB_GC_DASH_LIST=2097152;
XCB_GC_ARC_MODE=4194304;
XCB_GX_CLEAR=0;
XCB_GX_AND=1;
XCB_GX_AND_REVERSE=2;
XCB_GX_COPY=3;
XCB_GX_AND_INVERTED=4;
XCB_GX_NOOP=5;
XCB_GX_XOR=6;
XCB_GX_OR=7;
XCB_GX_NOR=8;
XCB_GX_EQUIV=9;
XCB_GX_INVERT=10;
XCB_GX_OR_REVERSE=11;
XCB_GX_COPY_INVERTED=12;
XCB_GX_OR_INVERTED=13;
XCB_GX_NAND=14;
XCB_GX_SET=15;
XCB_LINE_STYLE_SOLID=0;
XCB_LINE_STYLE_ON_OFF_DASH=1;
XCB_LINE_STYLE_DOUBLE_DASH=2;
XCB_CAP_STYLE_NOT_LAST=0;
XCB_CAP_STYLE_BUTT=1;
XCB_CAP_STYLE_ROUND=2;
XCB_CAP_STYLE_PROJECTING=3;
XCB_JOIN_STYLE_MITER=0;
XCB_JOIN_STYLE_ROUND=1;
XCB_JOIN_STYLE_BEVEL=2;
XCB_FILL_STYLE_SOLID=0;
XCB_FILL_STYLE_TILED=1;
XCB_FILL_STYLE_STIPPLED=2;
XCB_FILL_STYLE_OPAQUE_STIPPLED=3;
XCB_FILL_RULE_EVEN_ODD=0;
XCB_FILL_RULE_WINDING=1;
XCB_SUBWINDOW_MODE_CLIP_BY_CHILDREN=0;
XCB_SUBWINDOW_MODE_INCLUDE_INFERIORS=1;
XCB_ARC_MODE_CHORD=0;
XCB_ARC_MODE_PIE_SLICE=1;
XCB_CREATE_GC=55;
XCB_CHANGE_GC=56;
XCB_COPY_GC=57;
XCB_SET_DASHES=58;
XCB_CLIP_ORDERING_UNSORTED=0;
XCB_CLIP_ORDERING_Y_SORTED=1;
XCB_CLIP_ORDERING_YX_SORTED=2;
XCB_CLIP_ORDERING_YX_BANDED=3;
XCB_SET_CLIP_RECTANGLES=59;
XCB_FREE_GC=60;
XCB_CLEAR_AREA=61;
XCB_COPY_AREA=62;
XCB_COPY_PLANE=63;
XCB_COORD_MODE_ORIGIN=0;
XCB_COORD_MODE_PREVIOUS=1;
XCB_POLY_POINT=64;
XCB_POLY_LINE=65;
XCB_POLY_SEGMENT=66;
XCB_POLY_RECTANGLE=67;
XCB_POLY_ARC=68;
XCB_POLY_SHAPE_COMPLEX=0;
XCB_POLY_SHAPE_NONCONVEX=1;
XCB_POLY_SHAPE_CONVEX=2;
XCB_FILL_POLY=69;
XCB_POLY_FILL_RECTANGLE=70;
XCB_POLY_FILL_ARC=71;
XCB_IMAGE_FORMAT_XY_BITMAP=0;
XCB_IMAGE_FORMAT_XY_PIXMAP=1;
XCB_IMAGE_FORMAT_Z_PIXMAP=2;
XCB_PUT_IMAGE=72;
XCB_GET_IMAGE=73;
XCB_POLY_TEXT_8=74;
XCB_POLY_TEXT_16=75;
XCB_IMAGE_TEXT_8=76;
XCB_IMAGE_TEXT_16=77;
XCB_COLORMAP_ALLOC_NONE=0;
XCB_COLORMAP_ALLOC_ALL=1;
XCB_CREATE_COLORMAP=78;
XCB_FREE_COLORMAP=79;
XCB_COPY_COLORMAP_AND_FREE=80;
XCB_INSTALL_COLORMAP=81;
XCB_UNINSTALL_COLORMAP=82;
XCB_LIST_INSTALLED_COLORMAPS=83;
XCB_ALLOC_COLOR=84;
XCB_ALLOC_NAMED_COLOR=85;
XCB_ALLOC_COLOR_CELLS=86;
XCB_ALLOC_COLOR_PLANES=87;
XCB_FREE_COLORS=88;
XCB_COLOR_FLAG_RED=1;
XCB_COLOR_FLAG_GREEN=2;
XCB_COLOR_FLAG_BLUE=4;
XCB_STORE_COLORS=89;
XCB_STORE_NAMED_COLOR=90;
XCB_QUERY_COLORS=91;
XCB_LOOKUP_COLOR=92;
XCB_PIXMAP_NONE=0;
XCB_CREATE_CURSOR=93;
XCB_FONT_NONE=0;
XCB_CREATE_GLYPH_CURSOR=94;
XCB_FREE_CURSOR=95;
XCB_RECOLOR_CURSOR=96;
XCB_QUERY_SHAPE_OF_LARGEST_CURSOR=0;
XCB_QUERY_SHAPE_OF_FASTEST_TILE=1;
XCB_QUERY_SHAPE_OF_FASTEST_STIPPLE=2;
XCB_QUERY_BEST_SIZE=97;
XCB_QUERY_EXTENSION=98;
XCB_LIST_EXTENSIONS=99;
XCB_CHANGE_KEYBOARD_MAPPING=100;
XCB_GET_KEYBOARD_MAPPING=101;
XCB_KB_KEY_CLICK_PERCENT=1;
XCB_KB_BELL_PERCENT=2;
XCB_KB_BELL_PITCH=4;
XCB_KB_BELL_DURATION=8;
XCB_KB_LED=16;
XCB_KB_LED_MODE=32;
XCB_KB_KEY=64;
XCB_KB_AUTO_REPEAT_MODE=128;
XCB_LED_MODE_OFF=0;
XCB_LED_MODE_ON=1;
XCB_AUTO_REPEAT_MODE_OFF=0;
XCB_AUTO_REPEAT_MODE_ON=1;
XCB_AUTO_REPEAT_MODE_DEFAULT=2;
XCB_CHANGE_KEYBOARD_CONTROL=102;
XCB_GET_KEYBOARD_CONTROL=103;
XCB_BELL=104;
XCB_CHANGE_POINTER_CONTROL=105;
XCB_GET_POINTER_CONTROL=106;
XCB_BLANKING_NOT_PREFERRED=0;
XCB_BLANKING_PREFERRED=1;
XCB_BLANKING_DEFAULT=2;
XCB_EXPOSURES_NOT_ALLOWED=0;
XCB_EXPOSURES_ALLOWED=1;
XCB_EXPOSURES_DEFAULT=2;
XCB_SET_SCREEN_SAVER=107;
XCB_GET_SCREEN_SAVER=108;
XCB_HOST_MODE_INSERT=0;
XCB_HOST_MODE_DELETE=1;
XCB_FAMILY_INTERNET=0;
XCB_FAMILY_DECNET=1;
XCB_FAMILY_CHAOS=2;
XCB_FAMILY_SERVER_INTERPRETED=5;
XCB_FAMILY_INTERNET_6=6;
XCB_CHANGE_HOSTS=109;
XCB_LIST_HOSTS=110;
XCB_ACCESS_CONTROL_DISABLE=0;
XCB_ACCESS_CONTROL_ENABLE=1;
XCB_SET_ACCESS_CONTROL=111;
XCB_CLOSE_DOWN_DESTROY_ALL=0;
XCB_CLOSE_DOWN_RETAIN_PERMANENT=1;
XCB_CLOSE_DOWN_RETAIN_TEMPORARY=2;
XCB_SET_CLOSE_DOWN_MODE=112;
XCB_KILL_ALL_TEMPORARY=0;
XCB_KILL_CLIENT=113;
XCB_ROTATE_PROPERTIES=114;
XCB_SCREEN_SAVER_RESET=0;
XCB_SCREEN_SAVER_ACTIVE=1;
XCB_FORCE_SCREEN_SAVER=115;
XCB_MAPPING_STATUS_SUCCESS=0;
XCB_MAPPING_STATUS_BUSY=1;
XCB_MAPPING_STATUS_FAILURE=2;
XCB_SET_POINTER_MAPPING=116;
XCB_GET_POINTER_MAPPING=117;
XCB_MAP_INDEX_SHIFT=0;
XCB_MAP_INDEX_LOCK=1;
XCB_MAP_INDEX_CONTROL=2;
XCB_MAP_INDEX_1=3;
XCB_MAP_INDEX_2=4;
XCB_MAP_INDEX_3=5;
XCB_MAP_INDEX_4=6;
XCB_MAP_INDEX_5=7;
XCB_SET_MODIFIER_MAPPING=118;
XCB_GET_MODIFIER_MAPPING=119;
XCB_NO_OPERATION=127;
XCB_XV_MAJOR_VERSION=2;
XCB_XV_MINOR_VERSION=2;
XCB_XV_TYPE_INPUT_MASK=1;
XCB_XV_TYPE_OUTPUT_MASK=2;
XCB_XV_TYPE_VIDEO_MASK=4;
XCB_XV_TYPE_STILL_MASK=8;
XCB_XV_TYPE_IMAGE_MASK=16;
XCB_XV_IMAGE_FORMAT_INFO_TYPE_RGB=0;
XCB_XV_IMAGE_FORMAT_INFO_TYPE_YUV=1;
XCB_XV_IMAGE_FORMAT_INFO_FORMAT_PACKED=0;
XCB_XV_IMAGE_FORMAT_INFO_FORMAT_PLANAR=1;
XCB_XV_ATTRIBUTE_FLAG_GETTABLE=1;
XCB_XV_ATTRIBUTE_FLAG_SETTABLE=2;
XCB_XV_VIDEO_NOTIFY_REASON_STARTED=0;
XCB_XV_VIDEO_NOTIFY_REASON_STOPPED=1;
XCB_XV_VIDEO_NOTIFY_REASON_BUSY=2;
XCB_XV_VIDEO_NOTIFY_REASON_PREEMPTED=3;
XCB_XV_VIDEO_NOTIFY_REASON_HARD_ERROR=4;
XCB_XV_SCANLINE_ORDER_TOP_TO_BOTTOM=0;
XCB_XV_SCANLINE_ORDER_BOTTOM_TO_TOP=1;
XCB_XV_GRAB_PORT_STATUS_SUCCESS=0;
XCB_XV_GRAB_PORT_STATUS_BAD_EXTENSION=1;
XCB_XV_GRAB_PORT_STATUS_ALREADY_GRABBED=2;
XCB_XV_GRAB_PORT_STATUS_INVALID_TIME=3;
XCB_XV_GRAB_PORT_STATUS_BAD_REPLY=4;
XCB_XV_GRAB_PORT_STATUS_BAD_ALLOC=5;
XCB_XV_BAD_PORT=0;
XCB_XV_BAD_ENCODING=1;
XCB_XV_BAD_CONTROL=2;
XCB_XV_VIDEO_NOTIFY=0;
XCB_XV_PORT_NOTIFY=1;
XCB_XV_QUERY_EXTENSION=0;
XCB_XV_QUERY_ADAPTORS=1;
XCB_XV_QUERY_ENCODINGS=2;
XCB_XV_GRAB_PORT=3;
XCB_XV_UNGRAB_PORT=4;
XCB_XV_PUT_VIDEO=5;
XCB_XV_PUT_STILL=6;
XCB_XV_GET_VIDEO=7;
XCB_XV_GET_STILL=8;
XCB_XV_STOP_VIDEO=9;
XCB_XV_SELECT_VIDEO_NOTIFY=10;
XCB_XV_SELECT_PORT_NOTIFY=11;
XCB_XV_QUERY_BEST_SIZE=12;
XCB_XV_SET_PORT_ATTRIBUTE=13;
XCB_XV_GET_PORT_ATTRIBUTE=14;
XCB_XV_QUERY_PORT_ATTRIBUTES=15;
XCB_XV_LIST_IMAGE_FORMATS=16;
XCB_XV_QUERY_IMAGE_ATTRIBUTES=17;
XCB_XV_PUT_IMAGE=18;
XCB_XV_SHM_PUT_IMAGE=19;
// @defgroup XCB_XvMC_API XCB XvMC API
XCB_XVMC_MAJOR_VERSION=1;
XCB_XVMC_MINOR_VERSION=1;
XCB_XVMC_QUERY_VERSION=0;
XCB_XVMC_LIST_SURFACE_TYPES=1;
XCB_XVMC_CREATE_CONTEXT=2;
XCB_XVMC_DESTROY_CONTEXT=3;
XCB_XVMC_CREATE_SURFACE=4;
XCB_XVMC_DESTROY_SURFACE=5;
XCB_XVMC_CREATE_SUBPICTURE=6;
XCB_XVMC_DESTROY_SUBPICTURE=7;
XCB_XVMC_LIST_SUBPICTURE_TYPES=8;

implementation
end.